/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Predicate;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.diff.Node;
import com.google.protobuf.contrib.diff.Util;
import java.util.List;
import javax.annotation.Nullable;

public final class IgnoreCriterias {
    private IgnoreCriterias() {
    }

    public static MessageDifferencer.IgnoreCriteria fromNodePredicate(Predicate<Node> potentialDiffPredicate) {
        return new NodeBasedCriteria(potentialDiffPredicate);
    }

    public static MessageDifferencer.IgnoreCriteria fromFieldDescriptorPredicate(Predicate<Descriptors.FieldDescriptor> fieldDescriptorPredicate) {
        return new DescriptorBasedCriteria(fieldDescriptorPredicate);
    }

    public static MessageDifferencer.IgnoreCriteria fromPathPredicate(Predicate<String> indexlessLeafPathPredicate) {
        return new PathBasedCriteria(indexlessLeafPathPredicate);
    }

    private static final class PathBasedCriteria
    implements MessageDifferencer.IgnoreCriteria {
        private final Predicate<String> indexlessLeafPathPredicate;

        public PathBasedCriteria(Predicate<String> indexlessLeafPathPredicate) {
            this.indexlessLeafPathPredicate = indexlessLeafPathPredicate;
        }

        @Override
        public boolean isIgnored(Message message1, Message message2, @Nullable Descriptors.FieldDescriptor fieldDescriptor, List<MessageDifferencer.SpecificField> fieldPath) {
            if (fieldDescriptor == null) {
                return false;
            }
            String msgPath = Util.pathWithoutIndex(fieldPath, fieldDescriptor);
            return this.indexlessLeafPathPredicate.apply(msgPath);
        }
    }

    private static final class NodeBasedCriteria
    implements MessageDifferencer.IgnoreCriteria {
        private final Predicate<Node> potentialDiffPredicate;

        private NodeBasedCriteria(Predicate<Node> potentialDiffPredicate) {
            this.potentialDiffPredicate = potentialDiffPredicate;
        }

        @Override
        public boolean isIgnored(Message message1, Message message2, @Nullable Descriptors.FieldDescriptor fieldDescriptor, List<MessageDifferencer.SpecificField> fieldPath) {
            Node node = new Node(fieldPath, message1, message2, fieldDescriptor);
            return this.potentialDiffPredicate.apply(node);
        }
    }

    private static final class DescriptorBasedCriteria
    implements MessageDifferencer.IgnoreCriteria {
        private final Predicate<Descriptors.FieldDescriptor> ignorePredicate;

        DescriptorBasedCriteria(Predicate<Descriptors.FieldDescriptor> ignorePredicate) {
            this.ignorePredicate = ignorePredicate;
        }

        @Override
        public boolean isIgnored(Message message1, Message message2, @Nullable Descriptors.FieldDescriptor fieldDescriptor, List<MessageDifferencer.SpecificField> fieldPath) {
            return this.ignorePredicate.apply(fieldDescriptor);
        }
    }
}

