/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.collect.ImmutableList;
import com.google.common.labs.reflect.ValueType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.diff.Util;
import com.google.protobuf.contrib.protopath.FieldSpec;
import javax.annotation.Nullable;

public final class Node
extends ValueType {
    @Nullable
    private final Message firstValueContainer;
    @Nullable
    private final Message secondValueContainer;
    private final ImmutableList<MessageDifferencer.SpecificField> parentFieldPath;
    @Nullable
    private final Descriptors.FieldDescriptor leafFieldDescriptor;

    Node(Iterable<MessageDifferencer.SpecificField> parentFieldPath, Message firstValueContainer, Message secondValueContainer, Descriptors.FieldDescriptor leafFieldDescriptor) {
        this.leafFieldDescriptor = leafFieldDescriptor;
        this.firstValueContainer = firstValueContainer;
        this.secondValueContainer = secondValueContainer;
        this.parentFieldPath = ImmutableList.copyOf(parentFieldPath);
    }

    public Descriptors.FieldDescriptor getLeafFieldDescriptor() {
        return this.leafFieldDescriptor;
    }

    public String getIndexlessLeafPath() {
        return Util.pathWithoutIndex(this.parentFieldPath, this.leafFieldDescriptor);
    }

    public String getFirstParentPath() {
        return FieldSpec.join(Util.fieldPathToSpecs(this.parentFieldPath, Util.IndexChooser.ORIGINAL_INDEX), new FieldSpec[0]);
    }

    public String getFirstPath(int index) {
        return FieldSpec.join(this.getFirstParentPath(), this.leafPath(index));
    }

    @Nullable
    public <V> V getFirstValue(int index, Class<V> valueType) {
        return Util.getSingleTypedValue(this.firstValueContainer, this.leafFieldDescriptor, index, valueType);
    }

    public String getSecondParentPath() {
        return FieldSpec.join(Util.fieldPathToSpecs(this.parentFieldPath, Util.IndexChooser.NEW_INDEX), new FieldSpec[0]);
    }

    public String getSecondPath(int index) {
        return FieldSpec.join(this.getSecondParentPath(), this.leafPath(index));
    }

    @Nullable
    public <V> V getSecondValue(int index, Class<V> valueType) {
        return Util.getSingleTypedValue(this.secondValueContainer, this.leafFieldDescriptor, index, valueType);
    }

    private String leafPath(int index) {
        if (this.leafFieldDescriptor == null) {
            return "unknown";
        }
        if (this.leafFieldDescriptor.isRepeated()) {
            return FieldSpec.fromFieldDescriptor(this.leafFieldDescriptor, index).toString();
        }
        return FieldSpec.fromFieldDescriptor(this.leafFieldDescriptor, null).toString();
    }
}

