/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.contrib.diff.Node;
import javax.annotation.Nullable;

public final class NodePredicates {
    public static final Predicate<Descriptors.FieldDescriptor> DEPRECATED_FIELDS = new Predicate<Descriptors.FieldDescriptor>(){

        @Override
        public boolean apply(@Nullable Descriptors.FieldDescriptor fieldDescriptor) {
            return fieldDescriptor != null && fieldDescriptor.getOptions().getDeprecated();
        }
    };
    public static final Predicate<Descriptors.FieldDescriptor> UNKNOWN_FIELDS = new Predicate<Descriptors.FieldDescriptor>(){

        @Override
        public boolean apply(@Nullable Descriptors.FieldDescriptor fieldDescriptor) {
            return fieldDescriptor == null;
        }
    };
    public static final Predicate<Descriptors.FieldDescriptor> FIELD_EXTENSIONS = new Predicate<Descriptors.FieldDescriptor>(){

        @Override
        public boolean apply(@Nullable Descriptors.FieldDescriptor fieldDescriptor) {
            return fieldDescriptor != null && fieldDescriptor.isExtension();
        }
    };
    private static final Function<Node, Descriptors.FieldDescriptor> GET_FD = new Function<Node, Descriptors.FieldDescriptor>(){

        @Override
        @Nullable
        public Descriptors.FieldDescriptor apply(Node input) {
            return input.getLeafFieldDescriptor();
        }
    };
    private static final Function<Node, String> GET_INDEXLESS_LEAF_PATH = new Function<Node, String>(){

        @Override
        public String apply(Node input) {
            return input.getIndexlessLeafPath();
        }
    };

    private NodePredicates() {
    }

    public static final Predicate<String> newPrefixSlashPredicate(ImmutableSet<String> prefixes) {
        for (String prefix : prefixes) {
            Preconditions.checkArgument(!prefix.endsWith("/"));
        }
        return new PrefixSlashPredicate(prefixes);
    }

    public static Predicate<Node> fromFieldDescriptorPredicate(Predicate<Descriptors.FieldDescriptor> fieldDescriptorPredicate) {
        return Predicates.compose(fieldDescriptorPredicate, GET_FD);
    }

    public static Predicate<Node> fromIndexlessLeafPathPredicate(Predicate<String> indexlessLeafPathPredicate) {
        return Predicates.compose(indexlessLeafPathPredicate, GET_INDEXLESS_LEAF_PATH);
    }

    private static class PrefixSlashPredicate
    implements Predicate<String> {
        private final ImmutableSet<String> prefixes;

        private PrefixSlashPredicate(ImmutableSet<String> prefixes) {
            this.prefixes = prefixes;
        }

        @Override
        public boolean apply(String input) {
            if (this.prefixes.contains(input)) {
                return true;
            }
            for (String prefix : this.prefixes) {
                if (!input.startsWith(String.valueOf(prefix).concat("/"))) continue;
                return true;
            }
            return false;
        }
    }
}

