/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Extension;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.MessageUtils;
import com.google.protobuf.contrib.diff.ContextFreeDifferenceFilter;
import com.google.protobuf.contrib.diff.ContextGenerator;
import com.google.protobuf.contrib.diff.CustomComparator;
import com.google.protobuf.contrib.diff.DetailRecorder;
import com.google.protobuf.contrib.diff.DiffContext;
import com.google.protobuf.contrib.diff.DiffContextContributor;
import com.google.protobuf.contrib.diff.DifferConfig;
import com.google.protobuf.contrib.diff.DifferConfigOrBuilder;
import com.google.protobuf.contrib.diff.DifferenceFilter;
import com.google.protobuf.contrib.diff.DifferenceFilters;
import com.google.protobuf.contrib.diff.DifferenceProcessor;
import com.google.protobuf.contrib.diff.DifferenceProcessors;
import com.google.protobuf.contrib.diff.DiffingContext;
import com.google.protobuf.contrib.diff.DispatchingFieldComparatorBuilder;
import com.google.protobuf.contrib.diff.FieldKind;
import com.google.protobuf.contrib.diff.FieldValueComparator;
import com.google.protobuf.contrib.diff.FieldValueComparators;
import com.google.protobuf.contrib.diff.FilteringReporter;
import com.google.protobuf.contrib.diff.GlobalOptions;
import com.google.protobuf.contrib.diff.IgnoreCriterias;
import com.google.protobuf.contrib.diff.MapField;
import com.google.protobuf.contrib.diff.MapKeyComparator;
import com.google.protobuf.contrib.diff.MapKeyComparators;
import com.google.protobuf.contrib.diff.Node;
import com.google.protobuf.contrib.diff.NodePredicates;
import com.google.protobuf.contrib.diff.ProtoDiffResult;
import com.google.protobuf.contrib.diff.ProtoField;
import com.google.protobuf.contrib.diff.ProtoPathDifferenceFilter;
import com.google.protobuf.contrib.diff.RegularField;
import com.google.protobuf.contrib.diff.ReportOptions;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.protobuf.contrib.diff.ReportTypeOverrides;
import com.google.protobuf.contrib.diff.Resolver;
import com.google.protobuf.contrib.diff.SkipFieldSpec;
import com.google.protobuf.contrib.diff.Util;
import com.google.protobuf.contrib.protopath.ProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathCache;
import com.google.protobuf.contrib.protopath.SingleProtoPath;
import com.google.re2j.Pattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class ProtoDiffer<T extends Message> {
    private final Class<T> messageType;
    private final MessageDifferencer messageDifferencer;
    private final ImmutableList<DifferenceProcessor<T>> differenceProcessors;
    private final ImmutableSet<ReportType> ignoredReportTypes;
    private final ContextGenerator contextGenerator;
    private final boolean preCompress;
    private final ReportOptions reportOptions;
    @Nullable
    private final DispatchingFieldComparatorBuilder.CustomFieldComparator customFieldComparator;

    private ProtoDiffer(MessageDifferencer messageDifferencer, Class<T> messageType, Iterable<DifferenceProcessor<T>> differenceProcessors, Iterable<ReportType> ignoredReportTypes, Iterable<DiffContextContributor<?, ?>> diffContextContributors, Iterable<DiffContext> additionalContexts, boolean preCompress, ReportOptions reportOptions, @Nullable DispatchingFieldComparatorBuilder.CustomFieldComparator customFieldComparator, boolean unpackAny) {
        this.messageDifferencer = messageDifferencer;
        this.messageType = messageType;
        this.contextGenerator = new ContextGenerator(diffContextContributors, additionalContexts, unpackAny);
        this.differenceProcessors = ImmutableList.copyOf(differenceProcessors);
        this.ignoredReportTypes = ImmutableSet.copyOf(ignoredReportTypes);
        this.preCompress = preCompress;
        this.reportOptions = reportOptions;
        this.customFieldComparator = customFieldComparator;
    }

    public synchronized ProtoDiffResult diff(T first, T second) {
        return this.diff(first, second, DiffingContext.emptyContext());
    }

    public synchronized ProtoDiffResult diff(T first, T second, DiffingContext diffingContext) {
        DetailRecorder detailRecorder = new DetailRecorder(this.reportOptions);
        ReportTypeOverrides reportTypeOverrides = new ReportTypeOverrides();
        FilteringReporter<T> finalReporter = new FilteringReporter<T>(this.ignoredReportTypes, this.differenceProcessors, first, second, ImmutableList.of(detailRecorder), reportTypeOverrides, this.contextGenerator, diffingContext);
        if (this.preCompress) {
            first = (Message)this.messageType.cast(MessageUtils.compress(first.toBuilder()).build());
            second = (Message)this.messageType.cast(MessageUtils.compress(second.toBuilder()).build());
        }
        FieldValueComparator.ComparisonResult topLevelMessagesComparisonResult = FieldValueComparator.ComparisonResult.PUNT;
        if (this.customFieldComparator != null) {
            this.customFieldComparator.setReportTypeOverrides(reportTypeOverrides);
            topLevelMessagesComparisonResult = this.customFieldComparator.compareTopLevelMessages((Message)first, (Message)second);
        }
        if (topLevelMessagesComparisonResult == FieldValueComparator.ComparisonResult.PUNT) {
            this.messageDifferencer.compare((Message)first, (Message)second, finalReporter);
        } else {
            this.reportTopLevelMessageComparisonResult(finalReporter, reportTypeOverrides, topLevelMessagesComparisonResult, first, second);
        }
        return detailRecorder.toProtoDiffResult();
    }

    public static <M extends Message> Builder<M> newBuilder(Class<M> msgType) {
        Descriptors.Descriptor descriptor = ((Message)MessageUtils.getDefaultInstance(msgType)).getDescriptorForType();
        return ProtoDiffer.newBuilder(msgType, descriptor);
    }

    public static Builder<Message> newBuilder(Descriptors.Descriptor descriptor) {
        return ProtoDiffer.newBuilder(Message.class, descriptor);
    }

    private static <M extends Message> Builder<M> newBuilder(Class<M> msgType, Descriptors.Descriptor descriptor) {
        return new Builder(msgType, descriptor).ignoringReportTypes(ReportType.MATCHED);
    }

    private void reportTopLevelMessageComparisonResult(FilteringReporter<T> finalReporter, ReportTypeOverrides reportTypeOverrides, FieldValueComparator.ComparisonResult topLevelMessagesComparisonResult, T first, T second) {
        MessageDifferencer.ReportType reportType;
        switch (topLevelMessagesComparisonResult) {
            case SAME: {
                reportType = MessageDifferencer.ReportType.MATCHED;
                break;
            }
            case DIFFERENT: {
                reportType = MessageDifferencer.ReportType.MODIFIED;
                break;
            }
            case SKIP_COMPARISON: {
                reportType = MessageDifferencer.ReportType.MATCHED;
                reportTypeOverrides.setOverride("", ReportType.SKIPPED);
                break;
            }
            default: {
                String string = String.valueOf((Object)topLevelMessagesComparisonResult);
                throw new IllegalArgumentException(new StringBuilder(41 + String.valueOf(string).length()).append("Illegal comparison result for reporting: ").append(string).toString());
            }
        }
        finalReporter.report(reportType, (Message)first, (Message)second, ImmutableList.of());
    }

    public static final class Builder<M extends Message> {
        private final Class<M> msgType;
        private final Descriptors.Descriptor rootDescriptor;
        private final List<DifferenceProcessor<M>> differenceProcessors;
        private final List<DiffContextContributor<?, ?>> diffContextContributors;
        private final ImmutableSet.Builder<DiffContext> additionalRootContexts;
        private boolean preCompress = false;
        private final ProtoPathCache protoPathCache;
        private final DispatchingFieldComparatorBuilder dispatchingFieldComparatorBuilder;
        private final List<MessageDifferencer.IgnoreCriteria> contextFreeIgnoreCriterias;
        private final List<MessageDifferencer.IgnoreCriteria> contextSensitiveIgnoreCriterias;
        private final Multimap<Descriptors.FieldDescriptor, Descriptors.FieldDescriptor> mapFields;
        private final Map<Descriptors.FieldDescriptor, MapKeyComparators.MessageDifferenceMapKeyComparator<?>> mapFieldComparators;
        private final Set<Descriptors.FieldDescriptor> setFields;
        private final Set<Descriptors.FieldDescriptor> ignoredFields;
        private final Set<Descriptors.FieldDescriptor> skippedFields;
        private final Set<ReportType> ignoredReportTypes;
        private final Set<Descriptors.FieldDescriptor> unsetEqualsDefault;
        private boolean ignoreAllReservedFields = false;
        private final Set<Descriptors.Descriptor> ignoreReservedFieldsInMessage;
        private ReportOptions reportOptions = ReportOptions.VERBOSE;
        private MessageDifferencer.RepeatedFieldComparison repeatedFieldComparison = MessageDifferencer.RepeatedFieldComparison.AS_LIST;
        private boolean useApproximateComparisons = false;
        private boolean ignoreOneSideMessagesWithIgnoredFields = false;
        private boolean unpackAny = false;
        private final Resolver resolver;

        private Builder(Class<M> msgType, Descriptors.Descriptor descriptor) {
            this.msgType = msgType;
            this.rootDescriptor = descriptor;
            this.contextSensitiveIgnoreCriterias = new ArrayList<MessageDifferencer.IgnoreCriteria>();
            this.contextFreeIgnoreCriterias = new ArrayList<MessageDifferencer.IgnoreCriteria>();
            this.differenceProcessors = new ArrayList<DifferenceProcessor<M>>();
            this.diffContextContributors = new ArrayList();
            this.additionalRootContexts = ImmutableSet.builder();
            this.mapFields = HashMultimap.create();
            this.setFields = new HashSet<Descriptors.FieldDescriptor>();
            this.protoPathCache = new ProtoPathCache();
            this.dispatchingFieldComparatorBuilder = new DispatchingFieldComparatorBuilder();
            this.resolver = new Resolver(this.rootDescriptor);
            this.ignoredFields = new HashSet<Descriptors.FieldDescriptor>();
            this.skippedFields = new HashSet<Descriptors.FieldDescriptor>();
            this.unsetEqualsDefault = new HashSet<Descriptors.FieldDescriptor>();
            this.ignoredReportTypes = new HashSet<ReportType>();
            this.ignoreReservedFieldsInMessage = new HashSet<Descriptors.Descriptor>();
            this.mapFieldComparators = new HashMap();
        }

        public ImmutableList<String> getConfigParseErrors() {
            return this.resolver.getErrors();
        }

        public Builder<M> skipField(SkipFieldSpec skipFieldSpec) {
            DifferenceProcessor skipProcessor = DifferenceProcessors.forSkipFieldSpec(this.resolver, skipFieldSpec);
            if (skipProcessor != null) {
                this.addDifferenceProcessor(skipProcessor);
            }
            return this;
        }

        public Builder<M> parseConfig(DifferConfig differConfig) {
            Preconditions.checkArgument(differConfig.getMessageType().equals(this.rootDescriptor.getFullName()), "Cannot apply differ config for %s to differ for %s", (Object)differConfig.getMessageType(), (Object)this.rootDescriptor.getFullName());
            this.parseGlobalOptions(differConfig);
            for (Descriptors.FieldDescriptor fieldDescriptor : this.resolver.resolveProtoFields(differConfig.getIgnoreFieldList())) {
                this.ignoreField(fieldDescriptor);
            }
            for (Descriptors.FieldDescriptor fieldDescriptor : this.resolver.resolveProtoFields(differConfig.getSkipFieldList())) {
                this.skipField(fieldDescriptor);
            }
            if (differConfig.getIgnoreFieldsBelowCount() > 0) {
                ImmutableSet.Builder validPaths = ImmutableSet.builder();
                for (String indexlessPath : differConfig.getIgnoreFieldsBelowList()) {
                    if (this.resolver.resolveIndexlessPath(indexlessPath) == null) continue;
                    validPaths.add(indexlessPath);
                }
                this.ignoringFieldsBelowWithoutValidation((ImmutableSet<String>)validPaths.build());
            }
            for (Descriptors.FieldDescriptor fieldDescriptor : this.resolver.resolveProtoFields(differConfig.getSetFieldList())) {
                this.treatAsSet(fieldDescriptor);
            }
            for (MapField mapField : differConfig.getMapFieldList()) {
                Descriptors.FieldDescriptor repeatedField = this.resolveProtoField(mapField.getRepeatedField());
                if (repeatedField == null) continue;
                ImmutableList.Builder keyFields = ImmutableList.builder();
                boolean valid = true;
                for (String keyFieldName : mapField.getKeyFieldNameList()) {
                    Descriptors.FieldDescriptor keyField = this.resolver.resolveFieldDescriptor(repeatedField.getMessageType(), keyFieldName);
                    if (keyField != null) {
                        keyFields.add(keyField);
                        continue;
                    }
                    valid = false;
                    break;
                }
                if (!valid) continue;
                this.treatFieldsAsMapKey(repeatedField, (List<Descriptors.FieldDescriptor>)((Object)keyFields.build()));
            }
            for (ProtoField protoField : differConfig.getRevisionFieldList()) {
                this.withRevisionField(protoField);
            }
            for (CustomComparator customComparator : differConfig.getCustomComparatorList()) {
                this.addCustomComparator(customComparator);
            }
            for (Descriptors.FieldDescriptor fieldDescriptor : this.resolver.resolveProtoFields(differConfig.getUnsetEqualsDefaultList())) {
                this.treatUnsetAsDefault(fieldDescriptor);
            }
            for (String string : differConfig.getIgnoreReservedFieldsList()) {
                Descriptors.Descriptor descriptor = this.resolver.resolveMessageType(string);
                if (descriptor == null) continue;
                this.ignoreReservedFields(descriptor);
            }
            for (SkipFieldSpec skipFieldSpec : differConfig.getSkipFieldSpecList()) {
                DifferenceProcessor skipProcessor = DifferenceProcessors.forSkipFieldSpec(this.resolver, skipFieldSpec);
                if (skipProcessor == null) continue;
                this.addDifferenceProcessor(skipProcessor);
            }
            return this;
        }

        private void withRevisionField(ProtoField protoField) {
            if (!protoField.hasRegularField()) {
                this.resolver.addError("Unsupported field type '%s' in %s", protoField.getFieldTypeCase(), protoField);
                return;
            }
            RegularField regularField = protoField.getRegularField();
            switch (regularField.getFieldDefinitionCase()) {
                case FIELD_NAME: {
                    Descriptors.FieldDescriptor revisionField = this.resolveProtoField(protoField);
                    if (revisionField == null) break;
                    this.withRevisionField(revisionField);
                    break;
                }
                case FIELD_PATH: {
                    Descriptors.Descriptor messageType = this.resolver.resolveMessageType(regularField.getContainingMessageType());
                    if (messageType == null) {
                        return;
                    }
                    ProtoPath<MessageOrBuilder, Object> revisionFieldProtoPath = this.resolver.resolveFieldPath(messageType, regularField.getFieldPath());
                    if (revisionFieldProtoPath == null) {
                        return;
                    }
                    this.withRevisionField(messageType, revisionFieldProtoPath);
                    break;
                }
                default: {
                    this.resolver.addError("Unsupported field type '%s' in %s", regularField.getFieldDefinitionCase(), protoField);
                    return;
                }
            }
        }

        private void addCustomComparator(CustomComparator comparator) {
            Descriptors.FieldDescriptor fieldDescriptor = this.resolveProtoField(comparator.getField());
            if (fieldDescriptor == null) {
                return;
            }
            if (comparator.hasNumberComparison()) {
                try {
                    FieldValueComparator<Number> numberComparator = FieldValueComparators.newNumericComparator(fieldDescriptor, comparator.getNumberComparison());
                    this.withCustomComparator(fieldDescriptor, numberComparator, Number.class);
                }
                catch (IllegalArgumentException iae) {
                    this.resolver.addError("While processing %s: %s", comparator, iae.getMessage());
                }
            }
        }

        @Nullable
        public Descriptors.FieldDescriptor resolveProtoField(ProtoField protoField) {
            return this.resolver.resolveProtoField(protoField);
        }

        private void parseGlobalOptions(DifferConfigOrBuilder differConfig) {
            if (!differConfig.hasGlobalOptions()) {
                return;
            }
            GlobalOptions globalOptions = differConfig.getGlobalOptions();
            if (globalOptions.getCompressBeforeDiffing()) {
                this.compressBeforeDiffing();
            }
            if (globalOptions.getIgnoreModifiedAggregateChanges()) {
                this.ignoringModifiedAggregateChanges();
            }
            if (globalOptions.getIgnoreOneSidedMessageWithIgnoredFields()) {
                this.ignoreOneSidedMessageWithIgnoredFields();
            }
            if (globalOptions.getUnpackAny()) {
                this.unpackAny();
            }
            this.ignoringReportTypes(globalOptions.getIgnoreReportTypeList());
            if (!globalOptions.getIgnoreReportTypeList().contains(ReportType.MATCHED)) {
                this.reportMatches();
            }
            block6: for (FieldKind fieldKind : globalOptions.getIgnoreFieldsSatisfyingList()) {
                switch (fieldKind) {
                    case UNKNOWN_FIELDS: {
                        this.ignoringFieldsSatisfying(NodePredicates.UNKNOWN_FIELDS);
                        continue block6;
                    }
                    case DEPRECATED_FIELDS: {
                        this.ignoringFieldsSatisfying(NodePredicates.DEPRECATED_FIELDS);
                        continue block6;
                    }
                    case EXTENSION_FIELDS: {
                        this.ignoringFieldsSatisfying(NodePredicates.FIELD_EXTENSIONS);
                        continue block6;
                    }
                    case RESERVED_FIELDS: {
                        this.ignoreAllReservedFields();
                        continue block6;
                    }
                }
                this.resolver.addError("Ignoring unknown field kind '%s'", fieldKind);
            }
            if (globalOptions.getTreatAllRepeatedFieldsAsSet()) {
                this.treatAllRepeatedFieldsAsSet();
            }
        }

        public Builder<M> ignoreAllReservedFields() {
            this.ignoreAllReservedFields = true;
            return this;
        }

        public Builder<M> ignoreReservedFields(Descriptors.Descriptor descriptor) {
            this.ignoreReservedFieldsInMessage.add(descriptor);
            return this;
        }

        public Builder<M> treatUnsetAsDefault(Descriptors.FieldDescriptor fieldDescriptor) {
            this.unsetEqualsDefault.add(fieldDescriptor);
            return this;
        }

        public Builder<M> compressBeforeDiffing() {
            return this.compressBeforeDiffing(true);
        }

        public Builder<M> compressBeforeDiffing(boolean preCompress) {
            this.preCompress = preCompress;
            return this;
        }

        public Builder<M> ignoreOneSidedMessageWithIgnoredFields() {
            this.ignoreOneSideMessagesWithIgnoredFields = true;
            return this;
        }

        public Builder<M> setReportOptions(ReportOptions reportOptions) {
            this.reportOptions = reportOptions;
            return this;
        }

        public Builder<M> treatAllRepeatedFieldsAsSet() {
            this.repeatedFieldComparison = MessageDifferencer.RepeatedFieldComparison.AS_SET;
            return this;
        }

        public Builder<M> ignoringFieldsSatisfying(Predicate<Descriptors.FieldDescriptor> ... fieldDescriptorPredicates) {
            this.contextFreeIgnoreCriterias.add(IgnoreCriterias.fromFieldDescriptorPredicate(Predicates.or(fieldDescriptorPredicates)));
            return this;
        }

        public Builder<M> ignoreField(Descriptors.FieldDescriptor fieldDescriptor) {
            this.ignoredFields.add(fieldDescriptor);
            return this;
        }

        public Builder<M> skipField(Descriptors.FieldDescriptor fieldDescriptor) {
            this.skippedFields.add(fieldDescriptor);
            return this;
        }

        public Builder<M> ignoringNodesSatisfying(Predicate<Node> nodePredicate) {
            this.contextSensitiveIgnoreCriterias.add(IgnoreCriterias.fromNodePredicate(nodePredicate));
            return this;
        }

        public <V> Builder<M> withCustomComparator(Predicate<Node> nodePredicate, FieldValueComparator<V> fieldValueComparator, Class<V> valueType) {
            this.dispatchingFieldComparatorBuilder.addComparator(nodePredicate, fieldValueComparator, valueType);
            return this;
        }

        public <V> Builder<M> withCustomComparator(Descriptors.FieldDescriptor fieldDescriptor, FieldValueComparator<V> fieldValueComparator, Class<V> valueType) {
            this.dispatchingFieldComparatorBuilder.addComparator(Preconditions.checkNotNull(fieldDescriptor), fieldValueComparator, valueType);
            return this;
        }

        public <V> Builder<M> withRevisionField(Descriptors.Descriptor messageDescriptor, int revisionFieldNumber) {
            Descriptors.FieldDescriptor revisionFieldDescriptor = messageDescriptor.findFieldByNumber(revisionFieldNumber);
            return this.withRevisionField(revisionFieldDescriptor);
        }

        public <V> Builder<M> withRevisionField(Descriptors.Descriptor messageDescriptor, String revisionFieldPath) {
            return this.withRevisionField(messageDescriptor, ProtoPath.newBuilder().forMessageDescriptor(messageDescriptor).addPath(revisionFieldPath).build(Object.class));
        }

        private <V> Builder<M> withRevisionField(Descriptors.Descriptor messageDescriptor, ProtoPath<MessageOrBuilder, Object> revisionFieldProtoPath) {
            this.dispatchingFieldComparatorBuilder.addRevisionComparator(messageDescriptor, revisionFieldProtoPath);
            return this;
        }

        private <V> Builder<M> withRevisionField(Descriptors.FieldDescriptor revisionFieldDescriptor) {
            Preconditions.checkArgument(!revisionFieldDescriptor.isRepeated(), "A repeated revision subfield?");
            this.dispatchingFieldComparatorBuilder.addRevisionComparator(revisionFieldDescriptor.getContainingType(), revisionFieldDescriptor);
            return this;
        }

        public Builder<M> ignoringReportTypes(ReportType ... reportTypes) {
            return this.ignoringReportTypes(Arrays.asList(reportTypes));
        }

        public Builder<M> reportMatches() {
            this.ignoredReportTypes.remove(ReportType.MATCHED);
            return this;
        }

        private Builder<M> ignoringReportTypes(Collection<ReportType> reportTypes) {
            this.ignoredReportTypes.addAll(reportTypes);
            return this;
        }

        public Builder<M> ignoringModifiedAggregateChanges() {
            this.addContextFreeDifferenceFilter(new DifferenceFilters.FilterModifiedAggregates());
            return this;
        }

        public Builder<M> addDifferenceFilter(DifferenceFilter<M> differenceFilter) {
            return this.addDifferenceProcessor(differenceFilter);
        }

        @Deprecated
        public Builder<M> addContextFreeDifferenceFilter(ContextFreeDifferenceFilter differenceFilter) {
            return this.addContextFreeDifferenceProcessor(differenceFilter);
        }

        public Builder<M> addContextFreeDifferenceProcessor(DifferenceProcessor<?> differenceProcessor) {
            Preconditions.checkArgument(differenceProcessor.isContextFree(), "Provided processor is not context free");
            DifferenceProcessor<?> typeCastedDifferenceProcessor = differenceProcessor;
            return this.addDifferenceProcessor(typeCastedDifferenceProcessor);
        }

        public Builder<M> addDifferenceProcessor(DifferenceProcessor<M> differenceProcessor) {
            if (differenceProcessor instanceof ProtoPathDifferenceFilter) {
                ((ProtoPathDifferenceFilter)differenceProcessor).setProtoPathCache(this.protoPathCache);
            }
            this.differenceProcessors.add(differenceProcessor);
            return this;
        }

        public Builder<M> ignoringFieldsBelow(String indexlessFieldPath) {
            Util.resolveIndexlessFieldPath(this.rootDescriptor, indexlessFieldPath);
            this.contextSensitiveIgnoreCriterias.add(IgnoreCriterias.fromPathPredicate(NodePredicates.newPrefixSlashPredicate(ImmutableSet.of(indexlessFieldPath))));
            return this;
        }

        public Builder<M> ignoringFieldsBelow(ImmutableSet<String> indexlessFieldPathSet) {
            for (String indexlessFieldPath : indexlessFieldPathSet) {
                Util.resolveIndexlessFieldPath(this.rootDescriptor, indexlessFieldPath);
            }
            return this.ignoringFieldsBelowWithoutValidation(indexlessFieldPathSet);
        }

        private Builder<M> ignoringFieldsBelowWithoutValidation(ImmutableSet<String> indexlessFieldPathSet) {
            if (indexlessFieldPathSet.isEmpty()) {
                return this;
            }
            this.contextSensitiveIgnoreCriterias.add(IgnoreCriterias.fromPathPredicate(NodePredicates.newPrefixSlashPredicate(indexlessFieldPathSet)));
            return this;
        }

        public Builder<M> ignoringPathsMatching(String indexlessRegex) {
            final Pattern pattern = Pattern.compile(indexlessRegex);
            return this.ignoringNodesSatisfying(NodePredicates.fromIndexlessLeafPathPredicate(new Predicate<String>(this){

                @Override
                public boolean apply(String path) {
                    return pattern.matcher(path).matches();
                }
            }));
        }

        public Builder<M> treatAsMap(Descriptors.FieldDescriptor field, int keyFieldNumber) {
            return this.treatAsMap(field, ImmutableList.of(Integer.valueOf(keyFieldNumber)));
        }

        public Builder<M> treatAsMap(Descriptors.FieldDescriptor field, List<Integer> keyFieldNumbers) {
            Descriptors.Descriptor messageType = field.getMessageType();
            ArrayList<Descriptors.FieldDescriptor> keyFields = new ArrayList<Descriptors.FieldDescriptor>();
            for (Integer keyFieldNumber : keyFieldNumbers) {
                Descriptors.FieldDescriptor key = messageType.findFieldByNumber(keyFieldNumber);
                Preconditions.checkNotNull(key, "Message %s has no field with tag %s", (Object)messageType.getFullName(), (Object)keyFieldNumber);
                keyFields.add(key);
            }
            return this.treatFieldsAsMapKey(field, keyFields);
        }

        public <V extends Message> Builder<M> treatAsMap(Descriptors.FieldDescriptor field, MapKeyComparator<V> mapKeyComparator, Class<V> vClass) {
            Preconditions.checkArgument(field.isRepeated());
            Preconditions.checkArgument(field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE, "only repeated message valued fields are supported");
            Preconditions.checkArgument(!this.mapFields.containsKey(field), "Field %s already has a treatAsMap entry.");
            Descriptors.Descriptor expectedMsgDescriptor = field.getMessageType();
            Descriptors.Descriptor actualMsgDescriptor = ((Message)MessageUtils.getDefaultInstance(vClass)).getDescriptorForType();
            Preconditions.checkArgument(expectedMsgDescriptor == actualMsgDescriptor, "Provided class corresponds to message %s but field has type %s", (Object)actualMsgDescriptor, (Object)expectedMsgDescriptor);
            this.mapFieldComparators.put(field, new MapKeyComparators.MessageDifferenceMapKeyComparator<V>(vClass, mapKeyComparator));
            return this;
        }

        public Builder<M> treatAsMap(Descriptors.FieldDescriptor field, String keyPath) {
            Preconditions.checkArgument(field.isRepeated());
            Preconditions.checkArgument(field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE, "only repeated message valued fields are supported");
            Preconditions.checkArgument(!this.mapFields.containsKey(field), "Field %s already has a treatAsMap entry.");
            Descriptors.Descriptor msgDescriptor = field.getMessageType();
            final SingleProtoPath<MessageOrBuilder, Object> protoPath = ProtoPath.newBuilder().forMessageDescriptor(msgDescriptor).addPath(keyPath).build(Object.class);
            MapKeyComparator<Message> keyComparator = new MapKeyComparator<Message>(this){

                @Override
                public boolean matches(Message first, Message second) {
                    ImmutableList firstKey = protoPath.evaluate(first);
                    ImmutableList secondKey = protoPath.evaluate(second);
                    return Objects.equals(firstKey, secondKey);
                }
            };
            this.mapFieldComparators.put(field, new MapKeyComparators.MessageDifferenceMapKeyComparator<Message>(Message.class, keyComparator));
            return this;
        }

        private Builder<M> treatFieldsAsMapKey(Descriptors.FieldDescriptor field, List<Descriptors.FieldDescriptor> keyFields) {
            Preconditions.checkArgument(field.isRepeated());
            Preconditions.checkArgument(!this.mapFieldComparators.containsKey(field), "Field %s already has a custom comparator for treatAsMap.");
            for (Descriptors.FieldDescriptor keyField : keyFields) {
                Preconditions.checkArgument(field.getMessageType() == keyField.getContainingType());
            }
            if (this.mapFields.containsKey(field)) {
                this.mapFields.removeAll(field);
            }
            this.mapFields.putAll(field, keyFields);
            return this;
        }

        public Builder<M> treatAsSet(Descriptors.FieldDescriptor field) {
            Preconditions.checkArgument(field.isRepeated());
            this.setFields.add(field);
            return this;
        }

        private boolean isContextFree() {
            if (!this.contextSensitiveIgnoreCriterias.isEmpty()) {
                return false;
            }
            for (DifferenceProcessor<M> differenceProcessor : this.differenceProcessors) {
                if (differenceProcessor.isContextFree()) continue;
                return false;
            }
            return true;
        }

        private String contextSensitiveReason() {
            if (this.isContextFree()) {
                return "Differ is actually ContextFree";
            }
            String msg = String.format("Differ for %s is context sensitive.\n", this.rootDescriptor.getFullName());
            ArrayList<DifferenceProcessor<M>> csProcessors = new ArrayList<DifferenceProcessor<M>>();
            for (DifferenceProcessor<M> differenceProcessor : this.differenceProcessors) {
                if (differenceProcessor.isContextFree()) continue;
                csProcessors.add(differenceProcessor);
            }
            String csFilters = String.format("ContextSensitive processors: %s\n", csProcessors.isEmpty() ? "none" : csProcessors);
            String csIgnoreCriteria = String.format("ContextSensitive ignore criteria: %s\n", this.contextSensitiveIgnoreCriterias.isEmpty() ? "none" : this.contextSensitiveIgnoreCriterias);
            return new StringBuilder(String.valueOf(msg).length() + String.valueOf(csFilters).length() + String.valueOf(csIgnoreCriteria).length()).append(msg).append(csFilters).append(csIgnoreCriteria).toString();
        }

        public Builder<M> addDiffContextContributor(DiffContextContributor<? extends Message, ? extends Message> diffContextContributor) {
            this.diffContextContributors.add(diffContextContributor);
            return this;
        }

        public <C extends Message> Builder<M> addRootDiffContext(Extension<DiffContext, C> extension, C payload) {
            this.additionalRootContexts.add((Object)((DiffContext.Builder)DiffContext.newBuilder().setFirstPath("").setSecondPath("").setExtension(extension, payload)).build());
            return this;
        }

        public <C extends Message> Builder<M> addRootDiffContext(Any context) {
            this.additionalRootContexts.add((Object)DiffContext.newBuilder().setAnyContext(context).build());
            return this;
        }

        public <S extends Message> Builder<M> mergeFrom(Builder<S> otherBuilder) {
            if (!super.isContextFree()) {
                String errMsg = String.format("Cannot merge in a context sensitive differ: %s", super.contextSensitiveReason());
                throw new IllegalArgumentException(errMsg);
            }
            this.mapFields.putAll(otherBuilder.mapFields);
            this.mapFieldComparators.putAll(otherBuilder.mapFieldComparators);
            this.setFields.addAll(otherBuilder.setFields);
            this.diffContextContributors.addAll(otherBuilder.diffContextContributors);
            Iterator<DifferenceProcessor<M>> iterator = otherBuilder.differenceProcessors.iterator();
            while (iterator.hasNext()) {
                DifferenceProcessor<M> otherProcessor;
                DifferenceProcessor<M> typeCastedProcessor = otherProcessor = iterator.next();
                this.differenceProcessors.add(typeCastedProcessor);
            }
            this.contextFreeIgnoreCriterias.addAll(otherBuilder.contextFreeIgnoreCriterias);
            this.dispatchingFieldComparatorBuilder.mergeFrom(otherBuilder.dispatchingFieldComparatorBuilder);
            this.ignoredFields.addAll(otherBuilder.ignoredFields);
            this.skippedFields.addAll(otherBuilder.skippedFields);
            this.unsetEqualsDefault.addAll(otherBuilder.unsetEqualsDefault);
            this.additionalRootContexts.addAll((Iterable)otherBuilder.additionalRootContexts.build());
            this.ignoredReportTypes.addAll(otherBuilder.ignoredReportTypes);
            this.ignoreReservedFieldsInMessage.addAll(otherBuilder.ignoreReservedFieldsInMessage);
            return this;
        }

        public <S extends Message> Builder<M> useApproximateComparisons() {
            this.useApproximateComparisons = true;
            return this;
        }

        public Builder<M> unpackAny() {
            this.unpackAny = true;
            return this;
        }

        public ProtoDiffer<M> build() {
            MessageDifferencer.Builder differencerBuilder = MessageDifferencer.newBuilder().setReportMatches(true).setRepeatedFieldComparison(this.repeatedFieldComparison);
            DispatchingFieldComparatorBuilder.CustomFieldComparator customFieldComparator = this.configureFieldComparator(differencerBuilder);
            for (MessageDifferencer.IgnoreCriteria ignoreCriteria : Iterables.concat(this.contextFreeIgnoreCriterias, this.contextSensitiveIgnoreCriterias)) {
                differencerBuilder.addIgnoreCriteria(ignoreCriteria);
            }
            if (!this.ignoredFields.isEmpty()) {
                differencerBuilder.addIgnoreCriteria(IgnoreCriterias.fromFieldDescriptorPredicate(Predicates.in(this.ignoredFields)));
            }
            for (Descriptors.FieldDescriptor fieldDescriptor : this.setFields) {
                differencerBuilder.treatAsSet(fieldDescriptor);
            }
            for (Descriptors.FieldDescriptor fieldDescriptor : this.mapFields.keySet()) {
                Collection<Descriptors.FieldDescriptor> values = this.mapFields.get(fieldDescriptor);
                if (values.size() == 1) {
                    differencerBuilder.treatAsMap(fieldDescriptor, Iterables.getOnlyElement(values));
                    continue;
                }
                differencerBuilder.treatAsMapWithMultipleFieldsAsKey(fieldDescriptor, ImmutableList.copyOf(values));
            }
            for (Map.Entry entry : this.mapFieldComparators.entrySet()) {
                differencerBuilder.treatAsMapUsingKeyComparator((Descriptors.FieldDescriptor)entry.getKey(), (MessageDifferencer.MapKeyComparator)entry.getValue());
            }
            differencerBuilder.setUnpackAny(this.unpackAny);
            ArrayList<DifferenceProcessor<M>> allProcessors = new ArrayList<DifferenceProcessor<M>>(this.differenceProcessors);
            if (this.ignoreAllReservedFields || !this.ignoreReservedFieldsInMessage.isEmpty()) {
                allProcessors.add(new DifferenceProcessors.IgnoreReservedFieldsProcessor(this.ignoreReservedFieldsInMessage, this.ignoreAllReservedFields));
            }
            if (!this.skippedFields.isEmpty()) {
                allProcessors.add(new DifferenceProcessors.SkipFieldsProcessor(this.skippedFields));
            }
            if (!this.unsetEqualsDefault.isEmpty()) {
                DifferenceFilters.UnsetEqualsDefaultFilter unsetEqualsDefaultFilter = new DifferenceFilters.UnsetEqualsDefaultFilter(this.unsetEqualsDefault);
                allProcessors.add(unsetEqualsDefaultFilter);
            }
            if (this.ignoreOneSideMessagesWithIgnoredFields) {
                DifferenceFilters.IgnoreOneSidedMessagesWithGivenFields ignoreOneSidedMessagesWithGivenFields = new DifferenceFilters.IgnoreOneSidedMessagesWithGivenFields(this.ignoredFields, this.unsetEqualsDefault, this.preCompress);
                allProcessors.add(ignoreOneSidedMessagesWithGivenFields);
            }
            return new ProtoDiffer(differencerBuilder.build(), this.msgType, allProcessors, this.ignoredReportTypes, this.diffContextContributors, this.additionalRootContexts.build(), this.preCompress, this.reportOptions, customFieldComparator, this.unpackAny);
        }

        @Nullable
        private DispatchingFieldComparatorBuilder.CustomFieldComparator configureFieldComparator(MessageDifferencer.Builder differencerBuilder) {
            MessageDifferencer.FloatComparison floatComparison = this.useApproximateComparisons ? MessageDifferencer.FloatComparison.APPROXIMATE : MessageDifferencer.FloatComparison.EXACT;
            MessageDifferencer.DefaultFieldComparator defaultFieldComparator = new MessageDifferencer.DefaultFieldComparator(floatComparison);
            MessageDifferencer.FieldComparator fieldComparator = this.dispatchingFieldComparatorBuilder.build(defaultFieldComparator);
            differencerBuilder.setFloatComparison(floatComparison).setFieldComparator(fieldComparator);
            return this.dispatchingFieldComparatorBuilder.hasCustomizations() ? (DispatchingFieldComparatorBuilder.CustomFieldComparator)fieldComparator : null;
        }
    }
}

