/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.logging.FormattingLogger;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.contrib.diff.Difference;
import com.google.protobuf.contrib.diff.DifferenceFilter;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.ProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathCache;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import java.util.Map;
import java.util.logging.Level;

public abstract class ProtoPathDifferenceFilter<T extends Message>
extends DifferenceFilter<T> {
    private static final FormattingLogger logger = FormattingLogger.getLoggerForCallerClass();
    @LazyInit
    private ProtoPathCache protoPathCache = null;

    @Override
    public final boolean ignoreDifference(Difference<T> difference) {
        try {
            return this.doIgnoreDifference(difference);
        }
        catch (ProtoPathException e) {
            logger.logp(Level.SEVERE, "com.google.protobuf.contrib.diff.ProtoPathDifferenceFilter", "ignoreDifference", "Error processing the diff. Keeping the difference.", (Throwable)e);
            return false;
        }
    }

    protected ProtoPathCache getProtoPathCache() {
        if (this.protoPathCache == null) {
            throw new IllegalStateException("setProtoPathCache has not been called.");
        }
        return this.protoPathCache;
    }

    void setProtoPathCache(ProtoPathCache protoPathCache) {
        this.protoPathCache = Preconditions.checkNotNull(protoPathCache);
    }

    protected <P, Q> ImmutableList<Q> evaluatePathRelativeToFirstField(Difference<T> difference, Class<P> fieldType, String relPath, Class<Q> relativeFieldType) throws ProtoPathException {
        return this.getPathRelativeToFirstField(difference, fieldType, relPath, relativeFieldType).evaluate();
    }

    protected <P, Q> ProtoPathForMessage<T, Q> getPathRelativeToFirstField(Difference<T> difference, Class<P> fieldType, String relPath, Class<Q> relativeFieldType) throws ProtoPathException {
        MessageLite messageOfContainerType = difference.getFirstMessage().getDefaultInstanceForType();
        ProtoPath<MessageLite, Q> relativePath = this.getProtoPathCache().getCompiledRelativePath(messageOfContainerType, difference.getFirstPath(), fieldType, relPath, relativeFieldType);
        return new ProtoPathForMessage(relativePath, (Message)difference.getFirstMessage(), difference.getDiffingContext().getCtx(), null);
    }

    protected <P, Q> ImmutableList<Q> evaluatePathRelativeToSecondField(Difference<T> difference, Class<P> fieldType, String relPath, Class<Q> relativeFieldType) throws ProtoPathException {
        return this.getPathRelativeToSecondField(difference, fieldType, relPath, relativeFieldType).evaluate();
    }

    protected <P, Q> ProtoPathForMessage<T, Q> getPathRelativeToSecondField(Difference<T> difference, Class<P> fieldType, String relPath, Class<Q> relativeFieldType) throws ProtoPathException {
        ProtoPath<T, Q> relativePath = this.getProtoPathCache().getCompiledRelativePath(difference.getFirstMessage(), difference.getSecondPath(), fieldType, relPath, relativeFieldType);
        return new ProtoPathForMessage(relativePath, (Message)difference.getSecondMessage(), difference.getDiffingContext().getCtx(), null);
    }

    public abstract boolean doIgnoreDifference(Difference<T> var1) throws ProtoPathException;

    public static final class ProtoPathForMessage<M extends Message, N> {
        private final ProtoPath<M, N> protoPath;
        private final M message;
        private final EvaluationContext evaluationContext;

        private ProtoPathForMessage(ProtoPath<M, N> protoPath, M message, EvaluationContext evaluationContext) {
            this.protoPath = protoPath;
            this.message = message;
            this.evaluationContext = evaluationContext;
        }

        public ImmutableList<N> evaluate() {
            return this.protoPath.evaluate(this.message, this.evaluationContext);
        }

        public ImmutableList<N> evaluate(Map<String, Object> additionalValues) {
            EvaluationContext addlCtx = EvaluationContext.newContext(additionalValues);
            EvaluationContext merged = EvaluationContext.merge(addlCtx, this.evaluationContext);
            return this.protoPath.evaluate(this.message, merged);
        }

        /* synthetic */ ProtoPathForMessage(ProtoPath x0, Message x1, EvaluationContext x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

