/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.descriptor.pool.GeneratedDescriptorPool;
import com.google.protobuf.contrib.diff.ProtoField;
import com.google.protobuf.contrib.diff.RegularField;
import com.google.protobuf.contrib.diff.Util;
import com.google.protobuf.contrib.protopath.ProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

final class Resolver {
    private final List<String> errors;
    private final ExtensionRegistry extensionRegistry;
    private final GeneratedDescriptorPool descriptorPool;
    private final Descriptors.Descriptor rootDescriptor;

    Resolver(Descriptors.Descriptor rootDescriptor) {
        this.rootDescriptor = rootDescriptor;
        this.errors = new ArrayList<String>();
        this.extensionRegistry = ExtensionRegistry.getGeneratedRegistry();
        this.descriptorPool = GeneratedDescriptorPool.getInstance();
    }

    @Nullable
    Descriptors.FieldDescriptor resolveExtensionName(String extensionName) {
        ExtensionRegistry.ExtensionInfo extensionInfo = this.extensionRegistry.findImmutableExtensionByName(extensionName);
        if (extensionInfo == null) {
            this.addError("Unable to find extension with name '%s'", extensionName);
            return null;
        }
        return extensionInfo.descriptor;
    }

    @Nullable
    Descriptors.FieldDescriptor resolveFieldDescriptor(Descriptors.Descriptor containingType, String fieldName) {
        Descriptors.FieldDescriptor field = containingType.findFieldByName(fieldName);
        if (field == null) {
            this.addError("Message %s has no field named '%s'", containingType.getFullName(), fieldName);
        }
        return field;
    }

    @Nullable
    ProtoPath<MessageOrBuilder, Object> resolveFieldPath(Descriptors.Descriptor messageDescriptor, String fieldPath) {
        try {
            return ProtoPath.newBuilder().forMessageDescriptor(messageDescriptor).addPath(fieldPath).build(Object.class);
        }
        catch (ProtoPathException protoPathException) {
            this.addError("Exception while building ProtoPath for message descriptor name: '%s', field path: '%s', ProtoPathException: '%s'", messageDescriptor.getFullName(), fieldPath, protoPathException.getMessage());
            return null;
        }
    }

    @Nullable
    Descriptors.Descriptor resolveMessageType(String messageType) {
        Descriptors.Descriptor messageDescriptor = this.descriptorPool.getDescriptorForTypeName(messageType);
        if (messageDescriptor == null) {
            this.addError("Unable to resolve message type: '%s'", messageType);
        }
        return messageDescriptor;
    }

    @Nullable
    Descriptors.FieldDescriptor resolveProtoField(ProtoField protoField) {
        switch (protoField.getFieldTypeCase()) {
            case EXTENSION_NAME: {
                return this.resolveExtensionName(protoField.getExtensionName());
            }
            case REGULAR_FIELD: {
                return this.resolveRegularField(protoField.getRegularField());
            }
        }
        this.addError("Unsupported field type '%s' in %s", protoField.getFieldTypeCase(), protoField);
        return null;
    }

    @Nullable
    Descriptors.FieldDescriptor resolveRegularField(RegularField regularField) {
        Descriptors.Descriptor containingType = this.resolveMessageType(regularField.getContainingMessageType());
        if (containingType == null) {
            return null;
        }
        switch (regularField.getFieldDefinitionCase()) {
            case FIELD_NAME: {
                return this.resolveFieldDescriptor(containingType, regularField.getFieldName());
            }
        }
        this.addError("Unsupported field definition '%s' in %s", regularField.getFieldDefinitionCase(), regularField);
        return null;
    }

    List<Descriptors.FieldDescriptor> resolveProtoFields(Collection<ProtoField> protoFields) {
        ArrayList<Descriptors.FieldDescriptor> fieldDescriptors = new ArrayList<Descriptors.FieldDescriptor>();
        for (ProtoField protoField : protoFields) {
            Descriptors.FieldDescriptor resolvedProtoField = this.resolveProtoField(protoField);
            if (resolvedProtoField == null) continue;
            fieldDescriptors.add(resolvedProtoField);
        }
        return fieldDescriptors;
    }

    @Nullable
    Descriptors.FieldDescriptor resolveIndexlessPath(String indexlessPath) {
        try {
            return Util.resolveIndexlessFieldPath(this.rootDescriptor, indexlessPath);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.addError("Unable to resolve path %s relative to message %s. Reason: %s", indexlessPath, this.rootDescriptor.getFullName(), e.getMessage());
            return null;
        }
    }

    ImmutableList<String> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    void addError(String format, Object ... args) {
        this.errors.add(String.format(format, args));
    }
}

