/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.StringValue;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.MessageUtils;
import com.google.protobuf.contrib.diff.EnumValue;
import com.google.protobuf.contrib.protopath.FieldSpec;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

final class Util {
    private static final String INTERNAL_TYPE_URL_FORMAT = "type.googleprod.com/%s";
    private static final String EXTERNAL_TYPE_URL_FORMAT = "type.googleapis.com/%s";

    private Util() {
    }

    static FieldSpec toFieldSpec(MessageDifferencer.SpecificField specificField, IndexChooser indexChooser) {
        Descriptors.FieldDescriptor fieldDescriptor = specificField.getField();
        Integer index = indexChooser.getIndex(specificField);
        if (index < 0) {
            index = null;
        }
        if (fieldDescriptor != null) {
            return FieldSpec.fromFieldDescriptor(fieldDescriptor, index);
        }
        return FieldSpec.forUnknownTag(specificField.getUnknown().getFieldNumber());
    }

    static ImmutableList<FieldSpec> fieldPathToSpecs(ImmutableList<MessageDifferencer.SpecificField> fieldPath, IndexChooser indexChooser) {
        ImmutableList.Builder fieldSpecsBuilder = ImmutableList.builder();
        for (MessageDifferencer.SpecificField specificField : fieldPath) {
            fieldSpecsBuilder.add((Object)Util.toFieldSpec(specificField, indexChooser));
        }
        return fieldSpecsBuilder.build();
    }

    private static String asStringWithoutIndex(MessageDifferencer.SpecificField specificField) {
        if (specificField.getField() != null) {
            return Util.asStringWithoutIndex(specificField.getField());
        }
        MessageDifferencer.UnknownDescriptor unknownDescriptor = Preconditions.checkNotNull(specificField.getUnknown());
        return Integer.toString(unknownDescriptor.getFieldNumber());
    }

    private static String asStringWithoutIndex(Descriptors.FieldDescriptor fieldDescriptor) {
        FieldSpec fieldSpec = FieldSpec.fromFieldDescriptor(fieldDescriptor, null);
        if (fieldSpec.getName() != null) {
            return fieldSpec.getName();
        }
        return Integer.toString(fieldSpec.getTagNumber());
    }

    static String pathWithoutIndex(Iterable<MessageDifferencer.SpecificField> fieldPath) {
        ArrayList<String> parts = new ArrayList<String>();
        for (MessageDifferencer.SpecificField specificField : fieldPath) {
            parts.add(Util.asStringWithoutIndex(specificField));
        }
        return FieldSpec.SLASH_JOINER.join(parts);
    }

    static String pathWithoutIndex(Iterable<MessageDifferencer.SpecificField> fieldPath, Descriptors.FieldDescriptor leafDescriptor) {
        return FieldSpec.join(Util.pathWithoutIndex(fieldPath), Util.asStringWithoutIndex(leafDescriptor));
    }

    @Nullable
    static <V> V getSingleTypedValue(Message container, @Nullable Descriptors.FieldDescriptor fieldDescriptor, int index, Class<V> valueType) {
        Object untyped = Util.getUntypedValue(container, fieldDescriptor, index);
        if (untyped == null) {
            return null;
        }
        return Util.massageSingleValue(untyped, valueType);
    }

    @Nullable
    static Object getUntypedValue(Message container, @Nullable Descriptors.FieldDescriptor fieldDescriptor, int index) {
        if (fieldDescriptor == null) {
            return null;
        }
        if (fieldDescriptor.isRepeated()) {
            int count = container.getRepeatedFieldCount(fieldDescriptor);
            if (index < 0 || index >= count) {
                return null;
            }
            return container.getRepeatedField(fieldDescriptor, index);
        }
        if (container.hasField(fieldDescriptor)) {
            return container.getField(fieldDescriptor);
        }
        return null;
    }

    @Nullable
    static UnknownFieldSet.Field getUnknownField(Message firstValueContainer, MessageDifferencer.UnknownDescriptor unknown, int index) {
        UnknownFieldSet unknownFieldSet = firstValueContainer.getUnknownFields();
        if (!unknownFieldSet.hasField(unknown.getFieldNumber())) {
            return null;
        }
        return unknownFieldSet.getField(unknown.getFieldNumber());
    }

    private static String getTypeUrl(Descriptors.GenericDescriptor descriptor) {
        Descriptors.FileDescriptor fileDescriptor = descriptor.getFile();
        if (fileDescriptor.getName().startsWith("google/")) {
            return String.format(EXTERNAL_TYPE_URL_FORMAT, descriptor.getFullName());
        }
        return String.format(INTERNAL_TYPE_URL_FORMAT, descriptor.getFullName());
    }

    static Any toAny(Object value, Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            throw new IllegalArgumentException("Does not support enums");
        }
        return Util.toAny(Util.toAnyPayload(value, fieldDescriptor.getType()));
    }

    static Any toAny(Message message) {
        return Any.newBuilder().setTypeUrl(Util.getTypeUrl(message.getDescriptorForType())).setValue(message.toByteString()).build();
    }

    static EnumValue toEnumValue(Object value, Descriptors.FieldDescriptor fieldDescriptor) {
        Descriptors.EnumValueDescriptor enumValueDescriptor = (Descriptors.EnumValueDescriptor)value;
        return EnumValue.newBuilder().setEnumTypeUrl(Util.getTypeUrl(enumValueDescriptor.getType())).setName(enumValueDescriptor.getName()).build();
    }

    private static Message toAnyPayload(Object value, Descriptors.FieldDescriptor.Type fieldDescriptorType) {
        switch (fieldDescriptorType) {
            case MESSAGE: 
            case GROUP: {
                return (Message)value;
            }
            case BOOL: {
                return BoolValue.newBuilder().setValue((Boolean)value).build();
            }
            case INT32: 
            case FIXED32: 
            case SINT32: 
            case SFIXED32: {
                return Int32Value.newBuilder().setValue((Integer)value).build();
            }
            case UINT32: {
                return UInt32Value.newBuilder().setValue((Integer)value).build();
            }
            case INT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return Int64Value.newBuilder().setValue((Long)value).build();
            }
            case UINT64: {
                return UInt64Value.newBuilder().setValue((Long)value).build();
            }
            case DOUBLE: {
                return DoubleValue.newBuilder().setValue((Double)value).build();
            }
            case FLOAT: {
                return FloatValue.newBuilder().setValue(((Float)value).floatValue()).build();
            }
            case BYTES: {
                return BytesValue.newBuilder().setValue((ByteString)value).build();
            }
            case STRING: {
                return StringValue.newBuilder().setValue((String)value).build();
            }
        }
        String string = String.valueOf((Object)fieldDescriptorType);
        throw new AssertionError((Object)new StringBuilder(34 + String.valueOf(string).length()).append("Programming error, no support for ").append(string).toString());
    }

    static <V> V massageSingleValue(Object value, Class<V> valueType) {
        Preconditions.checkArgument(!(value instanceof Collection));
        if (ProtocolMessageEnum.class.isAssignableFrom(valueType)) {
            Preconditions.checkArgument(value instanceof Descriptors.EnumValueDescriptor);
            return valueType.cast(MessageUtils.getEnumValue((Descriptors.EnumValueDescriptor)value, valueType));
        }
        return valueType.cast(value);
    }

    public static Descriptors.FieldDescriptor resolveIndexlessFieldPath(Descriptors.Descriptor rootDescriptor, String indexlessFieldPath) {
        Descriptors.Descriptor msgDescriptor = rootDescriptor;
        Descriptors.FieldDescriptor fieldDescriptor = null;
        ExtensionRegistry registry = ExtensionRegistry.getGeneratedRegistry();
        for (FieldSpec fieldSpec : FieldSpec.split(indexlessFieldPath)) {
            Preconditions.checkArgument(!fieldSpec.hasIndex());
            Preconditions.checkNotNull(msgDescriptor, "Unable to resolve [%s] for message [%s]", (Object)indexlessFieldPath, (Object)rootDescriptor.getFullName());
            String name = fieldSpec.getName();
            fieldDescriptor = Util.resolveFieldOrExtension(msgDescriptor, name, registry);
            Preconditions.checkArgument(fieldDescriptor != null, "Message [%s] doesn't have a field/extension [%s]", (Object)msgDescriptor.getFullName(), (Object)name);
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                msgDescriptor = null;
                continue;
            }
            msgDescriptor = fieldDescriptor.getMessageType();
        }
        return fieldDescriptor;
    }

    @Nullable
    private static Descriptors.FieldDescriptor resolveFieldOrExtension(Descriptors.Descriptor msgDescriptor, String name, ExtensionRegistry registry) {
        if (!name.contains(".")) {
            return msgDescriptor.findFieldByName(name);
        }
        ExtensionRegistry.ExtensionInfo extensionInfo = registry.findImmutableExtensionByName(name);
        if (extensionInfo == null) {
            return null;
        }
        Preconditions.checkArgument(extensionInfo.descriptor.getContainingType() == msgDescriptor, "[%s] is not an extension of [%s]", (Object)name, (Object)msgDescriptor.getFullName());
        return extensionInfo.descriptor;
    }

    static enum IndexChooser {
        ORIGINAL_INDEX{

            @Override
            int getIndex(MessageDifferencer.SpecificField specificField) {
                return specificField.getIndex();
            }
        }
        ,
        NEW_INDEX{

            @Override
            int getIndex(MessageDifferencer.SpecificField specificField) {
                return specificField.getNewIndex();
            }
        };


        abstract int getIndex(MessageDifferencer.SpecificField var1);
    }
}

