/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.MessageUtils;
import com.google.protobuf.contrib.protopath.ConditionCompiler;
import com.google.protobuf.contrib.protopath.FieldSpec;
import com.google.protobuf.contrib.protopath.FunctionCompiler;
import com.google.protobuf.contrib.protopath.FunctionRegistry;
import com.google.protobuf.contrib.protopath.MultiProtoPath;
import com.google.protobuf.contrib.protopath.PathElement;
import com.google.protobuf.contrib.protopath.ProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.ProtoPathParser;
import com.google.protobuf.contrib.protopath.SingleProtoPath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

class Builders {
    private Builders() {
    }

    static class MultiBuilder
    implements ProtoPath.TerminalBuilder<MessageOrBuilder> {
        final FunctionRegistry functionRegistry;
        final List<String> unparsedPaths;
        final Set<Descriptors.Descriptor> descriptors;

        MultiBuilder(Set<Descriptors.Descriptor> descriptors, FunctionRegistry functionRegistry, List<String> unparsedPaths) {
            this.functionRegistry = functionRegistry;
            this.unparsedPaths = unparsedPaths;
            this.descriptors = descriptors;
        }

        public MultiBuilder addPath(String path) {
            this.unparsedPaths.add(path);
            return this;
        }

        public MultiBuilder registerFunction(FunctionCompiler function) {
            this.functionRegistry.registerFunction(function);
            return this;
        }

        @Override
        public <V> ProtoPath<MessageOrBuilder, V> build(Class<V> valueType) {
            ArrayList<SingleProtoPath<MessageOrBuilder, V>> protoPaths = new ArrayList<SingleProtoPath<MessageOrBuilder, V>>();
            for (Descriptors.Descriptor descriptor : this.descriptors) {
                protoPaths.add(new RootBuilder(this.functionRegistry).withPath(this.unparsedPaths).forMessageDescriptor(descriptor).build(valueType));
            }
            return new MultiProtoPath<V>(protoPaths, valueType);
        }
    }

    static class RelativeMultiBuilder
    implements ProtoPath.TerminalBuilder<MessageOrBuilder> {
        final FunctionRegistry functionRegistry;
        final List<String> unparsedPaths;
        final Iterable<? extends SingleProtoPath<?, ?>> singlePaths;

        RelativeMultiBuilder(Iterable<? extends SingleProtoPath<?, ?>> singlePaths, FunctionRegistry functionRegistry, List<String> unparsedPaths) {
            this.functionRegistry = functionRegistry;
            this.unparsedPaths = unparsedPaths;
            this.singlePaths = singlePaths;
        }

        public RelativeMultiBuilder addPath(String path) {
            this.unparsedPaths.add(path);
            return this;
        }

        public RelativeMultiBuilder registerFunction(FunctionCompiler function) {
            this.functionRegistry.registerFunction(function);
            return this;
        }

        @Override
        public <V> ProtoPath<MessageOrBuilder, V> build(Class<V> valueType) {
            ArrayList updatedPaths = new ArrayList();
            for (SingleProtoPath<?, ?> singlePath : this.singlePaths) {
                updatedPaths.add(new RootBuilder(this.functionRegistry).withPath(this.unparsedPaths).relativeTo(singlePath).build(valueType));
            }
            return new MultiProtoPath<V>(updatedPaths, valueType);
        }
    }

    static final class SingleBuilder<N extends MessageOrBuilder>
    implements ProtoPath.SingleBuilder<N> {
        final FunctionRegistry functionRegistry;
        final List<String> unparsedPaths;
        private final String rootMessageName;
        private final boolean isRootABuilder;
        private final List<PathElement> pathElements;
        @Nullable
        private final Descriptors.Descriptor messageDescriptor;

        private SingleBuilder(String rootMessageName, boolean isRootABuilder, Iterable<PathElement> initialPathElements, Descriptors.Descriptor messageDescriptor, FunctionRegistry functionRegistry, Iterable<String> unparsedPaths) {
            this.functionRegistry = Preconditions.checkNotNull(functionRegistry);
            this.unparsedPaths = Lists.newArrayList(unparsedPaths);
            this.rootMessageName = Preconditions.checkNotNull(rootMessageName);
            this.isRootABuilder = isRootABuilder;
            this.pathElements = Lists.newArrayList(initialPathElements);
            this.messageDescriptor = messageDescriptor;
        }

        @Override
        public SingleBuilder<N> addPath(String path) {
            this.unparsedPaths.add(path);
            return this;
        }

        @Override
        public SingleBuilder<N> registerFunction(FunctionCompiler function) {
            this.functionRegistry.registerFunction(function);
            return this;
        }

        private PathElement toPathElement(FieldSpec fieldSpec, Descriptors.Descriptor messageDescriptor, ConditionCompiler conditionCompiler, ExtensionRegistry extensionRegistry) throws ProtoPathException {
            Descriptors.FieldDescriptor fieldDescriptor = fieldSpec.getFieldDescriptor(messageDescriptor, extensionRegistry);
            return new PathElement(fieldDescriptor, fieldSpec, conditionCompiler);
        }

        private Descriptors.Descriptor updatePathElements(Descriptors.Descriptor currentDescriptor, FieldSpec fieldSpec, ConditionCompiler conditionCompiler, ExtensionRegistry extensionRegistry) {
            if (fieldSpec.equals((Object)FieldSpec.PARENT)) {
                if (this.pathElements.isEmpty()) {
                    throw new ProtoPathException(ProtoPathException.Reason.INVALID_PATH, "Backed up too far. Reduce # of parent references", new Object[0]);
                }
                PathElement last = this.pathElements.remove(this.pathElements.size() - 1);
                return last.getContainingType();
            }
            if (currentDescriptor == null) {
                throw new ProtoPathException(ProtoPathException.Reason.INVALID_PATH, "Cannot resolve element [%s]. Is the previous element a primitive field?", new Object[]{fieldSpec});
            }
            PathElement pathElement = this.toPathElement(fieldSpec, currentDescriptor, conditionCompiler, extensionRegistry);
            this.pathElements.add(pathElement);
            return pathElement.getMessageType();
        }

        @Override
        public <V> SingleProtoPath<N, V> build(Class<V> valueClass) throws ProtoPathException {
            String rootMessageName = Preconditions.checkNotNull(this.rootMessageName);
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getGeneratedRegistry();
            ConditionCompiler conditionCompiler = ConditionCompiler.newInstance(this.functionRegistry, extensionRegistry);
            Descriptors.Descriptor currentDescriptor = this.messageDescriptor;
            for (String unparsedPath : this.unparsedPaths) {
                for (FieldSpec fieldSpec : ProtoPathParser.parse(unparsedPath, this.functionRegistry)) {
                    currentDescriptor = this.updatePathElements(currentDescriptor, fieldSpec, conditionCompiler, extensionRegistry);
                }
            }
            if (this.pathElements.isEmpty()) {
                if (!MessageOrBuilder.class.isAssignableFrom(valueClass)) {
                    String string = String.valueOf(valueClass);
                    throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, new StringBuilder(60 + String.valueOf(string).length()).append("For empty path, valueClass should be a message class. Given ").append(string).toString(), new Object[0]);
                }
                Class<V> msgClass = valueClass;
                if (!MessageUtils.getProtoTypeName(msgClass).equals(rootMessageName)) {
                    throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "For empty path, valueClass should be same as message class.", new Object[0]);
                }
            } else {
                this.pathElements.get(this.pathElements.size() - 1).verifyReturnType(valueClass);
            }
            if (!this.isRootABuilder && ProtoPath.isBuilder(valueClass)) {
                throw new ProtoPathException(ProtoPathException.Reason.VALUE_BUILDER_NEEDS_ROOT_BUILDER, "Using a builder for the value class is only supported if the root message class is also a builder", new Object[0]);
            }
            return new SingleProtoPath(rootMessageName, this.isRootABuilder, this.pathElements, valueClass);
        }
    }

    static class RootBuilder
    implements ProtoPath.Builder {
        final FunctionRegistry functionRegistry;
        final List<String> unparsedPaths = new ArrayList<String>();

        RootBuilder(FunctionRegistry functionRegistry) {
            this.functionRegistry = Preconditions.checkNotNull(functionRegistry);
        }

        @Override
        public ProtoPath.Builder addPath(String path) {
            this.unparsedPaths.add(path);
            return this;
        }

        @Override
        public ProtoPath.Builder registerFunction(FunctionCompiler function) {
            this.functionRegistry.registerFunction(function);
            return this;
        }

        ProtoPath.Builder withPath(Iterable<String> path) {
            this.unparsedPaths.clear();
            Iterables.addAll(this.unparsedPaths, path);
            return this;
        }

        public <M extends MessageOrBuilder> SingleBuilder<M> relativeTo(SingleProtoPath<M, ?> contextPath) throws ProtoPathException {
            return new SingleBuilder(contextPath.getRootMessageName(), contextPath.isRootABuilder(), contextPath.pathElements, contextPath.lastPathElement().getMessageType(), this.functionRegistry, this.unparsedPaths);
        }

        public <M extends MessageOrBuilder> SingleBuilder<M> forMessage(M defaultInstance) throws ProtoPathException {
            Descriptors.Descriptor descriptor = defaultInstance.getDescriptorForType();
            return new SingleBuilder(descriptor.getFullName(), false, ImmutableList.of(), descriptor, this.functionRegistry, this.unparsedPaths);
        }

        public <M extends MessageOrBuilder> SingleBuilder<M> forMessage(Class<M> msgClass) throws ProtoPathException {
            Descriptors.Descriptor result;
            try {
                result = (Descriptors.Descriptor)msgClass.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError(String.format("Message class %s must implement getDescriptor() static method.", msgClass), e);
            }
            Descriptors.Descriptor descriptor = result;
            return new SingleBuilder(descriptor.getFullName(), ProtoPath.isBuilder(msgClass), ImmutableList.of(), descriptor, this.functionRegistry, this.unparsedPaths);
        }

        public SingleBuilder<MessageOrBuilder> forMessageDescriptor(Descriptors.Descriptor descriptor) throws ProtoPathException {
            return new SingleBuilder<MessageOrBuilder>(descriptor.getFullName(), false, ImmutableList.of(), descriptor, this.functionRegistry, this.unparsedPaths);
        }

        @Override
        public ProtoPath.TerminalBuilder<MessageOrBuilder> forServiceDescriptor(Descriptors.ServiceDescriptor descriptor) throws ProtoPathException {
            return this.forServiceDescriptors(ImmutableSet.of(descriptor));
        }

        @Override
        public ProtoPath.TerminalBuilder<MessageOrBuilder> forServiceDescriptors(Iterable<Descriptors.ServiceDescriptor> descriptors) throws ProtoPathException {
            HashSet<Descriptors.Descriptor> msgDescriptors = new HashSet<Descriptors.Descriptor>();
            for (Descriptors.ServiceDescriptor descriptor : descriptors) {
                for (Descriptors.MethodDescriptor method : descriptor.getMethods()) {
                    msgDescriptors.add(method.getInputType());
                }
            }
            if (msgDescriptors.isEmpty()) {
                String string = String.valueOf(descriptors);
                throw new ProtoPathException(ProtoPathException.Reason.NO_METHODS_IN_SERVICE, new StringBuilder(24 + String.valueOf(string).length()).append("No methods in services: ").append(string).toString(), new Object[0]);
            }
            return new MultiBuilder(msgDescriptors, this.functionRegistry, this.unparsedPaths);
        }

        @Override
        public <M extends MessageOrBuilder> ProtoPath.TerminalBuilder<M> relativeTo(ProtoPath<M, ?> contextPath) throws ProtoPathException {
            if (contextPath instanceof SingleProtoPath) {
                return this.relativeTo((SingleProtoPath)contextPath);
            }
            MultiProtoPath multiPath = (MultiProtoPath)contextPath;
            RelativeMultiBuilder builder = new RelativeMultiBuilder(multiPath.paths(), this.functionRegistry, this.unparsedPaths);
            return builder;
        }
    }
}

