/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.contrib.protopath.AutoValue_ConditionSpec;
import com.google.protobuf.contrib.protopath.FunctionCall;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

@AutoValue
abstract class ConditionSpec {
    private static final Joiner AND_JOINER = Joiner.on(" && ");
    private static final Joiner OR_JOINER = Joiner.on(" || ");

    ConditionSpec() {
    }

    abstract NodeType nodeType();

    @Nullable
    abstract ImmutableList<ConditionSpec> children();

    @Nullable
    abstract FunctionCall functionCall();

    String unparse() {
        if (this.nodeType() == NodeType.LEAF) {
            return this.functionCall().unparse();
        }
        if (this.nodeType() == NodeType.NOT) {
            String string = String.valueOf(Iterables.getOnlyElement(this.children()).unparse());
            return string.length() != 0 ? "!".concat(string) : new String("!");
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (ConditionSpec spec : this.children()) {
            parts.add(spec.unparse());
        }
        Joiner joiner = this.nodeType() == NodeType.AND ? AND_JOINER : OR_JOINER;
        return joiner.join(parts);
    }

    static ConditionSpec leafNode(FunctionCall functionCall) {
        return new AutoValue_ConditionSpec(NodeType.LEAF, null, functionCall);
    }

    static ConditionSpec not(ConditionSpec conditionSpec) {
        return new AutoValue_ConditionSpec(NodeType.NOT, ImmutableList.of(conditionSpec), null);
    }

    static ConditionSpec and(Collection<ConditionSpec> conditionSpecs) {
        if (conditionSpecs.size() == 1) {
            return Iterables.getOnlyElement(conditionSpecs);
        }
        return new AutoValue_ConditionSpec(NodeType.AND, ImmutableList.copyOf(conditionSpecs), null);
    }

    static ConditionSpec or(Collection<ConditionSpec> conditionSpecs) {
        if (conditionSpecs.size() == 1) {
            return Iterables.getOnlyElement(conditionSpecs);
        }
        return new AutoValue_ConditionSpec(NodeType.OR, ImmutableList.copyOf(conditionSpecs), null);
    }

    static enum NodeType {
        LEAF,
        NOT,
        AND,
        OR;

    }
}

