/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.labs.reflect.ValueType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.contrib.protopath.ArgTypesFactory;
import com.google.protobuf.contrib.protopath.ConditionSpec;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.ProtoPathParser;
import com.google.re2j.Pattern;
import java.util.ArrayList;
import javax.annotation.Nullable;

public final class FieldSpec
extends ValueType {
    public static final Joiner SLASH_JOINER = Joiner.on('/');
    public static final Splitter SLASH_SPLITTER = Splitter.on('/').omitEmptyStrings();
    static final FieldSpec PARENT = FieldSpec.forFieldOrExtension("..");
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\[\\d+\\]");
    private final String name;
    private final Integer tagNumber;
    private final Integer index;
    @Nullable
    private final ConditionSpec conditionSpec;

    FieldSpec(@Nullable String name, @Nullable Integer tagNumber, Integer index, @Nullable ConditionSpec conditionSpec) {
        Preconditions.checkArgument(name == null != (tagNumber == null));
        this.tagNumber = tagNumber;
        this.name = name;
        this.index = index;
        this.conditionSpec = conditionSpec;
    }

    public static String dropIndicesInFieldPath(String fieldPath) {
        return INDEX_PATTERN.matcher(fieldPath).replaceAll("");
    }

    public String getName() {
        return this.name;
    }

    public Integer getTagNumber() {
        return this.tagNumber;
    }

    public boolean hasIndex() {
        return this.index != null;
    }

    @Nullable
    public Integer getEffectiveIndex(int size) {
        if (!this.hasIndex()) {
            return null;
        }
        if (this.index >= size || this.index < -size) {
            return null;
        }
        return this.index >= 0 ? this.index : this.index + size;
    }

    @Nullable
    public ConditionSpec getConditionSpec() {
        return this.conditionSpec;
    }

    public String unparse() {
        return this.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.name != null) {
            buf.append(this.name);
        } else {
            buf.append(this.tagNumber);
        }
        if (this.index != null) {
            buf.append("[").append(this.index).append("]");
        }
        if (this.conditionSpec != null) {
            buf.append("[").append(this.conditionSpec.unparse()).append("]");
        }
        return buf.toString();
    }

    public FieldSpec replaceIndex(Integer newIndex) {
        return new FieldSpec(this.name, this.tagNumber, newIndex, this.conditionSpec);
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(Descriptors.Descriptor messageDescriptor, ExtensionRegistry extensionRegistry) throws ProtoPathException {
        ProtoPathException.Reason errorReason;
        String errorMsg;
        Descriptors.FieldDescriptor fieldDescriptor;
        if (this.getTagNumber() != null) {
            fieldDescriptor = messageDescriptor.findFieldByNumber(this.getTagNumber());
            String string = String.valueOf(this.getTagNumber());
            errorMsg = new StringBuilder(15 + String.valueOf(string).length()).append("field with tag ").append(string).toString();
            errorReason = ProtoPathException.Reason.TAG_DOES_NOT_EXIST;
        } else {
            String name = this.getName();
            boolean hasDot = Preconditions.checkNotNull(name).contains(".");
            if (!hasDot) {
                fieldDescriptor = messageDescriptor.findFieldByName(name);
                String string = String.valueOf(name);
                errorMsg = string.length() != 0 ? "field with name ".concat(string) : new String("field with name ");
                errorReason = ProtoPathException.Reason.FIELD_DOES_NOT_EXIST;
            } else {
                ExtensionRegistry.ExtensionInfo extensionInfo = extensionRegistry.findImmutableExtensionByName(name);
                fieldDescriptor = extensionInfo == null ? null : extensionInfo.descriptor;
                String string = String.valueOf(name);
                errorMsg = string.length() != 0 ? "extension with fullname ".concat(string) : new String("extension with fullname ");
                errorReason = ProtoPathException.Reason.EXTENSION_DOES_NOT_EXIST;
            }
        }
        if (fieldDescriptor == null) {
            throw new ProtoPathException(errorReason, "Unable to find %s in message %s", errorMsg, messageDescriptor.getFullName());
        }
        return fieldDescriptor;
    }

    public static FieldSpec forFieldOrExtension(String name) {
        return new FieldSpec(name, null, null, null);
    }

    public static FieldSpec forFieldOrExtension(String name, @Nullable Integer index) {
        return new FieldSpec(name, null, index, null);
    }

    public static FieldSpec fromFieldDescriptor(Descriptors.FieldDescriptor fieldDescriptor, @Nullable Integer index) {
        String name;
        String string = name = fieldDescriptor.isExtension() ? fieldDescriptor.getFullName() : fieldDescriptor.getName();
        if (fieldDescriptor.isRepeated()) {
            return FieldSpec.forFieldOrExtension(name, index);
        }
        return FieldSpec.forFieldOrExtension(name);
    }

    public static FieldSpec forUnknownTag(int tagNumber) {
        return new FieldSpec(null, tagNumber, null, null);
    }

    public static FieldSpec parse(String pathElement) {
        return FieldSpec.parse(pathElement, ArgTypesFactory.NO_FUNCTIONS_IMPL);
    }

    static FieldSpec parse(String pathElement, ArgTypesFactory argTypesFactory) {
        FieldSpec fieldSpec = ProtoPathParser.parseFieldSpec(pathElement, argTypesFactory);
        return "..".equals(fieldSpec.getName()) ? PARENT : fieldSpec;
    }

    public static String join(Iterable<FieldSpec> fieldSpecs, FieldSpec ... moreSpecs) {
        ArrayList<String> parts = Lists.newArrayList();
        for (FieldSpec fieldSpec : fieldSpecs) {
            parts.add(fieldSpec.toString());
        }
        for (FieldSpec fieldSpec : moreSpecs) {
            parts.add(fieldSpec.toString());
        }
        return SLASH_JOINER.join(parts);
    }

    public static String join(String ... parts) {
        ArrayList<String> nonTrivialParts = new ArrayList<String>();
        for (String part : parts) {
            if (Strings.isNullOrEmpty(part)) continue;
            nonTrivialParts.add(part);
        }
        return SLASH_JOINER.join(nonTrivialParts);
    }

    public static ImmutableList<FieldSpec> split(String path) {
        return ProtoPathParser.parse(path, ArgTypesFactory.NO_FUNCTIONS_IMPL);
    }
}

