/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.contrib.protopath.AutoValue_FunctionCall;
import com.google.protobuf.contrib.protopath.FunctionArg;
import com.google.re2j.Pattern;

@AutoValue
public abstract class FunctionCall {
    static final ImmutableSet<String> BINARY_PREDICATES = ImmutableSet.of("==", "!=", "<=", ">=", "<", ">", new String[]{"~=", "!~"});
    static final Pattern FN_NAME_PATTERN = Pattern.compile("^[A-Z]([A-Z_.])*$");

    abstract String functionName();

    public abstract ImmutableList<FunctionArg> functionArgs();

    static FunctionCall create(String fnName, ImmutableList<FunctionArg> args) {
        return new AutoValue_FunctionCall(fnName, args);
    }

    public String unparse() {
        if (BINARY_PREDICATES.contains(this.functionName())) {
            return this.infixForm();
        }
        return this.prefixForm();
    }

    private String prefixForm() {
        StringBuilder buf = new StringBuilder(this.functionName());
        buf.append("(");
        boolean skip = true;
        for (FunctionArg arg : this.functionArgs()) {
            if (skip) {
                skip = false;
            } else {
                buf.append(", ");
            }
            buf.append(arg.unparse());
        }
        buf.append(")");
        return buf.toString();
    }

    private String infixForm() {
        Preconditions.checkArgument(this.functionArgs().size() == 2);
        FunctionArg left = (FunctionArg)((Object)this.functionArgs().get(0));
        FunctionArg right = (FunctionArg)((Object)this.functionArgs().get(1));
        return String.format("%s %s %s", left.unparse(), this.functionName(), right.unparse());
    }
}

