/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.ProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.SingleProtoPath;
import java.util.Collection;
import javax.annotation.Nullable;

class MultiProtoPath<T>
extends ProtoPath<MessageOrBuilder, T> {
    private final ImmutableMap<String, SingleProtoPath<?, ? extends T>> map;
    private final ProtoPath.Cardinality cardinality;
    private final String unparsed;

    MultiProtoPath(Iterable<? extends SingleProtoPath<?, ? extends T>> paths, Class<T> valueType) {
        super(valueType);
        Preconditions.checkArgument(!Iterables.isEmpty(paths), "must have at least one path");
        ImmutableMap.Builder<String, SingleProtoPath<?, ? extends T>> builder = ImmutableMap.builder();
        ProtoPath.Cardinality lastCardinality = null;
        String unparsed = null;
        for (SingleProtoPath<?, T> path : paths) {
            builder.put(path.getRootMessageName(), path);
            if (lastCardinality == null) {
                lastCardinality = path.getCardinality();
            } else if (lastCardinality != path.getCardinality()) {
                lastCardinality = ProtoPath.Cardinality.MIXED;
            }
            if (unparsed == null) {
                unparsed = path.unparse();
                continue;
            }
            Preconditions.checkArgument(unparsed.equals(path.unparse()), "Unequal unparsed paths: %s vs %s", (Object)unparsed, (Object)path.unparse());
        }
        this.map = builder.build();
        this.cardinality = lastCardinality;
        this.unparsed = unparsed;
    }

    Collection<SingleProtoPath<?, ? extends T>> paths() {
        return this.map.values();
    }

    private <M extends MessageOrBuilder> SingleProtoPath<M, ? extends T> pathFor(M m) {
        String messageName = m.getDescriptorForType().getFullName();
        if (!this.map.containsKey(messageName)) {
            String string = String.valueOf(m);
            String string2 = String.valueOf(this.map.keySet());
            throw new ProtoPathException(ProtoPathException.Reason.WRONG_MESSAGE_TYPE, new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("No path registered for message: ").append(string).append(", valid message types are: ").append(string2).toString(), new Object[0]);
        }
        SingleProtoPath<?, ? extends T> singleProtoPath = this.map.get(messageName);
        return singleProtoPath;
    }

    @Override
    @Nullable
    public T tryGetValue(MessageOrBuilder messageOrBuilder, EvaluationContext ctx) throws ProtoPathException {
        return this.pathFor(messageOrBuilder).tryGetValue(messageOrBuilder, ctx);
    }

    @Override
    public T getValue(MessageOrBuilder messageOrBuilder, EvaluationContext ctx) throws ProtoPathException {
        return this.pathFor(messageOrBuilder).getValue(messageOrBuilder, ctx);
    }

    @Override
    public ImmutableList<T> getValues(MessageOrBuilder messageOrBuilder, EvaluationContext ctx) {
        return ImmutableList.copyOf(this.pathFor(messageOrBuilder).getValues(messageOrBuilder, ctx));
    }

    @Override
    public ProtoPath.SetValueResult setValue(MessageOrBuilder messageOrBuilder, T value, EvaluationContext ctx) throws ProtoPathException {
        SingleProtoPath<MessageOrBuilder, T> path;
        SingleProtoPath<MessageOrBuilder, T> pathCast = path = this.pathFor(messageOrBuilder);
        return pathCast.setValue(messageOrBuilder, value);
    }

    @Override
    public ImmutableList<T> evaluate(MessageOrBuilder messageOrBuilder, EvaluationContext ctx) {
        return ImmutableList.copyOf(this.pathFor(messageOrBuilder).getValues(messageOrBuilder, ctx));
    }

    @Override
    public boolean hasValue(MessageOrBuilder messageOrBuilder, EvaluationContext ctx) {
        return this.pathFor(messageOrBuilder).hasValue(messageOrBuilder, ctx);
    }

    @Override
    public Descriptors.FieldDescriptor getTerminalFieldDescriptor() {
        Descriptors.FieldDescriptor descriptor = this.paths().iterator().next().getTerminalFieldDescriptor();
        for (SingleProtoPath<?, T> path : this.paths()) {
            if (descriptor == path.getTerminalFieldDescriptor()) continue;
            throw new ProtoPathException(ProtoPathException.Reason.MISMATCHED_PATHS, "Found at least two different terminal field descriptors", new Object[0]);
        }
        return descriptor;
    }

    @Override
    public ProtoPath.Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public String unparse() {
        return this.unparsed;
    }

    @Override
    public boolean hasConditions() {
        return ((SingleProtoPath)((ImmutableCollection)this.map.values()).iterator().next()).hasConditions();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("paths", this.map.values()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiProtoPath) {
            MultiProtoPath o = (MultiProtoPath)obj;
            return this.map.equals(o.map) && this.valueType.equals(o.valueType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.map.hashCode(), this.valueType);
    }
}

