/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.protobuf.contrib.protopath.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static String EOL = System.getProperty("line.separator", "\n");
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        for (int i = 0; i < expectedTokenSequences.length; ++i) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            for (int j = 0; j < expectedTokenSequences[i].length; ++j) {
                expected.append(tokenImage[expectedTokenSequences[i][j]]).append(' ');
            }
            if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(EOL).append("    ");
        }
        String retval = "Encountered \"";
        Token tok = currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = String.valueOf(retval).concat(" ");
            }
            if (tok.kind == 0) {
                String string = String.valueOf(retval);
                String string2 = String.valueOf(tokenImage[0]);
                retval = string2.length() != 0 ? string.concat(string2) : new String(string);
                break;
            }
            String string = String.valueOf(retval);
            String string3 = tokenImage[tok.kind];
            retval = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(" ").append(string3).toString();
            retval = String.valueOf(retval).concat(" \"");
            String string4 = String.valueOf(retval);
            String string5 = String.valueOf(ParseException.add_escapes(tok.image));
            retval = string5.length() != 0 ? string4.concat(string5) : new String(string4);
            retval = String.valueOf(retval).concat(" \"");
            tok = tok.next;
        }
        if (currentToken.next != null) {
            String string = String.valueOf(retval);
            int n = currentToken.next.beginLine;
            int n2 = currentToken.next.beginColumn;
            retval = new StringBuilder(41 + String.valueOf(string).length()).append(string).append("\" at line ").append(n).append(", column ").append(n2).toString();
        }
        String string = String.valueOf(retval);
        String string6 = EOL;
        retval = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string6).length()).append(string).append(".").append(string6).toString();
        if (expectedTokenSequences.length != 0) {
            if (expectedTokenSequences.length == 1) {
                string = String.valueOf(retval);
                string6 = EOL;
                retval = new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string6).length()).append(string).append("Was expecting:").append(string6).append("    ").toString();
            } else {
                string = String.valueOf(retval);
                string6 = EOL;
                retval = new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string6).length()).append(string).append("Was expecting one of:").append(string6).append("    ").toString();
            }
            String string7 = String.valueOf(retval);
            String string8 = String.valueOf(expected.toString());
            retval = string8.length() != 0 ? string7.concat(string8) : new String(string7);
        }
        return retval;
    }

    static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block10: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\b': {
                    retval.append("\\b");
                    continue block10;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block10;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block10;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block10;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block10;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block10;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String string = String.valueOf(Integer.toString(ch, 16));
                        String s = string.length() != 0 ? "0000".concat(string) : new String("0000");
                        String string2 = String.valueOf(s.substring(s.length() - 4, s.length()));
                        retval.append(string2.length() != 0 ? "\\u".concat(string2) : new String("\\u"));
                        continue block10;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

