/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.protopath.Builders;
import com.google.protobuf.contrib.protopath.EqFunction;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.FunctionCompiler;
import com.google.protobuf.contrib.protopath.FunctionRegistry;
import com.google.protobuf.contrib.protopath.HasFunction;
import com.google.protobuf.contrib.protopath.MultiProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.RelFunction;
import com.google.protobuf.contrib.protopath.SimFunction;
import com.google.protobuf.contrib.protopath.SingleProtoPath;
import java.util.HashSet;
import javax.annotation.Nullable;

public abstract class ProtoPath<M extends MessageOrBuilder, T> {
    final Class<T> valueType;
    final boolean isValueABuilder;

    public static <N extends MessageOrBuilder, V> SingleProtoPath<N, V> compile(String path, Class<N> msgType, Class<V> valueType) throws ProtoPathException {
        return ProtoPath.newBuilder().forMessage(msgType).addPath(path).build(valueType);
    }

    static <N extends MessageOrBuilder, VI, VO> ProtoPath<N, VO> compile(ProtoPath<N, VI> context, String relativePath, Class<VO> valueType) throws ProtoPathException {
        return ProtoPath.newBuilder().relativeTo(context).addPath(relativePath).build(valueType);
    }

    static <N extends MessageOrBuilder, VI, VO> SingleProtoPath<N, VO> compile(SingleProtoPath<N, VI> context, String relativePath, Class<VO> valueType) throws ProtoPathException {
        return ProtoPath.newBuilder().relativeTo(context).addPath(relativePath).build(valueType);
    }

    public static <N extends MessageOrBuilder> SingleProtoPath<N, Object> compileTypeless(String path, Class<N> msgType) throws ProtoPathException {
        return ProtoPath.compile(path, msgType, Object.class);
    }

    public static <M extends MessageOrBuilder, T> ProtoPath<M, T> combine(Iterable<? extends ProtoPath<? extends M, ? extends T>> protoPaths, Class<T> valueType) {
        ProtoPath<M, T> possibleResult;
        if (Iterables.isEmpty(protoPaths)) {
            throw new ProtoPathException(ProtoPathException.Reason.AT_LEAST_ONE_PATH_REQUIRED, "No paths to combine", new Object[0]);
        }
        if (Iterables.size(protoPaths) == 1 && (possibleResult = Iterables.getOnlyElement(protoPaths)).getValueType() == valueType) {
            ProtoPath<M, T> casted = possibleResult;
            return casted;
        }
        String unparsed = null;
        HashSet paths = new HashSet();
        for (ProtoPath<M, T> path : protoPaths) {
            String currentUnparsed = path.unparse();
            if (unparsed == null) {
                unparsed = currentUnparsed;
            } else if (!unparsed.equals(currentUnparsed)) {
                String string = String.valueOf(protoPaths);
                throw new ProtoPathException(ProtoPathException.Reason.MISMATCHED_PATHS, new StringBuilder(16 + String.valueOf(string).length()).append("Cannot combine: ").append(string).toString(), new Object[0]);
            }
            if (path instanceof SingleProtoPath) {
                paths.add((SingleProtoPath)path);
                continue;
            }
            MultiProtoPath multiProtoPath = (MultiProtoPath)path;
            paths.addAll(multiProtoPath.paths());
        }
        MultiProtoPath<T> result = new MultiProtoPath<T>(paths, valueType);
        return result;
    }

    public static Builder newBuilder() {
        FunctionRegistry functionRegistry = new FunctionRegistry().registerFunction(new EqFunction()).registerFunction(new HasFunction()).registerFunction(new SimFunction()).registerFunction(new RelFunction());
        return new Builders.RootBuilder(functionRegistry);
    }

    ProtoPath(Class<T> valueType) {
        this.valueType = valueType;
        this.isValueABuilder = ProtoPath.isBuilder(valueType);
    }

    public final Class<T> getValueType() {
        return this.valueType;
    }

    @Nullable
    public final T tryGetValue(M messageOrBuilder) throws ProtoPathException {
        return this.tryGetValue(messageOrBuilder, EvaluationContext.EMPTY_CONTEXT);
    }

    @Nullable
    public abstract T tryGetValue(M var1, EvaluationContext var2) throws ProtoPathException;

    public final T getValue(M messageOrBuilder) throws ProtoPathException {
        return this.getValue(messageOrBuilder, EvaluationContext.EMPTY_CONTEXT);
    }

    public abstract T getValue(M var1, EvaluationContext var2) throws ProtoPathException;

    public final ImmutableList<T> getValues(M messageOrBuilder) {
        return this.getValues(messageOrBuilder, EvaluationContext.EMPTY_CONTEXT);
    }

    public abstract ImmutableList<T> getValues(M var1, EvaluationContext var2);

    public final SetValueResult setValue(M messageOrBuilder, T value) throws ProtoPathException {
        return this.setValue(messageOrBuilder, value, EvaluationContext.EMPTY_CONTEXT);
    }

    public abstract SetValueResult setValue(M var1, T var2, EvaluationContext var3) throws ProtoPathException;

    public final ImmutableList<T> evaluate(M messageOrBuilder) {
        return this.evaluate(messageOrBuilder, EvaluationContext.EMPTY_CONTEXT);
    }

    public abstract ImmutableList<T> evaluate(M var1, EvaluationContext var2);

    public final boolean hasValue(M messageOrBuilder) {
        return this.hasValue(messageOrBuilder, EvaluationContext.EMPTY_CONTEXT);
    }

    public abstract boolean hasValue(M var1, EvaluationContext var2);

    public abstract Descriptors.FieldDescriptor getTerminalFieldDescriptor();

    public abstract Cardinality getCardinality();

    public abstract String unparse();

    public abstract boolean hasConditions();

    static boolean isBuilder(Class<?> type) {
        return MessageLite.Builder.class.isAssignableFrom(type);
    }

    public static interface SingleBuilder<N extends MessageOrBuilder>
    extends TerminalBuilder<N> {
        @Override
        public SingleBuilder<N> addPath(String var1);

        @Override
        public SingleBuilder<N> registerFunction(FunctionCompiler var1);

        @Override
        public <V> SingleProtoPath<N, V> build(Class<V> var1);
    }

    public static interface TerminalBuilder<N extends MessageOrBuilder> {
        public TerminalBuilder<N> addPath(String var1);

        public TerminalBuilder<N> registerFunction(FunctionCompiler var1);

        public <V> ProtoPath<N, V> build(Class<V> var1);
    }

    public static interface Builder {
        public Builder addPath(String var1);

        public Builder registerFunction(FunctionCompiler var1);

        public <M extends MessageOrBuilder> SingleBuilder<M> relativeTo(SingleProtoPath<M, ?> var1) throws ProtoPathException;

        public <M extends MessageOrBuilder> SingleBuilder<M> forMessage(M var1) throws ProtoPathException;

        public <M extends MessageOrBuilder> SingleBuilder<M> forMessage(Class<M> var1) throws ProtoPathException;

        public SingleBuilder<MessageOrBuilder> forMessageDescriptor(Descriptors.Descriptor var1) throws ProtoPathException;

        public TerminalBuilder<MessageOrBuilder> forServiceDescriptor(Descriptors.ServiceDescriptor var1) throws ProtoPathException;

        public TerminalBuilder<MessageOrBuilder> forServiceDescriptors(Iterable<Descriptors.ServiceDescriptor> var1) throws ProtoPathException;

        public <M extends MessageOrBuilder> TerminalBuilder<M> relativeTo(ProtoPath<M, ?> var1) throws ProtoPathException;
    }

    public static enum SetValueResult {
        SUCCESS,
        NO_MATCH,
        TOO_MANY_MATCHES;

    }

    public static enum Cardinality {
        ALL_SINGLE,
        TERMINAL_MULTIPLE,
        GENERIC,
        MIXED;

    }
}

