/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.protopath.AutoValue_ProtoPathCache_Key;
import com.google.protobuf.contrib.protopath.ProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import javax.annotation.Nullable;

public final class ProtoPathCache {
    private static final CacheBuilderSpec CACHE_SPEC = CacheBuilderSpec.parse("expireAfterAccess=1h");
    private final Cache<Key, ProtoPath<? extends MessageOrBuilder, ?>> compiledPaths = CacheBuilder.from(CACHE_SPEC).build();

    public final <M extends MessageOrBuilder, T> ProtoPath<M, T> getCompiledPath(M message, String path, Class<T> valueClass) throws ProtoPathException {
        Key key = Key.create(message.getDescriptorForType(), path, null);
        ProtoPath<? extends MessageOrBuilder, ?> compiledPath = this.compiledPaths.getIfPresent(key);
        if (compiledPath != null) {
            return this.checkAndCast(compiledPath, message, valueClass);
        }
        ProtoPath<M, T> protoPath = this.checkAndCast(ProtoPath.newBuilder().forMessageDescriptor(message.getDescriptorForType()).addPath(path).build(valueClass), message, valueClass);
        this.compiledPaths.put(key, protoPath);
        return protoPath;
    }

    public final <M extends MessageOrBuilder, T> ProtoPath<M, T> getCompiledRelativePath(M message, String absPath, String relPath, Class<T> valueClass) throws ProtoPathException {
        return this.getCompiledRelativePath(message, absPath, valueClass, relPath, valueClass);
    }

    public final <M extends MessageOrBuilder, S, T> ProtoPath<M, T> getCompiledRelativePath(M message, String absPath, Class<S> absPathClass, String relPath, Class<T> relPathClass) throws ProtoPathException {
        Key key = Key.create(message.getDescriptorForType(), absPath, relPath);
        ProtoPath<? extends MessageOrBuilder, ?> compiledPath = this.compiledPaths.getIfPresent(key);
        if (compiledPath != null) {
            return this.checkAndCast(compiledPath, message, relPathClass);
        }
        ProtoPath<M, S> parentPath = this.getCompiledPath(message, absPath, absPathClass);
        ProtoPath<M, T> childPath = ProtoPath.compile(parentPath, relPath, relPathClass);
        this.compiledPaths.put(key, childPath);
        return childPath;
    }

    private <M extends MessageOrBuilder, T> ProtoPath<M, T> checkAndCast(ProtoPath<?, ?> original, M unusedMessageForCasting, Class<T> valueType) {
        Preconditions.checkArgument(valueType.equals(original.getValueType()) || valueType.isAssignableFrom(original.getValueType()));
        ProtoPath<?, ?> pathProto = original;
        return pathProto;
    }

    @AutoValue
    static abstract class Key {
        Key() {
        }

        static Key create(Descriptors.Descriptor descriptor, String absolutePath, @Nullable String relativePath) {
            return new AutoValue_ProtoPathCache_Key(descriptor.getFullName(), absolutePath, relativePath);
        }

        public abstract String getMessageTypeFullName();

        @Nullable
        public abstract String getAbsolutePath();

        @Nullable
        public abstract String getRelativePath();
    }
}

