/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.labs.reflect.ValueType;
import com.google.common.math.DoubleMath;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.ProtoScalar;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;

final class ProtoScalars {
    ProtoScalars() {
    }

    static ProtoScalar forOperation(String operation, ProtoScalar left, ProtoScalar right) {
        boolean bothConstant;
        BinaryOperation opScalar = new BinaryOperation(operation, left, right);
        boolean bl = bothConstant = left.isConstant() && right.isConstant();
        if (!bothConstant) {
            return opScalar;
        }
        Number value = opScalar.getNumericValue(EvaluationContext.EMPTY_CONTEXT);
        if (value == null) {
            throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Cannot apply operation %s to %s and %s", left.unparse(), right.unparse());
        }
        return ProtoScalars.forNumber(Preconditions.checkNotNull(value));
    }

    static ProtoScalar negate(ProtoScalar value) {
        return new BinaryOperation("*", ProtoScalars.forNumber(-1), value);
    }

    static ProtoScalar forVariable(String symbolName) {
        return new VariableReference(symbolName);
    }

    static ProtoScalar forQuotedStringLiteral(String quotedValue) {
        return new StringProtoScalar(quotedValue, true);
    }

    static ProtoScalar forStringLiteral(String unquotedValue) {
        return new StringProtoScalar(unquotedValue, false);
    }

    static ProtoScalar forSymbolicConstant(String symbolicConstant) {
        return new SymbolicConstantProtoScalar(symbolicConstant);
    }

    static ProtoScalar forNumber(Number number) {
        return new NumericProtoScalar(number);
    }

    private static final class BinaryOperation
    extends BaseProtoScalar {
        private static final ImmutableSet<String> OPERATIONS = ImmutableSet.of("+", "-", "*", "/");
        private final String operation;
        private final ProtoScalar left;
        private final ProtoScalar right;

        protected BinaryOperation(String operation, ProtoScalar left, ProtoScalar right) {
            super(false);
            Preconditions.checkArgument(OPERATIONS.contains(operation));
            this.operation = operation;
            this.left = left;
            this.right = right;
        }

        @Override
        public String unparse() {
            return String.format("(%s %s %s)", this.left.unparse(), this.operation, this.right.unparse());
        }

        @Override
        public Number getNumericValue(EvaluationContext ctx) {
            Number leftValue = this.left.getNumericValue(ctx);
            this.checkCorrectType(this.left, leftValue);
            Number rightValue = this.right.getNumericValue(ctx);
            this.checkCorrectType(this.right, rightValue);
            switch (this.operation) {
                case "+": {
                    return leftValue.doubleValue() + rightValue.doubleValue();
                }
                case "-": {
                    return leftValue.doubleValue() - rightValue.doubleValue();
                }
                case "*": {
                    return leftValue.doubleValue() * rightValue.doubleValue();
                }
                case "/": {
                    return leftValue.doubleValue() / rightValue.doubleValue();
                }
            }
            throw new AssertionError((Object)"Oops!");
        }

        @Override
        public boolean fuzzyEquals(ProtoScalar other, double tolerance, EvaluationContext ctx) {
            Number otherValue = other.getNumericValue(ctx);
            this.checkCorrectType(other, otherValue);
            Number thisValue = this.getNumericValue(ctx);
            this.checkCorrectType(this, thisValue);
            return DoubleMath.fuzzyEquals(thisValue.doubleValue(), otherValue.doubleValue(), tolerance);
        }
    }

    private static final class VariableReference
    extends BaseProtoScalar {
        private final String variable;

        protected VariableReference(String variable) {
            super(false);
            Preconditions.checkArgument(!Strings.isNullOrEmpty(variable));
            this.variable = variable;
        }

        @Override
        public String unparse() {
            String string = String.valueOf(this.variable);
            return string.length() != 0 ? "$".concat(string) : new String("$");
        }

        @Override
        @Nullable
        public String getSymbolicConstant(EvaluationContext ctx) {
            String value = ctx.getVariableResolver().getSymbolicConstant(this.variable);
            if (value == null) {
                throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Variable %s is not a symbolic constant (i.e. boolean/enum).", this.variable);
            }
            return value;
        }

        @Override
        @Nullable
        public String getStringLiteral(EvaluationContext ctx) {
            String value = ctx.getVariableResolver().getStringLiteral(this.variable);
            if (value == null) {
                throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Variable %s does not have a string value.", this.variable);
            }
            return value;
        }

        private Number getNumericValue(ProtoScalar other, EvaluationContext ctx) {
            Number otherValue = ctx.getVariableResolver().getNumericValue(this.variable);
            this.checkCorrectType(other, otherValue);
            return otherValue;
        }

        @Override
        @Nullable
        public Number getNumericValue(EvaluationContext ctx) {
            Number value = ctx.getVariableResolver().getNumericValue(this.variable);
            if (value == null) {
                throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Variable %s doesnt have a numeric value", this.variable);
            }
            return value;
        }

        @Override
        public boolean fuzzyEquals(ProtoScalar other, double tolerance, EvaluationContext ctx) {
            Number otherValue = this.getNumericValue(other, ctx);
            return DoubleMath.fuzzyEquals(this.getNumericValue(ctx).doubleValue(), otherValue.doubleValue(), tolerance);
        }
    }

    private static final class NumericProtoScalar
    extends BaseProtoScalar {
        private final Number number;

        private NumericProtoScalar(Number number) {
            super(true);
            this.number = Preconditions.checkNotNull(number);
        }

        @Override
        public String unparse() {
            return this.number.toString();
        }

        @Override
        public Number getNumericValue(EvaluationContext ctx) {
            return this.number;
        }

        @Override
        public boolean fuzzyEquals(ProtoScalar other, double tolerance, EvaluationContext ctx) {
            Number otherValue = other.getNumericValue(ctx);
            this.checkCorrectType(other, otherValue);
            return DoubleMath.fuzzyEquals(this.getNumericValue(ctx).doubleValue(), otherValue.doubleValue(), tolerance);
        }
    }

    private static final class SymbolicConstantProtoScalar
    extends BaseProtoScalar {
        private final String symbolicConstant;

        private SymbolicConstantProtoScalar(String symbolicConstant) {
            super(true);
            this.symbolicConstant = Preconditions.checkNotNull(symbolicConstant);
        }

        @Override
        public String unparse() {
            return this.symbolicConstant;
        }

        @Override
        public String getSymbolicConstant(EvaluationContext ctx) {
            return this.symbolicConstant;
        }

        @Override
        public boolean fuzzyEquals(ProtoScalar other, double tolerance, EvaluationContext ctx) {
            String otherValue = other.getSymbolicConstant(ctx);
            this.checkCorrectType(other, otherValue);
            return this.getSymbolicConstant(ctx).equalsIgnoreCase(otherValue);
        }
    }

    private static final class StringProtoScalar
    extends BaseProtoScalar {
        private final String stringLiteral;

        private StringProtoScalar(String stringLiteral, boolean quoted) {
            super(true);
            Preconditions.checkNotNull(stringLiteral);
            this.stringLiteral = quoted ? this.unquote(stringLiteral) : stringLiteral;
        }

        private String unquote(String quotedValue) {
            Preconditions.checkArgument(quotedValue.startsWith("\"") && quotedValue.endsWith("\""));
            return StringEscapeUtils.unescapeJava(quotedValue.substring(1, quotedValue.length() - 1));
        }

        @Override
        public boolean fuzzyEquals(ProtoScalar other, double tolerance, EvaluationContext ctx) {
            String otherValue = other.getStringLiteral(ctx);
            this.checkCorrectType(other, otherValue);
            return this.stringLiteral.equals(otherValue);
        }

        @Override
        public String unparse() {
            String string = StringEscapeUtils.escapeJava(this.stringLiteral);
            return new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString();
        }

        @Override
        public String getStringLiteral(EvaluationContext ctx) {
            return this.stringLiteral;
        }
    }

    private static abstract class BaseProtoScalar
    extends ValueType
    implements ProtoScalar {
        private final boolean isConstant;

        protected BaseProtoScalar(boolean isConstant) {
            this.isConstant = isConstant;
        }

        @Override
        public final boolean isConstant() {
            return this.isConstant;
        }

        protected final void checkCorrectType(ProtoScalar other, Object typedValue) {
            if (typedValue == null) {
                throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Cannot check equality of %s and %s", this.unparse(), other.unparse());
            }
        }

        @Override
        @Nullable
        public String getStringLiteral(EvaluationContext ctx) {
            return null;
        }

        @Override
        @Nullable
        public String getSymbolicConstant(EvaluationContext ctx) {
            return null;
        }

        @Override
        @Nullable
        public Number getNumericValue(EvaluationContext ctx) {
            return null;
        }

        @Override
        public int fuzzyCompareTo(ProtoScalar other, double tolerance, EvaluationContext ctx) {
            Number numericValue = this.getNumericValue(ctx);
            Number otherNumericValue = other.getNumericValue(ctx);
            if (numericValue == null || otherNumericValue == null) {
                String string = this.unparse();
                String string2 = other.unparse();
                throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Cannot compare ").append(string).append(" and ").append(string2).toString(), new Object[0]);
            }
            return DoubleMath.fuzzyCompare(numericValue.doubleValue(), otherNumericValue.doubleValue(), tolerance);
        }
    }
}

