/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.protopath.CompiledFunction;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.FunctionArg;
import com.google.protobuf.contrib.protopath.FunctionCall;
import com.google.protobuf.contrib.protopath.FunctionCompiler;
import com.google.protobuf.contrib.protopath.PathElement;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.ProtoScalar;

final class RelFunction
extends FunctionCompiler {
    private static final ImmutableMap<String, Comparison> COMPARISON_MAP = ImmutableMap.of("<", Comparison.LT, ">", Comparison.GT, "<=", Comparison.LE, ">=", Comparison.GE);

    RelFunction() {
        super((ImmutableSet<String>)COMPARISON_MAP.keySet(), FunctionArg.ArgType.FIELD_SPEC, FunctionArg.ArgType.SCALAR);
    }

    @Override
    public CompiledFunction doCompile(FunctionCall functionCall, Descriptors.Descriptor messageDescriptor, ExtensionRegistry extensionRegistry) throws ProtoPathException {
        final PathElement pathElement = this.asPathElement((FunctionArg)((Object)functionCall.functionArgs().get(0)), messageDescriptor, extensionRegistry);
        final double tolerance = this.getTolerance(pathElement);
        final ProtoScalar baseValue = ((FunctionArg)((Object)functionCall.functionArgs().get(1))).getProtoScalar();
        final Comparison comparison = COMPARISON_MAP.get(functionCall.functionName());
        return new CompiledFunction(this){

            @Override
            public boolean evaluate(MessageOrBuilder messageOrBuilder, EvaluationContext ctx) {
                ProtoScalar fieldValue = FunctionCompiler.getValue(messageOrBuilder, pathElement, ctx);
                int comparisonResult = fieldValue.fuzzyCompareTo(baseValue, tolerance, ctx);
                return comparison.apply(comparisonResult);
            }
        };
    }

    private static enum Comparison implements Predicate<Integer>
    {
        GT{

            @Override
            public boolean apply(Integer integer) {
                return integer > 0;
            }
        }
        ,
        LT{

            @Override
            public boolean apply(Integer integer) {
                return integer < 0;
            }
        }
        ,
        LE{

            @Override
            public boolean apply(Integer integer) {
                return integer <= 0;
            }
        }
        ,
        GE{

            @Override
            public boolean apply(Integer integer) {
                return integer >= 0;
            }
        };

    }
}

