/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageFactories;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.contrib.MessageUtils;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.FieldSpec;
import com.google.protobuf.contrib.protopath.PathElement;
import com.google.protobuf.contrib.protopath.ProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class SingleProtoPath<M extends MessageOrBuilder, T>
extends ProtoPath<M, T> {
    private final String rootMessageName;
    private final boolean isRootABuilder;
    private final ProtoPath.Cardinality cardinality;
    private final boolean hasConditions;
    final ImmutableList<PathElement> pathElements;

    SingleProtoPath(String rootMessageName, boolean isRootABuilder, Iterable<PathElement> pathElements, Class<T> valueType) {
        super(valueType);
        this.rootMessageName = rootMessageName;
        this.isRootABuilder = isRootABuilder;
        this.pathElements = ImmutableList.copyOf(pathElements);
        boolean hasConditions = false;
        int numList = 0;
        for (PathElement pathElement : pathElements) {
            if (pathElement.returnsList()) {
                ++numList;
            }
            if (!pathElement.hasCondition()) continue;
            hasConditions = true;
        }
        this.hasConditions = hasConditions;
        if (this.pathElements.isEmpty()) {
            this.cardinality = ProtoPath.Cardinality.ALL_SINGLE;
        } else {
            boolean lastReturnsList = this.lastPathElement().returnsList();
            this.cardinality = numList == 0 ? ProtoPath.Cardinality.ALL_SINGLE : (lastReturnsList && numList == 1 ? ProtoPath.Cardinality.TERMINAL_MULTIPLE : ProtoPath.Cardinality.GENERIC);
        }
    }

    public Class<?> getSpecificValueType() {
        return this.lastPathElement().getActualReturnType(this.valueType);
    }

    public String getRootMessageName() {
        return this.rootMessageName;
    }

    @Override
    public ProtoPath.Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public boolean hasConditions() {
        return this.hasConditions;
    }

    public ImmutableList<FieldSpec> getAbsolutePath() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PathElement pathElement : this.pathElements) {
            builder.add((Object)pathElement.getFieldSpec());
        }
        return builder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(SingleProtoPath.class).add("rootMessage", this.getRootMessageName()).add("path", FieldSpec.join(this.getAbsolutePath(), new FieldSpec[0])).add("valueType", this.getValueType()).add("cardinality", (Object)this.getCardinality()).toString();
    }

    @Override
    public String unparse() {
        ArrayList<String> parts = new ArrayList<String>();
        for (PathElement pathElement : this.pathElements) {
            parts.add(pathElement.getFieldSpec().unparse());
        }
        return FieldSpec.SLASH_JOINER.join(parts);
    }

    @Override
    @Nullable
    public T tryGetValue(M messageOrBuilder, EvaluationContext ctx) throws ProtoPathException {
        if (this.getCardinality() != ProtoPath.Cardinality.ALL_SINGLE) {
            throw new ProtoPathException(ProtoPathException.Reason.WRONG_CARDINALITY, "tryGetValue only supports ALL_SINGLE. Given cardinality %s", new Object[]{this.getCardinality()});
        }
        Object current = messageOrBuilder;
        if (this.pathElements.isEmpty()) {
            return this.valueType.cast(current);
        }
        for (PathElement pathElement : this.pathElements.subList(0, this.pathElements.size() - 1)) {
            current = pathElement.tryGetValue((MessageOrBuilder)current, MessageOrBuilder.class, this.isValueABuilder, ctx);
            if (current != null) continue;
            return null;
        }
        return this.lastPathElement().tryGetValue((MessageOrBuilder)current, this.valueType, this.isValueABuilder, ctx);
    }

    @Override
    public T getValue(M messageOrBuilder, EvaluationContext ctx) throws ProtoPathException {
        if (this.getCardinality() != ProtoPath.Cardinality.ALL_SINGLE) {
            throw new ProtoPathException(ProtoPathException.Reason.WRONG_CARDINALITY, "tryGetValue only supports ALL_SINGLE given %s. use getValues() or evaluate()", new Object[]{this.getCardinality()});
        }
        T value = this.tryGetValue(messageOrBuilder, ctx);
        if (value != null) {
            return value;
        }
        return this.getDefaultValue();
    }

    @Override
    public ImmutableList<T> getValues(M messageOrBuilder, EvaluationContext ctx) {
        if (this.getCardinality() == ProtoPath.Cardinality.GENERIC) {
            throw new ProtoPathException(ProtoPathException.Reason.WRONG_CARDINALITY, "Not supported. Use evaluate", new Object[0]);
        }
        if (this.pathElements.isEmpty()) {
            return ImmutableList.of(this.valueType.cast(messageOrBuilder));
        }
        Object current = messageOrBuilder;
        for (PathElement pathElement : this.pathElements.subList(0, this.pathElements.size() - 1)) {
            current = pathElement.tryGetValue((MessageOrBuilder)current, MessageOrBuilder.class, this.isValueABuilder, ctx);
            if (current != null) continue;
            return ImmutableList.of();
        }
        return this.lastPathElement().getValues((MessageOrBuilder)current, this.valueType, this.isValueABuilder, ctx);
    }

    @Override
    public ProtoPath.SetValueResult setValue(M messageOrBuilder, T value, EvaluationContext ctx) throws ProtoPathException {
        boolean isMutable;
        boolean bl = isMutable = messageOrBuilder instanceof Message.Builder || messageOrBuilder instanceof MutableMessage;
        if (!isMutable) {
            throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "The supplied MessageOrBuilder instance must be a Builder type", new Object[0]);
        }
        if (this.pathElements.isEmpty()) {
            throw new ProtoPathException(ProtoPathException.Reason.INVALID_PATH, "Empty path invalid", new Object[0]);
        }
        ImmutableList<MessageOrBuilder> leafParentBuilders = this.evaluateParents(messageOrBuilder, ctx, true);
        if (leafParentBuilders.isEmpty()) {
            return ProtoPath.SetValueResult.NO_MATCH;
        }
        if (leafParentBuilders.size() > 1) {
            return ProtoPath.SetValueResult.TOO_MANY_MATCHES;
        }
        MessageOrBuilder leafParentBuilder = (MessageOrBuilder)leafParentBuilders.get(0);
        PathElement leafPathElement = this.lastPathElement();
        Descriptors.FieldDescriptor leafFieldDescriptor = leafPathElement.getFieldDescriptor();
        Object valueToSet = value;
        if (leafFieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            valueToSet = this.massageEnumType(value);
        }
        this.setFieldValue(leafPathElement.getFieldSpec(), leafFieldDescriptor, leafParentBuilder, valueToSet);
        return ProtoPath.SetValueResult.SUCCESS;
    }

    private Object massageEnumType(Object value) {
        if (Descriptors.EnumValueDescriptor.class.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (ProtocolMessageEnum.class.isAssignableFrom(value.getClass())) {
            ProtocolMessageEnum valueAsProtoEnum = (ProtocolMessageEnum)value;
            return valueAsProtoEnum.getValueDescriptor();
        }
        throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Type derived from EnumValueDescriptor or ProtocolMessageEnum required", new Object[0]);
    }

    private void setFieldValue(FieldSpec fieldSpec, Descriptors.FieldDescriptor fieldDescriptor, MessageOrBuilder parentBuilder, Object value) {
        if (fieldSpec.hasIndex()) {
            if (!fieldDescriptor.isRepeated()) {
                throw new ProtoPathException(ProtoPathException.Reason.MISMATCHED_PATHS, "Indexed non-repeated field", new Object[0]);
            }
            int count = parentBuilder.getRepeatedFieldCount(fieldDescriptor);
            Integer index = fieldSpec.getEffectiveIndex(count);
            if (index == null) {
                throw new ProtoPathException(ProtoPathException.Reason.INVALID_PATH, "Repeated field %s does not contain the target element", fieldSpec.getName());
            }
            SingleProtoPath.setRepeatedField(parentBuilder, fieldDescriptor, index, value);
        } else {
            if (fieldDescriptor.isRepeated()) {
                throw new ProtoPathException(ProtoPathException.Reason.MISMATCHED_PATHS, "Repeated field index required", new Object[0]);
            }
            SingleProtoPath.setField(parentBuilder, fieldDescriptor, value);
        }
    }

    private static void setRepeatedField(MessageOrBuilder messageOrBuilder, Descriptors.FieldDescriptor fieldDescriptor, Integer index, Object value) {
        if (messageOrBuilder instanceof Message.Builder) {
            ((Message.Builder)messageOrBuilder).setRepeatedField(fieldDescriptor, index, value);
        } else if (messageOrBuilder instanceof MutableMessage) {
            ((MutableMessage)messageOrBuilder).setRepeatedField(fieldDescriptor, index, value);
        } else {
            throw new IllegalStateException("Unexpected MessageOrBuilder type");
        }
    }

    private static void setField(MessageOrBuilder messageOrBuilder, Descriptors.FieldDescriptor fieldDescriptor, Object value) {
        if (messageOrBuilder instanceof Message.Builder) {
            ((Message.Builder)messageOrBuilder).setField(fieldDescriptor, value);
        } else if (messageOrBuilder instanceof MutableMessage) {
            ((MutableMessage)messageOrBuilder).setField(fieldDescriptor, value);
        } else {
            throw new IllegalStateException("Unexpected MessageOrBuilder type");
        }
    }

    @Override
    public ImmutableList<T> evaluate(M messageOrBuilder, EvaluationContext ctx) {
        if (this.pathElements.isEmpty()) {
            return ImmutableList.of(this.valueType.cast(messageOrBuilder));
        }
        ImmutableList<MessageOrBuilder> parents = this.evaluateParents(messageOrBuilder, ctx, this.isValueABuilder);
        return ImmutableList.copyOf(this.evaluateElement(parents, this.lastPathElement(), this.valueType, ctx, this.isValueABuilder));
    }

    private ImmutableList<MessageOrBuilder> evaluateParents(M messageOrBuilder, EvaluationContext ctx, boolean getBuilder) {
        List<MessageOrBuilder> currentValues = new ArrayList<MessageOrBuilder>();
        currentValues.add((MessageOrBuilder)messageOrBuilder);
        for (PathElement pathElement : this.pathElements.subList(0, this.pathElements.size() - 1)) {
            if (!(currentValues = this.evaluateElement(currentValues, pathElement, MessageOrBuilder.class, ctx, getBuilder)).isEmpty()) continue;
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(currentValues);
    }

    private <S> List<S> evaluateElement(List<MessageOrBuilder> messages, PathElement pathElement, Class<S> type, EvaluationContext ctx, boolean getBuilder) {
        ArrayList<S> answer = new ArrayList<S>();
        for (MessageOrBuilder messageOrBuilder : messages) {
            answer.addAll(pathElement.getValues(messageOrBuilder, type, getBuilder, ctx));
        }
        return answer;
    }

    @Override
    public boolean hasValue(M messageOrBuilder, EvaluationContext ctx) {
        if (this.getCardinality() == ProtoPath.Cardinality.GENERIC) {
            throw new ProtoPathException(ProtoPathException.Reason.INTERMEDIATE_REPEATED_FIELD, "Not supported.", new Object[0]);
        }
        Object current = messageOrBuilder;
        for (PathElement pathElement : this.pathElements.subList(0, this.pathElements.size() - 1)) {
            if (!pathElement.hasValue((MessageOrBuilder)current, MessageOrBuilder.class, ctx)) {
                return false;
            }
            current = pathElement.tryGetValue((MessageOrBuilder)current, MessageOrBuilder.class, false, ctx);
        }
        if (this.isValueABuilder) {
            return this.lastPathElement().hasValue((MessageOrBuilder)current, MessageOrBuilder.class, ctx);
        }
        return this.lastPathElement().hasValue((MessageOrBuilder)current, this.valueType, ctx);
    }

    @Override
    public Descriptors.FieldDescriptor getTerminalFieldDescriptor() {
        if (this.pathElements.isEmpty()) {
            throw new ProtoPathException(ProtoPathException.Reason.INVALID_PATH, "Empty path does not have a terminal field descriptor", new Object[0]);
        }
        return this.lastPathElement().getFieldDescriptor();
    }

    @Nullable
    public T getDefaultValue() {
        Object value;
        Object defaultValue = this.lastPathElement().getDefaultValue(this.valueType);
        if (defaultValue != null) {
            return defaultValue;
        }
        boolean isBuilder = SingleProtoPath.isBuilder(this.valueType);
        if (SingleProtoPath.isGenerated(this.valueType)) {
            Class<?> messageClass = isBuilder ? this.valueType.getEnclosingClass() : this.valueType;
            value = MessageUtils.getDefaultInstance(messageClass);
        } else {
            Descriptors.Descriptor messageDescriptor = this.lastPathElement().getMessageType();
            value = MessageFactories.getImmutableMessageFactory().getPrototype(messageDescriptor);
        }
        return this.valueType.cast(isBuilder ? value.newBuilderForType() : value);
    }

    PathElement lastPathElement() {
        return (PathElement)((Object)this.pathElements.get(this.pathElements.size() - 1));
    }

    boolean isRootABuilder() {
        return this.isRootABuilder;
    }

    static boolean isGenerated(Class<?> type) {
        return GeneratedMessage.class.isAssignableFrom(type) && !GeneratedMessage.class.equals(type) || GeneratedMessage.Builder.class.isAssignableFrom(type) && !GeneratedMessage.Builder.class.equals(type);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SingleProtoPath) {
            SingleProtoPath o = (SingleProtoPath)obj;
            return this.rootMessageName.equals(o.rootMessageName) && this.pathElements.equals(o.pathElements) && this.valueType.equals(o.valueType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.rootMessageName, this.pathElements, this.valueType);
    }
}

