/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.common.time.TimeSource;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.time.Instant;

public final class JavaTimeConversions {
    private JavaTimeConversions() {
    }

    public static Instant toJavaInstant(Timestamp timestamp) {
        timestamp = Timestamps.normalizedTimestamp(timestamp.getSeconds(), timestamp.getNanos());
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static java.time.Duration toJavaDuration(Duration duration) {
        duration = Durations.normalizedDuration(duration.getSeconds(), duration.getNanos());
        return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
    }

    public static Timestamp toProtoTimestamp(Instant instant) {
        return Timestamps.normalizedTimestamp(instant.getEpochSecond(), instant.getNano());
    }

    public static Duration toProtoDuration(java.time.Duration duration) {
        return Durations.normalizedDuration(duration.getSeconds(), duration.getNano());
    }

    public static Timestamp now(TimeSource timeSource) {
        return JavaTimeConversions.toProtoTimestamp(timeSource.now());
    }
}

