/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.Unicode;
import com.google.re2j.Utils;

final class Inst {
    public static final int ALT = 1;
    public static final int ALT_MATCH = 2;
    public static final int CAPTURE = 3;
    public static final int EMPTY_WIDTH = 4;
    public static final int FAIL = 5;
    public static final int MATCH = 6;
    public static final int NOP = 7;
    public static final int RUNE = 8;
    public static final int RUNE1 = 9;
    public static final int RUNE_ANY = 10;
    public static final int RUNE_ANY_NOT_NL = 11;
    int op;
    int out;
    int arg;
    int[] runes;

    Inst(int op) {
        this.op = op;
    }

    static boolean isRuneOp(int op) {
        return 8 <= op && op <= 11;
    }

    boolean matchRune(int r) {
        if (this.runes.length == 1) {
            int r0 = this.runes[0];
            if (r == r0) {
                return true;
            }
            if ((this.arg & 1) != 0) {
                int r1 = Unicode.simpleFold(r0);
                while (r1 != r0) {
                    if (r == r1) {
                        return true;
                    }
                    r1 = Unicode.simpleFold(r1);
                }
            }
            return false;
        }
        for (int j = 0; j < this.runes.length && j <= 8; j += 2) {
            if (r < this.runes[j]) {
                return false;
            }
            if (r > this.runes[j + 1]) continue;
            return true;
        }
        int lo = 0;
        int hi = this.runes.length / 2;
        while (lo < hi) {
            int m = lo + (hi - lo) / 2;
            int c = this.runes[2 * m];
            if (c <= r) {
                if (r <= this.runes[2 * m + 1]) {
                    return true;
                }
                lo = m + 1;
                continue;
            }
            hi = m;
        }
        return false;
    }

    public String toString() {
        switch (this.op) {
            case 1: {
                int n = this.out;
                int n2 = this.arg;
                return new StringBuilder(31).append("alt -> ").append(n).append(", ").append(n2).toString();
            }
            case 2: {
                int n = this.out;
                int n3 = this.arg;
                return new StringBuilder(36).append("altmatch -> ").append(n).append(", ").append(n3).toString();
            }
            case 3: {
                int n = this.arg;
                int n4 = this.out;
                return new StringBuilder(30).append("cap ").append(n).append(" -> ").append(n4).toString();
            }
            case 4: {
                int n = this.arg;
                int n5 = this.out;
                return new StringBuilder(32).append("empty ").append(n).append(" -> ").append(n5).toString();
            }
            case 6: {
                return "match";
            }
            case 5: {
                return "fail";
            }
            case 7: {
                int n = this.out;
                return new StringBuilder(18).append("nop -> ").append(n).toString();
            }
            case 8: {
                if (this.runes == null) {
                    return "rune <null>";
                }
                String string = Inst.escapeRunes(this.runes);
                String string2 = (this.arg & 1) != 0 ? "/i" : "";
                int n = this.out;
                return new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("rune ").append(string).append(string2).append(" -> ").append(n).toString();
            }
            case 9: {
                String string = Inst.escapeRunes(this.runes);
                int n = this.out;
                return new StringBuilder(21 + String.valueOf(string).length()).append("rune1 ").append(string).append(" -> ").append(n).toString();
            }
            case 10: {
                int n = this.out;
                return new StringBuilder(18).append("any -> ").append(n).toString();
            }
            case 11: {
                int n = this.out;
                return new StringBuilder(23).append("anynotnl -> ").append(n).toString();
            }
        }
        throw new IllegalStateException("unhandled case in Inst.toString");
    }

    private static String escapeRunes(int[] runes) {
        StringBuilder out = new StringBuilder();
        out.append('\"');
        for (int rune : runes) {
            Utils.escapeRune(out, rune);
        }
        out.append('\"');
        return out.toString();
    }
}

