/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.grpc;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.gapi.emulators.netty.HttpHandler;
import io.gapi.emulators.protobuf.HttpConfig;
import io.gapi.emulators.util.Observer;
import io.gapi.gax.protobuf.ProtoReflectionUtil;
import io.gapi.gax.protobuf.ValidationException;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@ChannelHandler.Sharable
@Beta
public abstract class HttpAdapter
extends HttpHandler {
    private static final Logger logger = Logger.getLogger(HttpAdapter.class.getName());
    private final Set<String> services = new HashSet<String>();
    private final List<MethodHandler> methodHandlers = new ArrayList<MethodHandler>();

    public void addService(Descriptors.ServiceDescriptor service, AbstractStub<?> client) throws IllegalArgumentException {
        this.addService(service, client, null);
    }

    public void addService(Descriptors.ServiceDescriptor service, AbstractStub<?> client, @Nullable Pattern ignorePattern) throws IllegalArgumentException {
        if (this.services.contains(service.getFullName())) {
            return;
        }
        ArrayList<MethodHandler> handlers = new ArrayList<MethodHandler>();
        for (Descriptors.MethodDescriptor method : service.getMethods()) {
            DescriptorProtos.MethodDescriptorProto methodProto;
            if (ignorePattern != null && ignorePattern.matcher(method.getFullName()).matches() || (methodProto = method.toProto()).getClientStreaming()) continue;
            if (methodProto.getServerStreaming()) {
                handlers.add(new UnsupportedMethodHandler(HttpConfig.create(method), "Cannot use streaming API over HTTP."));
                continue;
            }
            try {
                handlers.add(new UnaryMethodHandler(HttpConfig.create(method), method, client));
            }
            catch (ValidationException e) {
                String string = String.valueOf(method.getFullName());
                logger.logp(Level.WARNING, "io.gapi.emulators.grpc.HttpAdapter", "addService", string.length() != 0 ? "Failed to add method for service: ".concat(string) : new String("Failed to add method for service: "), e);
                throw e;
            }
            catch (ReflectiveOperationException e) {
                String string = String.valueOf(method.getFullName());
                logger.logp(Level.WARNING, "io.gapi.emulators.grpc.HttpAdapter", "addService", string.length() != 0 ? "Failed to add method for service: ".concat(string) : new String("Failed to add method for service: "), e);
                throw new IllegalArgumentException(e);
            }
        }
        this.methodHandlers.addAll(handlers);
        this.services.add(service.getFullName());
    }

    public void addMethodHandler(MethodHandler handler) {
        Preconditions.checkNotNull(handler);
        this.methodHandlers.add(handler);
    }

    @Override
    public void handleRequest(FullHttpRequest request, Observer<FullHttpResponse> observer) {
        if (!this.canHandleRequest(request)) {
            observer.onValue(null);
            return;
        }
        String path = HttpAdapter.stripLeadingSlash(URI.create(request.uri()).getPath()).replace("%", "%25").replace("+", "%2B");
        for (MethodHandler handler : this.methodHandlers) {
            ImmutableMap<String, String> values;
            HttpConfig config = handler.getConfig();
            if (!config.httpKind().name().equals(request.method().name()) || (values = config.pathTemplate().match(path)) == null) continue;
            HashMap<String, String> workaroundValues = new HashMap<String, String>();
            for (Map.Entry entry : values.entrySet()) {
                String workaroundValue = ((String)entry.getValue()).replace("%2B", "+").replace("%25", "%");
                workaroundValues.put((String)entry.getKey(), workaroundValue);
            }
            handler.handle(workaroundValues, request, observer);
            return;
        }
        observer.onValue(null);
    }

    protected abstract void merge(ByteString var1, Message.Builder var2) throws InvalidProtocolBufferException;

    protected abstract ByteString toResponse(Message var1) throws StatusException;

    protected abstract ByteString toResponse(Status var1);

    protected abstract boolean canHandleRequest(FullHttpRequest var1);

    protected void postprocessResponse(FullHttpResponse response) {
    }

    private static String stripLeadingSlash(String path) {
        if (!path.isEmpty() && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    private static Map<String, List<String>> getQueryParams(String query) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (query != null) {
            for (String param : query.split("&")) {
                String[] parts = param.split("=", 2);
                if (!params.containsKey(parts[0])) {
                    params.put(parts[0], new ArrayList());
                }
                ((List)params.get(parts[0])).add(parts.length == 2 ? parts[1] : "");
            }
        }
        return params;
    }

    private static void addAll(Map<String, List<String>> target, Map<String, String> source) {
        for (Map.Entry<String, String> entry : source.entrySet()) {
            if (!target.containsKey(entry.getKey())) {
                target.put(entry.getKey(), new ArrayList());
            }
            target.get(entry.getKey()).add(entry.getValue());
        }
    }

    private static Object toJavaType(Descriptors.FieldDescriptor.JavaType type, String value) {
        switch (type) {
            case INT: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case STRING: {
                return value;
            }
        }
        String string = String.valueOf(type.name());
        throw new IllegalArgumentException(string.length() != 0 ? "Unmapped JavaType: ".concat(string) : new String("Unmapped JavaType: "));
    }

    @VisibleForTesting
    static void mergeFields(Map<String, List<String>> params, Descriptors.Descriptor descriptor, Message.Builder builder) throws InvalidProtocolBufferException {
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            HttpAdapter.setFieldValues(descriptor, builder, entry.getKey(), entry.getValue());
        }
    }

    private static void setFieldValues(Descriptors.Descriptor descriptor, Message.Builder builder, String fieldStr, List<String> values) throws InvalidProtocolBufferException {
        List<String> path = Splitter.on('.').splitToList(fieldStr);
        for (int i = 0; i < path.size() - 1; ++i) {
            String fieldName = path.get(i);
            Descriptors.FieldDescriptor field = descriptor.findFieldByName(fieldName);
            if (field == null || !field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
                return;
            }
            builder = builder.getFieldBuilder(field);
            descriptor = field.getMessageType();
        }
        String fieldName = path.get(path.size() - 1);
        Descriptors.FieldDescriptor field = descriptor.findFieldByName(fieldName);
        if (field == null) {
            return;
        }
        Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
        while (javaType.equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
            builder = builder.getFieldBuilder(field);
            List<Descriptors.FieldDescriptor> fields = field.getMessageType().getFields();
            if (fields.size() != 1) {
                return;
            }
            field = fields.get(0);
            javaType = field.getJavaType();
        }
        if (field.isRepeated()) {
            for (String value : values) {
                builder.addRepeatedField(field, HttpAdapter.toJavaType(javaType, value));
            }
        } else {
            if (values.size() > 1) {
                String string = String.valueOf(fieldStr);
                throw new InvalidProtocolBufferException(string.length() != 0 ? "Multiple values for non-repeated field: ".concat(string) : new String("Multiple values for non-repeated field: "));
            }
            builder.setField(field, HttpAdapter.toJavaType(javaType, values.get(0)));
        }
    }

    protected static int toHttpCode(Status.Code statusCode) {
        switch (statusCode) {
            case ABORTED: 
            case ALREADY_EXISTS: {
                return 409;
            }
            case CANCELLED: {
                return 499;
            }
            case DEADLINE_EXCEEDED: {
                return 504;
            }
            case NOT_FOUND: {
                return 404;
            }
            case OK: {
                return 200;
            }
            case FAILED_PRECONDITION: 
            case INVALID_ARGUMENT: 
            case OUT_OF_RANGE: {
                return 400;
            }
            case PERMISSION_DENIED: {
                return 403;
            }
            case RESOURCE_EXHAUSTED: {
                return 429;
            }
            case UNAUTHENTICATED: {
                return 401;
            }
            case UNAVAILABLE: {
                return 503;
            }
            case UNIMPLEMENTED: {
                return 501;
            }
        }
        return 500;
    }

    @Override
    protected final FullHttpResponse transformError(Throwable t) {
        Status status = t instanceof StatusException ? ((StatusException)t).getStatus() : (t instanceof StatusRuntimeException ? ((StatusRuntimeException)t).getStatus() : Status.INTERNAL.withCause(t).withDescription("Internal"));
        return this.buildResponse(HttpResponseStatus.valueOf(HttpAdapter.toHttpCode(status.getCode())), Unpooled.copiedBuffer(this.toResponse(status).toByteArray()));
    }

    protected static String getContentType(FullHttpRequest request) {
        String contentType = request.headers().get(HttpHeaderNames.CONTENT_TYPE, "");
        return contentType.split(";", 1)[0];
    }

    protected FullHttpResponse buildResponse(HttpResponseStatus status, ByteBuf content) {
        return this.buildResponse(HttpVersion.HTTP_1_1, status, content);
    }

    private FullHttpResponse buildResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(version, status);
        response.content().writeBytes(content);
        this.postprocessResponse(response);
        response.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
        return response;
    }

    public static class UnsupportedMethodHandler
    extends MethodHandler {
        private final String errorMessage;

        public UnsupportedMethodHandler(HttpConfig config, String errorMessage) {
            super(config);
            this.errorMessage = errorMessage;
        }

        @Override
        public void handle(Map<String, String> templateValues, FullHttpRequest request, Observer<FullHttpResponse> observer) {
            observer.onError(Status.UNIMPLEMENTED.withDescription(this.errorMessage).asException());
        }
    }

    public class UnaryMethodHandler
    extends MethodHandler {
        private final Descriptors.MethodDescriptor method;
        private final AbstractStub<?> client;
        private final Message defaultInputInstance;
        private final Method javaMethod;

        public UnaryMethodHandler(HttpConfig config, Descriptors.MethodDescriptor method, AbstractStub<?> client) throws ReflectiveOperationException {
            super(config);
            this.method = method;
            this.client = client;
            this.defaultInputInstance = ProtoReflectionUtil.getDefaultInstance(method.getInputType());
            this.javaMethod = client.getClass().getDeclaredMethod(this.getJavaMethodName(method.getName()), this.defaultInputInstance.getClass(), StreamObserver.class);
            this.javaMethod.setAccessible(true);
        }

        @Override
        public void handle(Map<String, String> templateValues, FullHttpRequest request, final Observer<FullHttpResponse> observer) {
            Message.Builder inputBuilder;
            StreamObserver<Message> responseObserver = new StreamObserver<Message>(){
                private Message value;

                @Override
                public void onNext(Message value) {
                    this.value = value;
                }

                @Override
                public void onError(Throwable t) {
                    observer.onError(t);
                }

                @Override
                public void onCompleted() {
                    try {
                        observer.onValue(HttpAdapter.this.buildResponse(HttpResponseStatus.OK, Unpooled.copiedBuffer(HttpAdapter.this.toResponse(this.value).toByteArray())));
                    }
                    catch (Throwable t) {
                        observer.onError(t);
                    }
                }
            };
            Map params = HttpAdapter.getQueryParams(URI.create(request.uri()).getQuery());
            HttpAdapter.addAll(params, templateValues);
            ByteString body = ByteString.copyFrom(request.content().copy().nioBuffer());
            try {
                inputBuilder = this.defaultInputInstance.newBuilderForType();
                HttpAdapter.mergeFields(params, this.method.getInputType(), inputBuilder);
                HttpConfig config = this.getConfig();
                if (!body.isEmpty() && config.hasBody()) {
                    if (config.bodyCapturesAllUnbound()) {
                        HttpAdapter.this.merge(body, inputBuilder);
                    } else {
                        Descriptors.FieldDescriptor bodyField = this.method.getInputType().findFieldByName(config.body());
                        HttpAdapter.this.merge(body, inputBuilder.getFieldBuilder(bodyField));
                    }
                }
            }
            catch (InvalidProtocolBufferException e) {
                String string = String.valueOf(e.getMessage());
                logger.logp(Level.WARNING, "io.gapi.emulators.grpc.HttpAdapter$UnaryMethodHandler", "handle", string.length() != 0 ? "Failed to convert request to message: ".concat(string) : new String("Failed to convert request to message: "), e);
                responseObserver.onError(Status.INVALID_ARGUMENT.withDescription("Payload isn't valid for request.").withCause(e).asException());
                return;
            }
            Metadata headers = new Metadata();
            for (Map.Entry entry : request.headers()) {
                headers.put(Metadata.Key.of((String)entry.getKey(), Metadata.ASCII_STRING_MARSHALLER), (String)entry.getValue());
            }
            Object requestStub = this.client.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(headers));
            try {
                ProtoReflectionUtil.invoke(Void.TYPE, this.javaMethod, requestStub, inputBuilder.build(), responseObserver);
            }
            catch (Throwable t) {
                observer.onError(t);
            }
        }

        private String getJavaMethodName(String serviceMethod) {
            if (serviceMethod.isEmpty()) {
                return serviceMethod;
            }
            String string = String.valueOf(serviceMethod.substring(0, 1).toLowerCase());
            String string2 = String.valueOf(serviceMethod.substring(1));
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
    }

    public static abstract class MethodHandler {
        private final HttpConfig config;

        MethodHandler(HttpConfig config) {
            Preconditions.checkNotNull(config);
            this.config = config;
        }

        abstract void handle(Map<String, String> var1, FullHttpRequest var2, Observer<FullHttpResponse> var3);

        HttpConfig getConfig() {
            return this.config;
        }
    }
}

