/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import io.gapi.emulators.netty.CrossOriginHeaders;
import io.gapi.emulators.util.Observer;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public abstract class HttpHandler
extends ChannelDuplexHandler {
    private static final Logger logger = Logger.getLogger(HttpHandler.class.getName());

    @Override
    public final void channelRead(final ChannelHandlerContext ctx, final Object msg) {
        if (!(msg instanceof FullHttpRequest)) {
            ctx.fireChannelRead(msg);
            return;
        }
        final FullHttpRequest request = (FullHttpRequest)msg;
        this.handleRequest(request, new Observer<FullHttpResponse>(){

            @Override
            public void onValue(FullHttpResponse value) {
                if (value != null) {
                    value.setProtocolVersion(request.protocolVersion());
                    CrossOriginHeaders.addHeaders(request, value);
                    ctx.writeAndFlush(value);
                    return;
                }
                ctx.fireChannelRead(msg);
            }

            @Override
            public void onError(Throwable t) {
                String string = String.valueOf(t.getMessage());
                logger.logp(Level.INFO, "io.gapi.emulators.netty.HttpHandler$1", "onError", string.length() != 0 ? "Exception when handling request: ".concat(string) : new String("Exception when handling request: "));
                this.onValue(HttpHandler.this.transformError(t));
            }
        });
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public abstract void handleRequest(FullHttpRequest var1, Observer<FullHttpResponse> var2);

    protected abstract FullHttpResponse transformError(Throwable var1);
}

