/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import io.gapi.emulators.netty.SimpleHttpHandler;
import io.gapi.emulators.util.Observer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@Beta
public class NotFoundHandler
extends SimpleHttpHandler {
    private static final Logger logger = Logger.getLogger(NotFoundHandler.class.getName());

    public NotFoundHandler() {
        super("*", Pattern.compile(".*"));
    }

    @Override
    protected void handleRequest(FullHttpRequest request, Observer<FullHttpResponse> observer) {
        String string = String.valueOf(request.uri());
        logger.logp(Level.INFO, "io.gapi.emulators.netty.NotFoundHandler", "handleRequest", string.length() != 0 ? "Unknown request URI: ".concat(string) : new String("Unknown request URI: "));
        observer.onValue(NotFoundHandler.writeUtf8("Not Found\n", new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.NOT_FOUND)));
    }
}

