/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import io.gapi.emulators.netty.SimpleHttpHandler;
import io.gapi.emulators.util.Observer;
import io.gapi.emulators.util.PersistException;
import io.gapi.emulators.util.Persistable;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.regex.Pattern;

@ChannelHandler.Sharable
@Beta
public class PersistHandler
extends SimpleHttpHandler {
    private final Persistable target;

    public PersistHandler(String pathRegex, Persistable target) {
        super("POST", Pattern.compile(pathRegex));
        this.target = target;
    }

    @Override
    protected void handleRequest(FullHttpRequest request, Observer<FullHttpResponse> observer) {
        try {
            this.target.persist();
            observer.onValue(PersistHandler.writeUtf8("Persisting...\n", new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK)));
        }
        catch (PersistException e) {
            observer.onError(e);
        }
    }
}

