/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import io.gapi.emulators.netty.CrossOriginHeaders;
import io.gapi.emulators.util.Observer;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@Beta
public abstract class SimpleHttpHandler
extends ChannelDuplexHandler {
    private static final Logger logger = Logger.getLogger(SimpleHttpHandler.class.getName());
    private final String httpMethod;
    private final Pattern pathRegex;

    public SimpleHttpHandler(String httpMethod, Pattern pathRegex) {
        this.httpMethod = httpMethod;
        this.pathRegex = pathRegex;
    }

    @Override
    public final void channelRead(final ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            final FullHttpRequest request = (FullHttpRequest)msg;
            String method = request.method().name();
            try {
                URI uri = new URI(request.uri());
                if ((this.httpMethod.equals("*") || method.equals(this.httpMethod)) && this.pathRegex.matcher(uri.getPath()).matches()) {
                    this.handleRequest(request, new Observer<FullHttpResponse>(this){

                        @Override
                        public void onValue(FullHttpResponse response) {
                            CrossOriginHeaders.addHeaders(request, response);
                            response.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
                            ctx.writeAndFlush(response);
                        }

                        @Override
                        public void onError(Throwable t) {
                            FullHttpResponse response = SimpleHttpHandler.writeUtf8(t.getMessage(), new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR));
                            response.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
                            ctx.writeAndFlush(response);
                        }
                    });
                    return;
                }
            }
            catch (URISyntaxException e) {
                String string = String.valueOf(request.uri());
                logger.logp(Level.WARNING, "io.gapi.emulators.netty.SimpleHttpHandler", "channelRead", string.length() != 0 ? "Bad URI: ".concat(string) : new String("Bad URI: "));
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected static FullHttpResponse writeUtf8(String content, FullHttpResponse response) {
        ByteBufUtil.writeUtf8(response.content(), (CharSequence)content);
        return response;
    }

    protected abstract void handleRequest(FullHttpRequest var1, Observer<FullHttpResponse> var2);
}

