/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ChannelHandler.Sharable
@Beta
public class UnsupportedApiVersionHandler
extends ChannelDuplexHandler {
    @VisibleForTesting
    static final Pattern VERSION_PATTERN = Pattern.compile("^/(v\\d+[^/]*)/");
    private static final Logger logger = Logger.getLogger(UnsupportedApiVersionHandler.class.getName());
    private final Set<String> supportedVersions = new HashSet<String>();
    private final List<Pattern> supportedVersionPatterns = new ArrayList<Pattern>();

    @Override
    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            try {
                String version;
                URI uri = new URI(request.uri());
                String path = uri.getPath();
                Matcher m = VERSION_PATTERN.matcher(path);
                if (m.find() && !this.isSupportedVersion(version = m.group(1))) {
                    String string = request.uri();
                    logger.logp(Level.INFO, "io.gapi.emulators.netty.UnsupportedApiVersionHandler", "channelRead", new StringBuilder(28 + String.valueOf(version).length() + String.valueOf(string).length()).append("Unsupported API version \"").append(version).append("\": ").append(string).toString());
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.NOT_FOUND);
                    ByteBufUtil.writeUtf8(response.content(), (CharSequence)new StringBuilder(39 + String.valueOf(version).length()).append("Not Found (Unsupported API version \"").append(version).append("\")\n").toString());
                    response.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
                    ctx.writeAndFlush(response);
                    return;
                }
            }
            catch (URISyntaxException e) {
                String string = String.valueOf(request.uri());
                logger.logp(Level.WARNING, "io.gapi.emulators.netty.UnsupportedApiVersionHandler", "channelRead", string.length() != 0 ? "Bad URI: ".concat(string) : new String("Bad URI: "));
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void addSupportedVersion(String supportedVersion) {
        this.supportedVersions.add(supportedVersion);
    }

    public void addSupportedVersionPattern(String supportedVersionPattern) {
        this.supportedVersionPatterns.add(Pattern.compile(supportedVersionPattern));
    }

    public boolean isSupportedVersion(String version) {
        if (this.supportedVersions.contains(version)) {
            return true;
        }
        for (Pattern p : this.supportedVersionPatterns) {
            if (!p.matcher(version).find()) continue;
            return true;
        }
        return false;
    }
}

