/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.protobuf;

import com.google.api.AnnotationsProto;
import com.google.api.HttpRule;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.Beta;
import com.google.protobuf.Descriptors;
import io.gapi.emulators.protobuf.AutoValue_HttpConfig;
import io.gapi.gax.protobuf.PathTemplate;
import io.gapi.gax.protobuf.ValidationException;
import javax.annotation.Nullable;

@Beta
@AutoValue
public abstract class HttpConfig {
    public static HttpConfig create(Descriptors.MethodDescriptor method) {
        ValidationException.pushCurrentThreadValidationContext(method.getFullName());
        try {
            if (!method.getOptions().hasExtension(AnnotationsProto.http)) {
                throw new ValidationException("no google.api.http option from which to derive http configuration", new Object[0]);
            }
            HttpRule rule = method.getOptions().getExtension(AnnotationsProto.http);
            switch (rule.getPatternCase()) {
                case GET: {
                    HttpConfig httpConfig = HttpConfig.create(HttpKind.GET, PathTemplate.create(rule.getGet()), "");
                    return httpConfig;
                }
                case PUT: {
                    HttpConfig httpConfig = HttpConfig.create(HttpKind.PUT, PathTemplate.create(rule.getPut()), rule.getBody());
                    return httpConfig;
                }
                case PATCH: {
                    HttpConfig httpConfig = HttpConfig.create(HttpKind.PATCH, PathTemplate.create(rule.getPatch()), rule.getBody());
                    return httpConfig;
                }
                case DELETE: {
                    HttpConfig httpConfig = HttpConfig.create(HttpKind.DELETE, PathTemplate.create(rule.getDelete()), rule.getBody());
                    return httpConfig;
                }
                case POST: {
                    HttpConfig httpConfig = HttpConfig.create(HttpKind.POST, PathTemplate.create(rule.getPost()), rule.getBody());
                    return httpConfig;
                }
            }
            throw new ValidationException("unsupported http kind '%s'", rule.getPatternCase());
        }
        finally {
            ValidationException.popCurrentThreadValidationContext();
        }
    }

    @Nullable
    public static HttpConfig createIfPresent(Descriptors.MethodDescriptor method) {
        if (!method.getOptions().hasExtension(AnnotationsProto.http)) {
            return null;
        }
        return HttpConfig.create(method);
    }

    public static HttpConfig create(HttpKind kind, PathTemplate template, @Nullable String body) {
        return new AutoValue_HttpConfig(kind, template, body);
    }

    public abstract HttpKind httpKind();

    public abstract PathTemplate pathTemplate();

    public abstract String body();

    public boolean hasBody() {
        return !this.body().isEmpty();
    }

    public boolean bodyCapturesAllUnbound() {
        return "*".equals(this.body());
    }

    public static enum HttpKind {
        GET,
        PUT,
        PATCH,
        POST,
        DELETE;

    }
}

