/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.util;

import com.google.common.annotations.Beta;
import io.gapi.emulators.util.Observer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@Beta
public final class ObserverFuture<V>
implements Observer<V> {
    private V value = null;
    private Throwable t = null;
    private CountDownLatch ready = new CountDownLatch(1);

    @Override
    public synchronized void onValue(V value) {
        if (this.ready.getCount() > 0L) {
            this.value = value;
            this.ready.countDown();
        }
    }

    @Override
    public synchronized void onError(Throwable t) {
        if (this.ready.getCount() > 0L) {
            this.t = t;
            this.ready.countDown();
        }
    }

    public V get() throws Throwable {
        this.ready.await();
        if (this.t != null) {
            throw this.t;
        }
        return this.value;
    }

    public V get(long timeout, TimeUnit unit) throws Throwable {
        if (!this.ready.await(timeout, unit)) {
            return null;
        }
        if (this.t != null) {
            throw this.t;
        }
        return this.value;
    }
}

