/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.gax.protobuf;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import io.gapi.gax.protobuf.AutoValue_Expression_Call;
import io.gapi.gax.protobuf.AutoValue_Expression_Constant;
import io.gapi.gax.protobuf.AutoValue_Expression_Identifier;
import io.gapi.gax.protobuf.AutoValue_Expression_Token;
import io.gapi.gax.protobuf.ProtoReflectionUtil;
import io.gapi.gax.protobuf.Type;
import io.gapi.gax.protobuf.ValidationException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@Beta
public abstract class Expression {
    static final Key<Type> TYPE_ATTRIBUTE = Key.get(Type.class, (Annotation)Names.named((String)"type"));
    static final Key<Descriptors.FieldDescriptor> FIELD_ATTRIBUTE = Key.get(Descriptors.FieldDescriptor.class, (Annotation)Names.named((String)"field"));
    private Map<Key<?>, Object> attributes = Maps.newHashMap();
    private static final Operation SELECT_OPERATION = new Operation(){

        @Override
        String print(List<String> arguments) {
            String string = arguments.get(0);
            String string2 = arguments.get(1);
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
        }

        @Override
        void check(Call node) {
            Expression operand = (Expression)node.arguments().get(0);
            Expression field = (Expression)node.arguments().get(1);
            if (!(field instanceof AutoValue_Expression_Constant)) {
                throw new ValidationException("field selector must be a constant", new Object[0]);
            }
            Expression.requireType(field, Type.STRING);
            String fieldName = (String)((AutoValue_Expression_Constant)field).value();
            Descriptors.FieldDescriptor descriptor = Expression.resolveField(operand.requireAttribute(TYPE_ATTRIBUTE), fieldName);
            node.putAttribute(TYPE_ATTRIBUTE, Type.forField(descriptor));
            node.putAttribute(FIELD_ATTRIBUTE, descriptor);
        }

        @Override
        Object eval(Call node, List<Object> arguments) {
            Object operand = arguments.get(0);
            Descriptors.FieldDescriptor field = node.requireAttribute(FIELD_ATTRIBUTE);
            return ((Message)operand).getField(field);
        }

        @Override
        Message.Builder assign(Call node, Message.Builder targetBuilder, List<Expression> arguments, Object value) {
            Expression operand = arguments.get(0);
            Descriptors.FieldDescriptor field = node.requireAttribute(FIELD_ATTRIBUTE);
            operand.getBuilder(targetBuilder).setField(field, value);
            return targetBuilder;
        }

        @Override
        Message.Builder getBuilder(Call node, Message.Builder targetBuilder, List<Expression> arguments) {
            Descriptors.FieldDescriptor field = node.requireAttribute(FIELD_ATTRIBUTE);
            return targetBuilder.getFieldBuilder(field);
        }
    };
    private static final Operation INDEX_OPERATION = new Operation(){

        @Override
        String print(List<String> arguments) {
            String string = arguments.get(0);
            String string2 = arguments.get(1);
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("[").append(string2).append("]").toString();
        }

        @Override
        void check(Call node) {
            Type operandType = ((Expression)node.arguments().get(0)).requireAttribute(TYPE_ATTRIBUTE);
            if (operandType.isMap()) {
                Expression.requireType((Expression)node.arguments().get(1), operandType.getMapKeyType());
                node.putAttribute(TYPE_ATTRIBUTE, operandType.getMapValueType());
            } else if (operandType.isRepeated()) {
                Expression.requireType((Expression)node.arguments().get(1), Type.INT64);
                node.putAttribute(TYPE_ATTRIBUTE, operandType.getRepeatedElemType());
            } else {
                throw new ValidationException("index operation not applicable", new Object[0]);
            }
        }

        @Override
        Object eval(Call node, List<Object> arguments) {
            Type operandType = ((Expression)node.arguments().get(0)).requireAttribute(TYPE_ATTRIBUTE);
            if (operandType.isMap()) {
                return ((Map)arguments.get(0)).get(arguments.get(1));
            }
            if (operandType.isRepeated()) {
                return ((List)arguments.get(0)).get((int)((Long)arguments.get(1)).longValue());
            }
            throw new IllegalStateException("unexpected operand type for index operation");
        }
    };
    private static final String IDENTIFIER_PAT = "[a-zA-Z][a-zA-Z0-9_]*";
    private static final String STRING_PAT = "\"[^\"]*\"";
    private static final String NUMBER_PAT = "-?[0-9]+";
    private static final String SPECIAL_PAT = "\\.|\\[|\\]";
    private static final Pattern TOKEN = Pattern.compile(String.format("(?m)\\s*((?<identifier>%s)|(?<string>%s)|(?<number>%s)|(?<special>%s))\\s*", "[a-zA-Z][a-zA-Z0-9_]*", "\"[^\"]*\"", "-?[0-9]+", "\\.|\\[|\\]"));

    public static Expression parsePath(Descriptors.Descriptor targetType, String source) {
        Parser parser = new Parser(targetType, source);
        Expression result = parser.parsePathExpr();
        parser.checkEof();
        return result;
    }

    public static Expression tryParsePath(Descriptors.Descriptor targetType, String source) {
        try {
            return Expression.parsePath(targetType, source);
        }
        catch (ValidationException e) {
            return null;
        }
    }

    public Type getType() {
        return this.getAttribute(TYPE_ATTRIBUTE);
    }

    public abstract Object eval(MessageOrBuilder var1);

    public <T> T eval(Class<T> type, MessageOrBuilder targetValue) {
        return type.cast(this.eval(targetValue));
    }

    public Message.Builder assign(Message.Builder targetBuilder, Object value) {
        throw new ExecutionException("expression is not assignable: %s", new Object[]{this});
    }

    protected Message.Builder getBuilder(Message.Builder targetBuilder) {
        throw new ExecutionException("expression is not assignable: %s", new Object[]{this});
    }

    <T> T getAttribute(Key<T> key) {
        return (T)this.attributes.get(key);
    }

    <T> T requireAttribute(Key<T> key) {
        T x = this.getAttribute(key);
        if (x != null) {
            return x;
        }
        throw new ExecutionException("%s attribute is not available for: %s", new Object[]{((Named)key.getAnnotation()).value(), this});
    }

    @Nullable
    <T> T putAttribute(Key<T> key, T value) {
        return (T)this.attributes.put(key, Preconditions.checkNotNull(value));
    }

    void check(Type targetType) {
        ValidationException.pushCurrentThreadValidationContext(new Supplier<String>(){

            @Override
            public String get() {
                String string = Expression.this.toString();
                return new StringBuilder(16 + String.valueOf(string).length()).append("in expression '").append(string).append("'").toString();
            }
        });
        try {
            this.doCheck(targetType);
        }
        finally {
            ValidationException.popCurrentThreadValidationContext();
        }
    }

    protected void doCheck(Type targetType) {
    }

    private static void requireType(Expression node, Type type) {
        Type providedType = node.requireAttribute(TYPE_ATTRIBUTE);
        if (!providedType.equals(type)) {
            throw new ValidationException("provided type '%s' does not match expected type '%s'", providedType, type);
        }
    }

    private static Descriptors.FieldDescriptor resolveField(Type operandType, String name) {
        if (!operandType.isMessage()) {
            throw new ValidationException("'%s' is not a message so field '%s' cannot be selected from it", operandType, name);
        }
        Descriptors.FieldDescriptor field = operandType.getMessageDescriptor().findFieldByName(name);
        if (field == null) {
            throw new ValidationException("field '%s' is not declared in '%s'", name, operandType);
        }
        return field;
    }

    private static List<Token> scan(String source) {
        int end;
        ImmutableList.Builder tokens;
        block7: {
            tokens = ImmutableList.builder();
            Matcher matcher = TOKEN.matcher(source);
            end = 0;
            while (true) {
                matcher.region(end, source.length());
                if (!matcher.lookingAt()) break block7;
                int position = matcher.start(1);
                end = matcher.end();
                String match = matcher.group("identifier");
                if (match != null) {
                    tokens.add(Token.create(TokenKind.IDENTIFIER, match, position));
                    continue;
                }
                match = matcher.group("string");
                if (match != null) {
                    match = match.substring(1, match.length() - 1);
                    tokens.add(Token.create(TokenKind.CONSTANT, match, position));
                    continue;
                }
                match = matcher.group("number");
                if (match != null) {
                    long value;
                    try {
                        value = Long.parseLong(match);
                    }
                    catch (NumberFormatException e) {
                        throw new ValidationException("Invalid integer number format '%s'", match);
                    }
                    tokens.add(Token.create(TokenKind.CONSTANT, value, position));
                    continue;
                }
                match = matcher.group("special");
                if (match == null) break;
                tokens.add(Token.create(TokenKind.SPECIAL, match, position));
            }
            throw new IllegalStateException("unexpected expression scan result");
        }
        if (end < source.length()) {
            throw new ValidationException("unrecognized input '%s'", source.substring(end));
        }
        tokens.add(Token.create(TokenKind.EOF, "<eof>", source.length()));
        return tokens.build();
    }

    @AutoValue
    static abstract class Token {
        Token() {
        }

        abstract TokenKind kind();

        abstract Object value();

        abstract int position();

        static Token create(TokenKind kind, Object value, int position) {
            return new AutoValue_Expression_Token(kind, value, position);
        }
    }

    static enum TokenKind {
        IDENTIFIER,
        CONSTANT,
        SPECIAL,
        EOF;

    }

    private static class Parser {
        private final ListIterator<Token> input;
        private Type targetType;

        Parser(Descriptors.Descriptor targetMessage, String source) {
            this.targetType = Type.forMessage(targetMessage);
            this.input = Expression.scan(source).listIterator();
        }

        private void checkEof() {
            this.accept(TokenKind.EOF);
        }

        private Expression parsePathExpr() {
            Expression result = this.parseId();
            while (true) {
                if (this.acceptIf(TokenKind.SPECIAL, ".")) {
                    result = this.parseSelect(result);
                    continue;
                }
                if (!this.acceptIf(TokenKind.SPECIAL, "[")) break;
                result = this.parseIndex(result);
            }
            return result;
        }

        private Expression parseId() {
            Token id = this.accept(TokenKind.IDENTIFIER);
            AutoValue_Expression_Identifier result = new AutoValue_Expression_Identifier((String)id.value());
            result.check(this.targetType);
            return result;
        }

        private Expression parseSelect(Expression operand) {
            Token id = this.accept(TokenKind.IDENTIFIER);
            AutoValue_Expression_Constant fieldExpr = new AutoValue_Expression_Constant(id.value());
            fieldExpr.check(this.targetType);
            AutoValue_Expression_Call result = new AutoValue_Expression_Call(SELECT_OPERATION, ImmutableList.of(operand, fieldExpr));
            result.check(this.targetType);
            return result;
        }

        private Expression parseIndex(Expression operand) {
            Token constant = this.accept(TokenKind.CONSTANT);
            AutoValue_Expression_Constant constantExpr = new AutoValue_Expression_Constant(constant.value());
            constantExpr.check(this.targetType);
            AutoValue_Expression_Call result = new AutoValue_Expression_Call(INDEX_OPERATION, ImmutableList.of(operand, constantExpr));
            this.accept(TokenKind.SPECIAL, "]");
            result.check(this.targetType);
            return result;
        }

        private Token accept(TokenKind kind) {
            return this.accept(kind, null);
        }

        private Token accept(TokenKind kind, @Nullable Object value) {
            Token next = this.input.next();
            if (next.kind() == kind && (value == null || value.equals(next.value()))) {
                return next;
            }
            this.input.previous();
            throw new ValidationException("unexpected token '%s', expected '%s'", next.value(), kind == TokenKind.EOF ? "<end of input>" : kind.toString());
        }

        private boolean acceptIf(TokenKind kind, Object value) {
            Token next = this.input.next();
            if (next.kind() == kind && next.value().equals(value)) {
                return true;
            }
            this.input.previous();
            return false;
        }
    }

    static abstract class Operation {
        Operation() {
        }

        abstract String print(List<String> var1);

        abstract void check(Call var1);

        abstract Object eval(Call var1, List<Object> var2);

        Message.Builder assign(Call node, Message.Builder targetBuilder, List<Expression> args, Object value) {
            throw new ExecutionException("expression is not assignable: %s", new Object[]{node});
        }

        Message.Builder getBuilder(Call node, Message.Builder targetBuilder, List<Expression> args) {
            throw new ExecutionException("expression is not assignable: %s", new Object[]{node});
        }
    }

    @AutoValue
    static abstract class Call
    extends Expression {
        Call() {
        }

        abstract Operation operation();

        abstract ImmutableList<Expression> arguments();

        public String toString() {
            return this.operation().print(FluentIterable.from(this.arguments()).transform(new Function<Expression, String>(this){

                @Override
                public String apply(Expression arg) {
                    return arg.toString();
                }
            }).toList());
        }

        @Override
        protected void doCheck(Type targetType) {
            this.operation().check(this);
        }

        @Override
        public Object eval(MessageOrBuilder targetValue) {
            return this.operation().eval(this, Call.evalArgs(targetValue, this.arguments()));
        }

        private static List<Object> evalArgs(final MessageOrBuilder targetValue, List<Expression> args) {
            return FluentIterable.from(args).transform(new Function<Expression, Object>(){

                @Override
                public Object apply(Expression expr) {
                    return expr.eval(targetValue);
                }
            }).toList();
        }

        @Override
        public Message.Builder assign(Message.Builder targetBuilder, Object value) {
            this.operation().assign(this, targetBuilder, this.arguments(), value);
            return targetBuilder;
        }

        @Override
        protected Message.Builder getBuilder(Message.Builder targetBuilder) {
            return this.operation().getBuilder(this, targetBuilder, this.arguments());
        }
    }

    @AutoValue
    static abstract class Constant
    extends Expression {
        Constant() {
        }

        abstract Object value();

        public String toString() {
            return this.value().toString();
        }

        @Override
        protected void doCheck(Type targetType) {
            this.putAttribute(TYPE_ATTRIBUTE, Type.forJavaType(this.value().getClass()));
        }

        @Override
        public Object eval(MessageOrBuilder targetValue) {
            return this.value();
        }
    }

    @AutoValue
    static abstract class Identifier
    extends Expression {
        Identifier() {
        }

        abstract String id();

        public String toString() {
            return this.id();
        }

        @Override
        protected void doCheck(Type targetType) {
            Descriptors.FieldDescriptor field = Expression.resolveField(targetType, this.id());
            this.putAttribute(FIELD_ATTRIBUTE, field);
            this.putAttribute(TYPE_ATTRIBUTE, Type.forField(field));
        }

        @Override
        public Object eval(MessageOrBuilder targetValue) {
            return ProtoReflectionUtil.getField((GeneratedMessage)targetValue, (Descriptors.FieldDescriptor)this.requireAttribute(FIELD_ATTRIBUTE));
        }

        @Override
        public Message.Builder assign(Message.Builder targetBuilder, Object value) {
            targetBuilder.setField((Descriptors.FieldDescriptor)this.requireAttribute(FIELD_ATTRIBUTE), value);
            return targetBuilder;
        }

        @Override
        protected Message.Builder getBuilder(Message.Builder targetBuilder) {
            return targetBuilder.getFieldBuilder((Descriptors.FieldDescriptor)this.requireAttribute(FIELD_ATTRIBUTE));
        }
    }

    public static class ExecutionException
    extends IllegalArgumentException {
        private ExecutionException(String format, Object ... args) {
            super(String.format(format, args));
        }
    }
}

