/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.gax.protobuf;

import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Stack;

@Beta
public class ValidationException
extends IllegalArgumentException {
    private static ThreadLocal<Stack<Supplier<String>>> contextLocal = new ThreadLocal();

    public static void pushCurrentThreadValidationContext(Supplier<String> supplier) {
        Stack<Supplier<String>> stack = contextLocal.get();
        if (stack == null) {
            stack = new Stack();
            contextLocal.set(stack);
        }
        stack.push(supplier);
    }

    public static void pushCurrentThreadValidationContext(String context) {
        ValidationException.pushCurrentThreadValidationContext(Suppliers.ofInstance(context));
    }

    public static void popCurrentThreadValidationContext() {
        Stack<Supplier<String>> stack = contextLocal.get();
        if (stack != null) {
            stack.pop();
        }
    }

    public ValidationException(String format, Object ... args) {
        super(ValidationException.message(contextLocal.get(), format, args));
    }

    private static String message(Stack<Supplier<String>> context, String format, Object ... args) {
        if (context == null || context.isEmpty()) {
            return String.format(format, args);
        }
        StringBuilder result = new StringBuilder();
        for (Supplier supplier : context) {
            result.append(String.valueOf((String)supplier.get()).concat(": "));
        }
        String string = String.valueOf(result.toString());
        String string2 = String.valueOf(String.format(format, args));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }
}

