/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.JsonParser;
import io.grpc.internal.ProxyDetector;
import io.grpc.internal.ProxyParameters;
import io.grpc.internal.ProxySocketAddress;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.internal.SharedResourceHolder;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class DnsNameResolver
extends NameResolver {
    private static final Logger logger = Logger.getLogger(DnsNameResolver.class.getName());
    private static final String SERVICE_CONFIG_CHOICE_CLIENT_LANGUAGE_KEY = "clientLanguage";
    private static final String SERVICE_CONFIG_CHOICE_PERCENTAGE_KEY = "percentage";
    private static final String SERVICE_CONFIG_CHOICE_CLIENT_HOSTNAME_KEY = "clientHostname";
    private static final String SERVICE_CONFIG_CHOICE_SERVICE_CONFIG_KEY = "serviceConfig";
    static final String SERVICE_CONFIG_PREFIX = "_grpc_config=";
    private static final Set<String> SERVICE_CONFIG_CHOICE_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("clientLanguage", "percentage", "clientHostname", "serviceConfig")));
    private static final String SERVICE_CONFIG_NAME_PREFIX = "_grpc_config.";
    private static final String GRPCLB_NAME_PREFIX = "_grpclb._tcp.";
    private static final String JNDI_PROPERTY = System.getProperty("io.grpc.internal.DnsNameResolverProvider.enable_jndi", "true");
    private static final String JNDI_LOCALHOST_PROPERTY = System.getProperty("io.grpc.internal.DnsNameResolverProvider.enable_jndi_localhost", "false");
    private static final String JNDI_SRV_PROPERTY = System.getProperty("io.grpc.internal.DnsNameResolverProvider.enable_grpclb", "true");
    private static final String JNDI_TXT_PROPERTY = System.getProperty("io.grpc.internal.DnsNameResolverProvider.enable_service_config", "false");
    @VisibleForTesting
    static final String NETWORKADDRESS_CACHE_TTL_PROPERTY = "networkaddress.cache.ttl";
    @VisibleForTesting
    static final long DEFAULT_NETWORK_CACHE_TTL_SECONDS = 30L;
    @VisibleForTesting
    static boolean enableJndi = Boolean.parseBoolean(JNDI_PROPERTY);
    @VisibleForTesting
    static boolean enableJndiLocalhost = Boolean.parseBoolean(JNDI_LOCALHOST_PROPERTY);
    @VisibleForTesting
    static boolean enableSrv = Boolean.parseBoolean(JNDI_SRV_PROPERTY);
    @VisibleForTesting
    static boolean enableTxt = Boolean.parseBoolean(JNDI_TXT_PROPERTY);
    private static final ResourceResolverFactory resourceResolverFactory = DnsNameResolver.getResourceResolverFactory(DnsNameResolver.class.getClassLoader());
    @VisibleForTesting
    final ProxyDetector proxyDetector;
    private static String localHostname;
    private final Random random = new Random();
    private volatile AddressResolver addressResolver = JdkAddressResolver.INSTANCE;
    private final AtomicReference<ResourceResolver> resourceResolver = new AtomicReference();
    private final String authority;
    private final String host;
    private final int port;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private Executor executor;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    private final Runnable resolveRunnable;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DnsNameResolver(@Nullable String nsAuthority, String name, Attributes params, SharedResourceHolder.Resource<Executor> executorResource, ProxyDetector proxyDetector, Stopwatch stopwatch, boolean isAndroid) {
        this.executorResource = executorResource;
        String string = String.valueOf(Preconditions.checkNotNull(name, "name"));
        URI nameUri = URI.create(string.length() != 0 ? "//".concat(string) : new String("//"));
        Preconditions.checkArgument(nameUri.getHost() != null, "Invalid DNS name: %s", (Object)name);
        this.authority = Preconditions.checkNotNull(nameUri.getAuthority(), "nameUri (%s) doesn't have an authority", (Object)nameUri);
        this.host = nameUri.getHost();
        if (nameUri.getPort() == -1) {
            Integer defaultPort = params.get(NameResolver.Factory.PARAMS_DEFAULT_PORT);
            if (defaultPort == null) throw new IllegalArgumentException(new StringBuilder(69 + String.valueOf(name).length()).append("name '").append(name).append("' doesn't contain a port, and default port is not set in params").toString());
            this.port = defaultPort;
        } else {
            this.port = nameUri.getPort();
        }
        this.proxyDetector = proxyDetector;
        this.resolveRunnable = new Resolve(this, stopwatch, DnsNameResolver.getNetworkAddressCacheTtlNanos(isAndroid));
    }

    @Override
    public final String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState(this.listener == null, "already started");
        this.executor = SharedResourceHolder.get(this.executorResource);
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.resolve();
    }

    @Override
    public final synchronized void refresh() {
        Preconditions.checkState(this.listener != null, "not started");
        this.resolve();
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolveRunnable);
    }

    @Override
    public final synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.executor != null) {
            this.executor = SharedResourceHolder.release(this.executorResource, this.executor);
        }
    }

    final int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static ResolutionResults resolveAll(AddressResolver addressResolver, @Nullable ResourceResolver resourceResolver, boolean requestSrvRecords, boolean requestTxtRecords, String name) {
        List<Object> addresses = Collections.emptyList();
        Exception addressesException = null;
        List<EquivalentAddressGroup> balancerAddresses = Collections.emptyList();
        Exception balancerAddressesException = null;
        List<String> txtRecords = Collections.emptyList();
        Exception txtRecordsException = null;
        try {
            addresses = addressResolver.resolveAddress(name);
        }
        catch (Exception e) {
            addressesException = e;
        }
        if (resourceResolver != null) {
            if (requestSrvRecords) {
                try {
                    String string = String.valueOf(GRPCLB_NAME_PREFIX);
                    String string2 = String.valueOf(name);
                    balancerAddresses = resourceResolver.resolveSrv(addressResolver, string2.length() != 0 ? string.concat(string2) : new String(string));
                }
                catch (Exception e) {
                    balancerAddressesException = e;
                }
            }
            if (requestTxtRecords) {
                boolean dontResolveTxt;
                boolean balancerLookupFailedOrNotAttempted = !requestSrvRecords || balancerAddressesException != null;
                boolean bl = dontResolveTxt = addressesException != null && balancerLookupFailedOrNotAttempted;
                if (!dontResolveTxt) {
                    try {
                        String string = String.valueOf(SERVICE_CONFIG_NAME_PREFIX);
                        String string3 = String.valueOf(name);
                        txtRecords = resourceResolver.resolveTxt(string3.length() != 0 ? string.concat(string3) : new String(string));
                    }
                    catch (Exception e) {
                        txtRecordsException = e;
                    }
                }
            }
        }
        try {
            if (addressesException != null && (balancerAddressesException != null || balancerAddresses.isEmpty())) {
                Throwables.throwIfUnchecked(addressesException);
                throw new RuntimeException(addressesException);
            }
        }
        finally {
            if (addressesException != null) {
                logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "resolveAll", "Address resolution failure", addressesException);
            }
            if (balancerAddressesException != null) {
                logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "resolveAll", "Balancer resolution failure", balancerAddressesException);
            }
            if (txtRecordsException != null) {
                logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "resolveAll", "ServiceConfig resolution failure", txtRecordsException);
            }
        }
        return new ResolutionResults(addresses, txtRecords, balancerAddresses);
    }

    @VisibleForTesting
    static List<Map<String, Object>> parseTxtResults(List<String> txtRecords) {
        ArrayList<Map<String, Object>> serviceConfigs = new ArrayList<Map<String, Object>>();
        for (String txtRecord : txtRecords) {
            if (txtRecord.startsWith(SERVICE_CONFIG_PREFIX)) {
                List choices;
                try {
                    Object rawChoices = JsonParser.parse(txtRecord.substring(SERVICE_CONFIG_PREFIX.length()));
                    if (!(rawChoices instanceof List)) {
                        String string = String.valueOf(rawChoices);
                        throw new IOException(new StringBuilder(11 + String.valueOf(string).length()).append("wrong type ").append(string).toString());
                    }
                    List listChoices = (List)rawChoices;
                    for (Object obj : listChoices) {
                        if (obj instanceof Map) continue;
                        String string = String.valueOf(rawChoices);
                        throw new IOException(new StringBuilder(19 + String.valueOf(string).length()).append("wrong element type ").append(string).toString());
                    }
                    choices = listChoices;
                }
                catch (IOException e) {
                    String string = String.valueOf(txtRecord);
                    logger.logp(Level.WARNING, "io.grpc.internal.DnsNameResolver", "parseTxtResults", string.length() != 0 ? "Bad service config: ".concat(string) : new String("Bad service config: "), e);
                    continue;
                }
                serviceConfigs.addAll(choices);
                continue;
            }
            logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "parseTxtResults", "Ignoring non service config {0}", new Object[]{txtRecord});
        }
        return serviceConfigs;
    }

    @Nullable
    private static final Double getPercentageFromChoice(Map<String, Object> serviceConfigChoice) {
        if (!serviceConfigChoice.containsKey(SERVICE_CONFIG_CHOICE_PERCENTAGE_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getDouble(serviceConfigChoice, SERVICE_CONFIG_CHOICE_PERCENTAGE_KEY);
    }

    @Nullable
    private static final List<String> getClientLanguagesFromChoice(Map<String, Object> serviceConfigChoice) {
        if (!serviceConfigChoice.containsKey(SERVICE_CONFIG_CHOICE_CLIENT_LANGUAGE_KEY)) {
            return null;
        }
        return ServiceConfigUtil.checkStringList(ServiceConfigUtil.getList(serviceConfigChoice, SERVICE_CONFIG_CHOICE_CLIENT_LANGUAGE_KEY));
    }

    @Nullable
    private static final List<String> getHostnamesFromChoice(Map<String, Object> serviceConfigChoice) {
        if (!serviceConfigChoice.containsKey(SERVICE_CONFIG_CHOICE_CLIENT_HOSTNAME_KEY)) {
            return null;
        }
        return ServiceConfigUtil.checkStringList(ServiceConfigUtil.getList(serviceConfigChoice, SERVICE_CONFIG_CHOICE_CLIENT_HOSTNAME_KEY));
    }

    private static long getNetworkAddressCacheTtlNanos(boolean isAndroid) {
        if (isAndroid) {
            return 0L;
        }
        String cacheTtlPropertyValue = System.getProperty(NETWORKADDRESS_CACHE_TTL_PROPERTY);
        long cacheTtl = 30L;
        if (cacheTtlPropertyValue != null) {
            try {
                cacheTtl = Long.parseLong(cacheTtlPropertyValue);
            }
            catch (NumberFormatException e) {
                logger.logp(Level.WARNING, "io.grpc.internal.DnsNameResolver", "getNetworkAddressCacheTtlNanos", "Property({0}) valid is not valid number format({1}), fall back to default({2})", new Object[]{NETWORKADDRESS_CACHE_TTL_PROPERTY, cacheTtlPropertyValue, cacheTtl});
            }
        }
        return cacheTtl > 0L ? TimeUnit.SECONDS.toNanos(cacheTtl) : cacheTtl;
    }

    @Nullable
    @VisibleForTesting
    static Map<String, Object> maybeChooseServiceConfig(Map<String, Object> choice, Random random, String hostname) {
        List<String> clientHostnames;
        Double percentage;
        for (Map.Entry<String, Object> entry : choice.entrySet()) {
            Verify.verify(SERVICE_CONFIG_CHOICE_KEYS.contains(entry.getKey()), "Bad key: %s", entry);
        }
        List<String> clientLanguages = DnsNameResolver.getClientLanguagesFromChoice(choice);
        if (clientLanguages != null && !clientLanguages.isEmpty()) {
            boolean javaPresent = false;
            for (String lang : clientLanguages) {
                if (!"java".equalsIgnoreCase(lang)) continue;
                javaPresent = true;
                break;
            }
            if (!javaPresent) {
                return null;
            }
        }
        if ((percentage = DnsNameResolver.getPercentageFromChoice(choice)) != null) {
            int pct = percentage.intValue();
            Verify.verify(pct >= 0 && pct <= 100, "Bad percentage: %s", (Object)percentage);
            if (random.nextInt(100) >= pct) {
                return null;
            }
        }
        if ((clientHostnames = DnsNameResolver.getHostnamesFromChoice(choice)) != null && !clientHostnames.isEmpty()) {
            boolean hostnamePresent = false;
            for (String clientHostname : clientHostnames) {
                if (!clientHostname.equals(hostname)) continue;
                hostnamePresent = true;
                break;
            }
            if (!hostnamePresent) {
                return null;
            }
        }
        return ServiceConfigUtil.getObject(choice, SERVICE_CONFIG_CHOICE_SERVICE_CONFIG_KEY);
    }

    @VisibleForTesting
    void setAddressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    @VisibleForTesting
    void setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver.set(resourceResolver);
    }

    @Nullable
    private ResourceResolver getResourceResolver() {
        ResourceResolver rr = this.resourceResolver.get();
        if (rr == null && resourceResolverFactory != null) {
            assert (resourceResolverFactory.unavailabilityCause() == null);
            rr = resourceResolverFactory.newResourceResolver();
        }
        return rr;
    }

    @Nullable
    @VisibleForTesting
    static ResourceResolverFactory getResourceResolverFactory(ClassLoader loader) {
        ResourceResolverFactory rrf;
        Constructor<ResourceResolverFactory> jndiCtor;
        Class<ResourceResolverFactory> jndiClazz;
        try {
            jndiClazz = Class.forName("io.grpc.internal.JndiResourceResolverFactory", true, loader).asSubclass(ResourceResolverFactory.class);
        }
        catch (ClassNotFoundException e) {
            logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "getResourceResolverFactory", "Unable to find JndiResourceResolverFactory, skipping.", e);
            return null;
        }
        try {
            jndiCtor = jndiClazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "getResourceResolverFactory", "Can't find JndiResourceResolverFactory ctor, skipping.", e);
            return null;
        }
        try {
            rrf = jndiCtor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "getResourceResolverFactory", "Can't construct JndiResourceResolverFactory, skipping.", e);
            return null;
        }
        if (rrf.unavailabilityCause() != null) {
            logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "getResourceResolverFactory", "JndiResourceResolverFactory not available, skipping.", rrf.unavailabilityCause());
        }
        return rrf;
    }

    private static String getLocalHostname() {
        if (localHostname == null) {
            try {
                localHostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localHostname;
    }

    @VisibleForTesting
    static boolean shouldUseJndi(boolean jndiEnabled, boolean jndiLocalhostEnabled, String target) {
        if (!jndiEnabled) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(target)) {
            return jndiLocalhostEnabled;
        }
        if (target.contains(":")) {
            return false;
        }
        boolean alldigits = true;
        for (int i = 0; i < target.length(); ++i) {
            char c = target.charAt(i);
            if (c == '.') continue;
            alldigits &= c >= '0' && c <= '9';
        }
        return !alldigits;
    }

    static interface ResourceResolver {
        public List<String> resolveTxt(String var1) throws Exception;

        public List<EquivalentAddressGroup> resolveSrv(AddressResolver var1, String var2) throws Exception;
    }

    private static enum JdkAddressResolver implements AddressResolver
    {
        INSTANCE;


        @Override
        public List<InetAddress> resolveAddress(String host) throws UnknownHostException {
            return Collections.unmodifiableList(Arrays.asList(InetAddress.getAllByName(host)));
        }
    }

    static interface AddressResolver {
        public List<InetAddress> resolveAddress(String var1) throws Exception;
    }

    static interface ResourceResolverFactory {
        @Nullable
        public ResourceResolver newResourceResolver();

        @Nullable
        public Throwable unavailabilityCause();
    }

    @VisibleForTesting
    static final class ResolutionResults {
        final List<? extends InetAddress> addresses;
        final List<String> txtRecords;
        final List<EquivalentAddressGroup> balancerAddresses;

        ResolutionResults(List<? extends InetAddress> addresses, List<String> txtRecords, List<EquivalentAddressGroup> balancerAddresses) {
            this.addresses = Collections.unmodifiableList(Preconditions.checkNotNull(addresses, "addresses"));
            this.txtRecords = Collections.unmodifiableList(Preconditions.checkNotNull(txtRecords, "txtRecords"));
            this.balancerAddresses = Collections.unmodifiableList(Preconditions.checkNotNull(balancerAddresses, "balancerAddresses"));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("addresses", this.addresses).add("txtRecords", this.txtRecords).add("balancerAddresses", this.balancerAddresses).toString();
        }
    }

    @VisibleForTesting
    static final class Resolve
    implements Runnable {
        private final DnsNameResolver resolver;
        private final Stopwatch stopwatch;
        private final long cacheTtlNanos;
        private ResolutionResults cachedResolutionResults = null;

        Resolve(DnsNameResolver resolver, Stopwatch stopwatch, long cacheTtlNanos) {
            this.resolver = resolver;
            this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
            this.cacheTtlNanos = cacheTtlNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameResolver.Listener savedListener;
            if (logger.isLoggable(Level.FINER)) {
                String string = String.valueOf(this.resolver.host);
                logger.logp(Level.FINER, "io.grpc.internal.DnsNameResolver$Resolve", "run", string.length() != 0 ? "Attempting DNS resolution of ".concat(string) : new String("Attempting DNS resolution of "));
            }
            DnsNameResolver dnsNameResolver = this.resolver;
            synchronized (dnsNameResolver) {
                if (this.resolver.shutdown || !this.cacheRefreshRequired()) {
                    return;
                }
                savedListener = this.resolver.listener;
                this.resolver.resolving = true;
            }
            try {
                this.resolveInternal(savedListener);
            }
            finally {
                dnsNameResolver = this.resolver;
                synchronized (dnsNameResolver) {
                    this.resolver.resolving = false;
                }
            }
        }

        private boolean cacheRefreshRequired() {
            return this.cachedResolutionResults == null || this.cacheTtlNanos == 0L || this.cacheTtlNanos > 0L && this.stopwatch.elapsed(TimeUnit.NANOSECONDS) > this.cacheTtlNanos;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        void resolveInternal(NameResolver.Listener savedListener) {
            ResolutionResults resolutionResults;
            ProxyParameters proxy;
            InetSocketAddress destination = InetSocketAddress.createUnresolved(this.resolver.host, this.resolver.port);
            try {
                proxy = this.resolver.proxyDetector.proxyFor(destination);
            }
            catch (IOException e) {
                String string = String.valueOf(this.resolver.host);
                savedListener.onError(Status.UNAVAILABLE.withDescription(string.length() != 0 ? "Unable to resolve host ".concat(string) : new String("Unable to resolve host ")).withCause(e));
                return;
            }
            if (proxy != null) {
                if (logger.isLoggable(Level.FINER)) {
                    String e = String.valueOf(proxy.proxyAddress);
                    String string = this.resolver.host;
                    logger.logp(Level.FINER, "io.grpc.internal.DnsNameResolver$Resolve", "resolveInternal", new StringBuilder(17 + String.valueOf(e).length() + String.valueOf(string).length()).append("Using proxy ").append(e).append(" for ").append(string).toString());
                }
                EquivalentAddressGroup server = new EquivalentAddressGroup(new ProxySocketAddress(destination, proxy));
                savedListener.onAddresses(Collections.singletonList(server), Attributes.EMPTY);
                return;
            }
            try {
                ResourceResolver resourceResolver = null;
                if (DnsNameResolver.shouldUseJndi(enableJndi, enableJndiLocalhost, this.resolver.host)) {
                    resourceResolver = this.resolver.getResourceResolver();
                }
                this.cachedResolutionResults = resolutionResults = DnsNameResolver.resolveAll(this.resolver.addressResolver, resourceResolver, enableSrv, enableTxt, this.resolver.host);
                if (this.cacheTtlNanos > 0L) {
                    this.stopwatch.reset().start();
                }
                if (logger.isLoggable(Level.FINER)) {
                    String string = String.valueOf(resolutionResults);
                    String string2 = this.resolver.host;
                    logger.logp(Level.FINER, "io.grpc.internal.DnsNameResolver$Resolve", "resolveInternal", new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Found DNS results ").append(string).append(" for ").append(string2).toString());
                }
            }
            catch (Exception e) {
                String string = String.valueOf(this.resolver.host);
                savedListener.onError(Status.UNAVAILABLE.withDescription(string.length() != 0 ? "Unable to resolve host ".concat(string) : new String("Unable to resolve host ")).withCause(e));
                return;
            }
            ArrayList<EquivalentAddressGroup> servers = new ArrayList<EquivalentAddressGroup>();
            for (InetAddress inetAddress : resolutionResults.addresses) {
                servers.add(new EquivalentAddressGroup(new InetSocketAddress(inetAddress, this.resolver.port)));
            }
            servers.addAll(resolutionResults.balancerAddresses);
            if (servers.isEmpty()) {
                String string = String.valueOf(this.resolver.host);
                savedListener.onError(Status.UNAVAILABLE.withDescription(string.length() != 0 ? "No DNS backend or balancer addresses found for ".concat(string) : new String("No DNS backend or balancer addresses found for ")));
                return;
            }
            Attributes.Builder attrs = Attributes.newBuilder();
            if (!resolutionResults.txtRecords.isEmpty()) {
                void var7_15;
                Object var7_14 = null;
                try {
                    for (Map<String, Object> possibleConfig : DnsNameResolver.parseTxtResults(resolutionResults.txtRecords)) {
                        try {
                            Map<String, Object> map = DnsNameResolver.maybeChooseServiceConfig(possibleConfig, this.resolver.random, DnsNameResolver.getLocalHostname());
                        }
                        catch (RuntimeException e) {
                            String string = String.valueOf(possibleConfig);
                            logger.logp(Level.WARNING, "io.grpc.internal.DnsNameResolver$Resolve", "resolveInternal", new StringBuilder(26 + String.valueOf(string).length()).append("Bad service config choice ").append(string).toString(), e);
                        }
                        if (var7_15 == null) continue;
                        break;
                    }
                }
                catch (RuntimeException e) {
                    logger.logp(Level.WARNING, "io.grpc.internal.DnsNameResolver$Resolve", "resolveInternal", "Can't parse service Configs", e);
                }
                if (var7_15 != null) {
                    attrs.set(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG, var7_15);
                }
            } else {
                logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver$Resolve", "resolveInternal", "No TXT records found for {0}", new Object[]{this.resolver.host});
            }
            savedListener.onAddresses(servers, attrs.build());
        }
    }
}

