/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.MoreThrowables;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogExceptionRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(LogExceptionRunnable.class.getName());
    private final Runnable task;

    public LogExceptionRunnable(Runnable task) {
        this.task = Preconditions.checkNotNull(task, "task");
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        catch (Throwable t) {
            String string = String.valueOf(this.task);
            log.logp(Level.SEVERE, "io.grpc.internal.LogExceptionRunnable", "run", new StringBuilder(35 + String.valueOf(string).length()).append("Exception while executing runnable ").append(string).toString(), t);
            MoreThrowables.throwIfUnchecked(t);
            throw new AssertionError((Object)t);
        }
    }

    public String toString() {
        String string = String.valueOf(this.task);
        return new StringBuilder(22 + String.valueOf(string).length()).append("LogExceptionRunnable(").append(string).append(")").toString();
    }
}

