/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.okhttp.OkHttpClientTransport;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.FrameWriter;
import io.grpc.okhttp.internal.framed.Header;
import io.grpc.okhttp.internal.framed.Settings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;

final class ExceptionHandlingFrameWriter
implements FrameWriter {
    private static final Logger log = Logger.getLogger(OkHttpClientTransport.class.getName());
    private static final Set<String> QUIET_ERRORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Socket closed")));
    private final TransportExceptionHandler transportExceptionHandler;
    private final FrameWriter frameWriter;

    ExceptionHandlingFrameWriter(TransportExceptionHandler transportExceptionHandler, FrameWriter frameWriter) {
        this.transportExceptionHandler = Preconditions.checkNotNull(transportExceptionHandler, "transportExceptionHandler");
        this.frameWriter = Preconditions.checkNotNull(frameWriter, "frameWriter");
    }

    @Override
    public void connectionPreface() {
        try {
            this.frameWriter.connectionPreface();
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void ackSettings(Settings peerSettings) {
        try {
            this.frameWriter.ackSettings(peerSettings);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
        try {
            this.frameWriter.pushPromise(streamId, promisedStreamId, requestHeaders);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.frameWriter.flush();
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void synStream(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock) {
        try {
            this.frameWriter.synStream(outFinished, inFinished, streamId, associatedStreamId, headerBlock);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void synReply(boolean outFinished, int streamId, List<Header> headerBlock) {
        try {
            this.frameWriter.synReply(outFinished, streamId, headerBlock);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void headers(int streamId, List<Header> headerBlock) {
        try {
            this.frameWriter.headers(streamId, headerBlock);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void rstStream(int streamId, ErrorCode errorCode) {
        try {
            this.frameWriter.rstStream(streamId, errorCode);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public int maxDataLength() {
        return this.frameWriter.maxDataLength();
    }

    @Override
    public void data(boolean outFinished, int streamId, Buffer source, int byteCount) {
        try {
            this.frameWriter.data(outFinished, streamId, source, byteCount);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void settings(Settings okHttpSettings) {
        try {
            this.frameWriter.settings(okHttpSettings);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void ping(boolean ack, int payload1, int payload2) {
        try {
            this.frameWriter.ping(ack, payload1, payload2);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void goAway(int lastGoodStreamId, ErrorCode errorCode, byte[] debugData) {
        try {
            this.frameWriter.goAway(lastGoodStreamId, errorCode, debugData);
            this.frameWriter.flush();
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void windowUpdate(int streamId, long windowSizeIncrement) {
        try {
            this.frameWriter.windowUpdate(streamId, windowSizeIncrement);
        }
        catch (IOException e) {
            this.transportExceptionHandler.onException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.frameWriter.close();
        }
        catch (IOException e) {
            log.logp(ExceptionHandlingFrameWriter.getLogLevel(e), "io.grpc.okhttp.ExceptionHandlingFrameWriter", "close", "Failed closing connection", e);
        }
    }

    @VisibleForTesting
    static Level getLogLevel(Throwable t) {
        if (t instanceof IOException && t.getMessage() != null && QUIET_ERRORS.contains(t.getMessage())) {
            return Level.FINE;
        }
        return Level.INFO;
    }

    static interface TransportExceptionHandler {
        public void onException(Throwable var1);
    }
}

