/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import io.grpc.internal.AbstractReadableBuffer;
import io.grpc.internal.ReadableBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import okio.Buffer;

class OkHttpReadableBuffer
extends AbstractReadableBuffer {
    private final Buffer buffer;

    OkHttpReadableBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int readableBytes() {
        return (int)this.buffer.size();
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public void skipBytes(int length) {
        try {
            this.buffer.skip((long)length);
        }
        catch (EOFException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void readBytes(byte[] dest, int destOffset, int length) {
        while (length > 0) {
            int bytesRead = this.buffer.read(dest, destOffset, length);
            if (bytesRead == -1) {
                int n = length;
                throw new IndexOutOfBoundsException(new StringBuilder(36).append("EOF trying to read ").append(n).append(" bytes").toString());
            }
            length -= bytesRead;
            destOffset += bytesRead;
        }
    }

    @Override
    public void readBytes(ByteBuffer dest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readBytes(OutputStream dest, int length) throws IOException {
        this.buffer.writeTo(dest, (long)length);
    }

    @Override
    public ReadableBuffer readBytes(int length) {
        Buffer buf = new Buffer();
        buf.write(this.buffer, (long)length);
        return new OkHttpReadableBuffer(buf);
    }

    @Override
    public void close() {
        this.buffer.clear();
    }
}

