/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp.internal;

public enum TlsVersion {
    TLS_1_2("TLSv1.2"),
    TLS_1_1("TLSv1.1"),
    TLS_1_0("TLSv1"),
    SSL_3_0("SSLv3");

    final String javaName;

    private TlsVersion(String javaName) {
        this.javaName = javaName;
    }

    public static TlsVersion forJavaName(String javaName) {
        if ("TLSv1.2".equals(javaName)) {
            return TLS_1_2;
        }
        if ("TLSv1.1".equals(javaName)) {
            return TLS_1_1;
        }
        if ("TLSv1".equals(javaName)) {
            return TLS_1_0;
        }
        if ("SSLv3".equals(javaName)) {
            return SSL_3_0;
        }
        String string = String.valueOf(javaName);
        throw new IllegalArgumentException(string.length() != 0 ? "Unexpected TLS version: ".concat(string) : new String("Unexpected TLS version: "));
    }

    public String javaName() {
        return this.javaName;
    }
}

