/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.stats;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import io.opencensus.contrib.grpc.metrics.RpcViewConstants;
import io.opencensus.stats.Measure;
import io.opencensus.stats.View;
import java.util.Collection;
import java.util.Set;

public final class GoogleRpcConstants {
    public static final Measure.MeasureLong RPC_CLIENT_APP_ERROR = Measure.MeasureLong.create("/rpc/client/app_error", "Application Errors", "1");
    public static final Measure.MeasureLong RPC_SERVER_APP_ERROR = Measure.MeasureLong.create("/rpc/server/app_error", "Application Errors", "1");
    private static final ImmutableSet<View> RPC_VIEW_SET_OLD = ImmutableSet.of(RpcViewConstants.RPC_CLIENT_ERROR_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_ERROR_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_ERROR_COUNT_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_VIEW, new View[]{RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_VIEW, RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_VIEW, RpcViewConstants.RPC_CLIENT_STARTED_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_STARTED_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_FINISHED_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_FINISHED_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_VIEW, RpcViewConstants.RPC_CLIENT_SERVER_ELAPSED_TIME_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_SERVER_ELAPSED_TIME_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_SERVER_ELAPSED_TIME_VIEW, RpcViewConstants.RPC_SERVER_ERROR_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_ERROR_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_ERROR_COUNT_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_COUNT_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_VIEW, RpcViewConstants.RPC_SERVER_SERVER_LATENCY_HOUR_VIEW, RpcViewConstants.RPC_SERVER_SERVER_LATENCY_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_SERVER_LATENCY_VIEW, RpcViewConstants.RPC_SERVER_STARTED_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_STARTED_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_FINISHED_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_FINISHED_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_BYTES_HOUR_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_BYTES_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_HOUR_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_HOUR_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_HOUR_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_VIEW, RpcViewConstants.RPC_SERVER_SERVER_ELAPSED_TIME_HOUR_VIEW, RpcViewConstants.RPC_SERVER_SERVER_ELAPSED_TIME_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_SERVER_ELAPSED_TIME_VIEW});
    private static final ImmutableSet<View> RPC_VIEW_SET_NEW = ImmutableSet.of(RpcViewConstants.GRPC_CLIENT_ROUNDTRIP_LATENCY_VIEW, RpcViewConstants.GRPC_CLIENT_SENT_BYTES_PER_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_RECEIVED_BYTES_PER_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_SENT_MESSAGES_PER_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_RECEIVED_MESSAGES_PER_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_SERVER_LATENCY_VIEW, new View[]{RpcViewConstants.GRPC_CLIENT_COMPLETED_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_STARTED_RPC_VIEW, RpcViewConstants.GRPC_SERVER_SERVER_LATENCY_VIEW, RpcViewConstants.GRPC_SERVER_SENT_BYTES_PER_RPC_VIEW, RpcViewConstants.GRPC_SERVER_RECEIVED_BYTES_PER_RPC_VIEW, RpcViewConstants.GRPC_SERVER_SENT_MESSAGES_PER_RPC_VIEW, RpcViewConstants.GRPC_SERVER_RECEIVED_MESSAGES_PER_RPC_VIEW, RpcViewConstants.GRPC_SERVER_COMPLETED_RPC_VIEW, RpcViewConstants.GRPC_SERVER_STARTED_RPC_VIEW});
    static final ImmutableSet<Measure> RPC_MEASURE_SET_NEW = ImmutableSet.of(RpcMeasureConstants.GRPC_CLIENT_ROUNDTRIP_LATENCY, RpcMeasureConstants.GRPC_CLIENT_SENT_BYTES_PER_RPC, RpcMeasureConstants.GRPC_CLIENT_RECEIVED_BYTES_PER_RPC, RpcMeasureConstants.GRPC_CLIENT_SENT_MESSAGES_PER_RPC, RpcMeasureConstants.GRPC_CLIENT_RECEIVED_MESSAGES_PER_RPC, RpcMeasureConstants.GRPC_CLIENT_SERVER_LATENCY, new Measure[]{RpcMeasureConstants.GRPC_CLIENT_STARTED_RPCS, RpcMeasureConstants.GRPC_SERVER_SERVER_LATENCY, RpcMeasureConstants.GRPC_SERVER_SENT_BYTES_PER_RPC, RpcMeasureConstants.GRPC_SERVER_RECEIVED_BYTES_PER_RPC, RpcMeasureConstants.GRPC_SERVER_SENT_MESSAGES_PER_RPC, RpcMeasureConstants.GRPC_SERVER_RECEIVED_MESSAGES_PER_RPC, RpcMeasureConstants.GRPC_SERVER_STARTED_RPCS});
    private static final ImmutableMap<View.Name, View> RPC_VIEW_MAP_OLD = GoogleRpcConstants.createViewMap(RPC_VIEW_SET_OLD);
    private static final ImmutableSet<View> EXPORTED_VIEW_SET_OLD = GoogleRpcConstants.createExportedViewSet(RPC_VIEW_SET_OLD);
    static final ImmutableMap<View.Name, View> RPC_VIEW_MAP_NEW = GoogleRpcConstants.createViewMap(RPC_VIEW_SET_NEW);

    private static ImmutableMap<View.Name, View> createViewMap(Collection<View> views) {
        ImmutableMap.Builder<View.Name, View> builder = ImmutableMap.builder();
        for (View view : views) {
            builder.put(view.getName(), view);
        }
        return builder.build();
    }

    private static ImmutableSet<View> createExportedViewSet(Collection<View> allViews) {
        ImmutableSet.Builder views = ImmutableSet.builder();
        for (View view : allViews) {
            if (!(view.getWindow() instanceof View.AggregationWindow.Cumulative)) continue;
            views.add(view);
        }
        return views.build();
    }

    static View getRpcView(View.Name viewName) {
        return RPC_VIEW_MAP_OLD.get(viewName);
    }

    static Set<View> getAllExportedViews() {
        return EXPORTED_VIEW_SET_OLD;
    }

    private GoogleRpcConstants() {
    }
}

