/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.stats;

import com.google.common.base.Preconditions;
import com.google.monitoring.census.Census;
import com.google.monitoring.census.CensusProto;
import com.google.monitoring.census.RpcUtil;
import com.google.monitoring.census.TagSet;
import com.google.monitoring.census.TagSetReplacer;
import io.opencensus.impl.stats.GoogleRpcConstants;
import io.opencensus.impl.stats.MeasureMapInternal;
import io.opencensus.impl.stats.MeasureUtil;
import io.opencensus.impl.tags.TagContextImpl;
import io.opencensus.stats.Measure;
import io.opencensus.stats.MeasureMap;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.unsafe.ContextUtils;
import java.util.Iterator;
import java.util.Map;

public final class MeasureMapImpl
extends MeasureMap {
    private final MeasureMapInternal.Builder builder = MeasureMapInternal.builder();

    static MeasureMapImpl create() {
        return new MeasureMapImpl();
    }

    private MeasureMapImpl() {
    }

    @Override
    public MeasureMapImpl put(Measure.MeasureDouble measure, double value) {
        if (GoogleRpcConstants.RPC_MEASURE_SET_NEW.contains(measure)) {
            return this;
        }
        this.builder.put(measure, value);
        return this;
    }

    @Override
    public MeasureMapImpl put(Measure.MeasureLong measure, long value) {
        if (GoogleRpcConstants.RPC_MEASURE_SET_NEW.contains(measure)) {
            return this;
        }
        this.builder.put(measure, value);
        return this;
    }

    @Override
    public void record() {
        this.record(ContextUtils.TAG_CONTEXT_KEY.get());
    }

    @Override
    public void record(TagContext tagContext) {
        Preconditions.checkNotNull(tagContext, "tagContext");
        TagSet tagSet = tagContext instanceof TagContextImpl ? ((TagContextImpl)tagContext).getTags() : MeasureMapImpl.getTagSetFromUnknownTagContext(tagContext);
        Census.StatsRecorder recorder = new Census.StatsRecorder(tagSet);
        Map<CensusProto.ResourceId, double[]> resourceIdMap = MeasureUtil.getResourceIdMap(this.builder.build());
        for (Map.Entry<CensusProto.ResourceId, double[]> entry : resourceIdMap.entrySet()) {
            recorder.record(entry.getKey(), entry.getValue());
        }
    }

    private static TagSet getTagSetFromUnknownTagContext(TagContext tagContext) {
        Iterator<Tag> iterator = InternalUtils.getTags(tagContext);
        if (!iterator.hasNext()) {
            return TagSet.getDefault();
        }
        TagSetReplacer replacer = new TagSetReplacer();
        while (iterator.hasNext()) {
            Tag tag = iterator.next();
            replacer.set(tag.getKey().getName(), tag.getValue().asString());
        }
        return RpcUtil.buildWith((TagSetReplacer)replacer, (TagSet)TagSet.getDefault());
    }
}

