/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.stats;

import io.opencensus.stats.Measure;
import io.opencensus.stats.Measurement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class MeasureMapInternal {
    private final ArrayList<Measurement> measurements;

    static Builder builder() {
        return new Builder();
    }

    Iterator<Measurement> iterator() {
        return new MeasureMapInternalIterator();
    }

    private MeasureMapInternal(ArrayList<Measurement> measurements) {
        this.measurements = measurements;
    }

    private final class MeasureMapInternalIterator
    implements Iterator<Measurement> {
        private final int length;
        private int position;

        private MeasureMapInternalIterator() {
            this.length = MeasureMapInternal.this.measurements.size();
            this.position = 0;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.length;
        }

        @Override
        public Measurement next() {
            if (this.position >= MeasureMapInternal.this.measurements.size()) {
                throw new NoSuchElementException();
            }
            return (Measurement)MeasureMapInternal.this.measurements.get(this.position++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Builder {
        private final ArrayList<Measurement> measurements = new ArrayList();

        Builder put(Measure.MeasureDouble measure, double value) {
            this.measurements.add(Measurement.MeasurementDouble.create(measure, value));
            return this;
        }

        Builder put(Measure.MeasureLong measure, long value) {
            this.measurements.add(Measurement.MeasurementLong.create(measure, value));
            return this;
        }

        MeasureMapInternal build() {
            for (int i = this.measurements.size() - 1; i >= 0; --i) {
                for (int j = i - 1; j >= 0; --j) {
                    if (this.measurements.get(i).getMeasure() != this.measurements.get(j).getMeasure()) continue;
                    this.measurements.remove(j);
                    --j;
                }
            }
            return new MeasureMapInternal(this.measurements);
        }

        private Builder() {
        }
    }
}

