/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.stats;

import com.google.common.base.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import com.google.monitoring.census.CensusProto;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import io.opencensus.impl.stats.GoogleRpcConstants;
import io.opencensus.impl.stats.MeasureMapInternal;
import io.opencensus.stats.Measure;
import io.opencensus.stats.Measurement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class MeasureUtil {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("io/opencensus/impl/stats/MeasureUtil");
    private static final ImmutableSet<Pair<CensusProto.ResourceId, Integer>> SCALED_MEASURES = ImmutableSet.of(Pair.of(CensusProto.ResourceId.RPC_CLIENT, 7), Pair.of(CensusProto.ResourceId.RPC_SERVER, 7));
    private static final ImmutableMap<Measure, MeasureLocationInfo> MEASURE_MAP;

    static Map<CensusProto.ResourceId, double[]> getResourceIdMap(MeasureMapInternal mvs) {
        HashMap<CensusProto.ResourceId, double[]> map = new HashMap<CensusProto.ResourceId, double[]>();
        Iterator<Measurement> iterator = mvs.iterator();
        while (iterator.hasNext()) {
            Measurement measurement = iterator.next();
            Measure measure = measurement.getMeasure();
            if (measure.equals(RpcMeasureConstants.RPC_CLIENT_FINISHED_COUNT)) continue;
            MeasureLocationInfo info = MeasureUtil.getMeasureMap().get(measure);
            if (info == null) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).atMostEvery(5, TimeUnit.MINUTES)).withInjectedLogSite("io/opencensus/impl/stats/MeasureUtil", "getResourceIdMap", 59, "MeasureUtil.java")).log("No location info for measurement %s", measure.getName());
                continue;
            }
            double[] quantities = (double[])map.get(info.id);
            if (quantities == null) {
                quantities = new double[info.numParams];
                map.put(info.id, quantities);
            }
            quantities[info.index] = measurement.match(new Function<Measurement.MeasurementDouble, Double>(){

                @Override
                public Double apply(Measurement.MeasurementDouble arg) {
                    return arg.getValue();
                }
            }, new Function<Measurement.MeasurementLong, Double>(){

                @Override
                public Double apply(Measurement.MeasurementLong arg) {
                    return arg.getValue();
                }
            }, Functions.throwAssertionError());
        }
        return map;
    }

    static final ImmutableMap<Measure, MeasureLocationInfo> getMeasureMap() {
        return MEASURE_MAP;
    }

    private MeasureUtil() {
    }

    static {
        ImmutableMap.Builder<Measure, MeasureLocationInfo> builder = ImmutableMap.builder();
        for (ResourceMap resource : ResourceMap.values()) {
            int length = resource.measures.size();
            for (int i = 0; i < length; ++i) {
                builder.put((Measure)resource.measures.get(i), new MeasureLocationInfo(resource.id, i, length));
            }
        }
        MEASURE_MAP = builder.build();
    }

    private static enum ResourceMap {
        RPC_CLIENT(CensusProto.ResourceId.RPC_CLIENT, RpcMeasureConstants.RPC_CLIENT_ROUNDTRIP_LATENCY, RpcMeasureConstants.RPC_CLIENT_REQUEST_BYTES, RpcMeasureConstants.RPC_CLIENT_RESPONSE_BYTES, RpcMeasureConstants.RPC_CLIENT_ERROR_COUNT, GoogleRpcConstants.RPC_CLIENT_APP_ERROR, RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES, RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES, RpcMeasureConstants.RPC_CLIENT_SERVER_ELAPSED_TIME),
        RPC_SERVER(CensusProto.ResourceId.RPC_SERVER, RpcMeasureConstants.RPC_SERVER_SERVER_LATENCY, RpcMeasureConstants.RPC_SERVER_REQUEST_BYTES, RpcMeasureConstants.RPC_SERVER_RESPONSE_BYTES, RpcMeasureConstants.RPC_SERVER_ERROR_COUNT, GoogleRpcConstants.RPC_SERVER_APP_ERROR, RpcMeasureConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES, RpcMeasureConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES, RpcMeasureConstants.RPC_SERVER_SERVER_ELAPSED_TIME),
        GRPC_SERVER_START(CensusProto.ResourceId.GRPC_SERVER_START, RpcMeasureConstants.RPC_SERVER_STARTED_COUNT),
        GRPC_END(CensusProto.ResourceId.GRPC_END, RpcMeasureConstants.RPC_SERVER_FINISHED_COUNT),
        GRPC_SERVER_MESSAGE_COUNT(CensusProto.ResourceId.GRPC_SERVER_MESSAGE_COUNT, RpcMeasureConstants.RPC_SERVER_REQUEST_COUNT, RpcMeasureConstants.RPC_SERVER_RESPONSE_COUNT),
        GRPC_CLIENT_START(CensusProto.ResourceId.GRPC_CLIENT_START, RpcMeasureConstants.RPC_CLIENT_STARTED_COUNT),
        GRPC_CLIENT_MESSAGE_COUNT(CensusProto.ResourceId.GRPC_CLIENT_MESSAGE_COUNT, RpcMeasureConstants.RPC_CLIENT_REQUEST_COUNT, RpcMeasureConstants.RPC_CLIENT_RESPONSE_COUNT),
        GRPC_CLIENT_MESSAGE_SENT_STATS(CensusProto.ResourceId.GRPC_CLIENT_MESSAGE_SENT_STATS, RpcMeasureConstants.GRPC_CLIENT_SENT_MESSAGES_PER_METHOD, RpcMeasureConstants.GRPC_CLIENT_SENT_BYTES_PER_METHOD),
        GRPC_CLIENT_MESSAGE_RECEIVED_STATS(CensusProto.ResourceId.GRPC_CLIENT_MESSAGE_RECEIVED_STATS, RpcMeasureConstants.GRPC_CLIENT_RECEIVED_MESSAGES_PER_METHOD, RpcMeasureConstants.GRPC_CLIENT_RECEIVED_BYTES_PER_METHOD),
        GRPC_SERVER_MESSAGE_SENT_STATS(CensusProto.ResourceId.GRPC_SERVER_MESSAGE_SENT_STATS, RpcMeasureConstants.GRPC_SERVER_SENT_MESSAGES_PER_METHOD, RpcMeasureConstants.GRPC_SERVER_SENT_BYTES_PER_METHOD),
        GRPC_SERVER_MESSAGE_RECEIVED_STATS(CensusProto.ResourceId.GRPC_SERVER_MESSAGE_RECEIVED_STATS, RpcMeasureConstants.GRPC_SERVER_RECEIVED_MESSAGES_PER_METHOD, RpcMeasureConstants.GRPC_SERVER_RECEIVED_BYTES_PER_METHOD);

        final CensusProto.ResourceId id;
        final ImmutableList<Measure> measures;

        private ResourceMap(CensusProto.ResourceId id, Measure ... measures) {
            this.id = id;
            this.measures = ImmutableList.copyOf(measures);
        }
    }

    static final class MeasureLocationInfo {
        final CensusProto.ResourceId id;
        final int index;
        final int numParams;
        final boolean scale;

        MeasureLocationInfo(CensusProto.ResourceId id, int index, int numParams) {
            this.id = id;
            this.index = index;
            this.numParams = numParams;
            this.scale = SCALED_MEASURES.contains(Pair.of(id, index));
        }
    }
}

