/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import com.google.monitoring.census.Aggregator;
import com.google.monitoring.census.CensusProto;
import com.google.monitoring.census.RpcUtil;
import com.google.monitoring.streamz.proto.DistributionProto;
import com.google.protobuf.util.Timestamps;
import io.opencensus.common.Duration;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.impl.stats.GoogleRpcConstants;
import io.opencensus.impl.stats.MeasureUtil;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.Measure;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class ViewManagerImpl
extends ViewManager {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("io/opencensus/impl/stats/ViewManagerImpl");
    private static final String INTERNAL_TAG_VALUE_DELIMITER = "\u0004";
    private static final Joiner tagJoiner = Joiner.on('-');
    @VisibleForTesting
    static final Duration MINUTE = Duration.create(60L, 0);
    @VisibleForTesting
    static final Duration HOUR = Duration.create(3600L, 0);

    @Override
    public void registerView(View view) {
        throw new UnsupportedOperationException("Views in google3 are registered by the underlying Census library.");
    }

    @Override
    @Nullable
    public ViewData getView(View.Name viewName) {
        if (GoogleRpcConstants.RPC_VIEW_MAP_NEW.containsKey(viewName)) {
            String string = String.valueOf(viewName);
            throw new IllegalArgumentException(new StringBuilder(74 + String.valueOf(string).length()).append("New RPC view: ").append(string).append(" is not yet supported. For now please use the old RPC views.").toString());
        }
        View view = GoogleRpcConstants.getRpcView(viewName);
        if (view == null) {
            String string = String.valueOf(viewName);
            throw new IllegalArgumentException(new StringBuilder(66 + String.valueOf(string).length()).append("Unknown view: ").append(string).append(". Only canonical RPC views in google3 are supported.").toString());
        }
        return this.getView(view);
    }

    @Override
    public Set<View> getAllExportedViews() {
        return GoogleRpcConstants.getAllExportedViews();
    }

    private ViewData getView(final View view) {
        final String keys = ViewManagerImpl.joinTagKeys(view.getColumns());
        Measure measure = view.getMeasure();
        final MeasureUtil.MeasureLocationInfo info = MeasureUtil.getMeasureMap().get(measure);
        Preconditions.checkArgument(info != null, "Unknown measure:%s", (Object)measure.getName());
        return view.getWindow().match(Functions.returnConstant(ViewManagerImpl.getViewDataFromProto(RpcUtil.getStats((CensusProto.ResourceId)info.id, (int)info.index, (String)keys, (boolean)info.scale), view)), new Function<View.AggregationWindow.Interval, ViewData>(this){

            @Override
            public ViewData apply(View.AggregationWindow.Interval arg) {
                return ViewManagerImpl.getViewDataFromProto(RpcUtil.getIntervalStats((CensusProto.ResourceId)info.id, (int)info.index, (String)keys, (RpcUtil.Interval)ViewManagerImpl.getDurationInterval(arg.getDuration())), view);
            }
        }, Functions.throwAssertionError());
    }

    private static String joinTagKeys(List<TagKey> tagKeys) {
        ArrayList<String> stringKeys = Lists.newArrayList();
        for (TagKey tagKey : tagKeys) {
            stringKeys.add(tagKey.getName());
        }
        return tagJoiner.join(stringKeys);
    }

    private static ViewData getViewDataFromProto(Aggregator.AggregatedDataMapProto stats, View view) {
        com.google.protobuf.Timestamp start;
        HashMap<List<TagValue>, AggregationData> aggregationMap = Maps.newHashMap();
        com.google.protobuf.Timestamp end = start = stats.getGetStatsTimestamp();
        for (Aggregator.AggregatedDataMapProto.TableRow row : stats.getEntriesList()) {
            AggregationData data;
            com.google.protobuf.Timestamp reset = row.getResetTimestamp();
            if (Timestamps.compare(start, reset) > 0) {
                start = reset;
            }
            if ((data = ViewManagerImpl.getAggregationData(view.getAggregation(), view.getMeasure(), row)) == null) continue;
            aggregationMap.put(ViewManagerImpl.getTagValues(row.getViewTags(), view.getColumns()), data);
        }
        ViewData.AggregationWindowData windowData = view.getWindow().match(Functions.returnConstant(ViewData.AggregationWindowData.CumulativeData.create(ViewManagerImpl.convertTimestamp(start), ViewManagerImpl.convertTimestamp(end))), Functions.returnConstant(ViewData.AggregationWindowData.IntervalData.create(ViewManagerImpl.convertTimestamp(end))), Functions.throwAssertionError());
        return ViewData.create(view, aggregationMap, windowData);
    }

    @Nullable
    private static AggregationData getAggregationData(Aggregation aggregation, final Measure measure, Aggregator.AggregatedDataMapProto.TableRow row) {
        double mean;
        long count;
        final double sum = row.getData();
        final DistributionProto distribution = row.getDistribution();
        if (distribution.equals((Object)DistributionProto.getDefaultInstance())) {
            count = (long)sum;
            if (count == 0L) {
                return null;
            }
            mean = 1.0;
        } else {
            count = distribution.getCount();
            mean = distribution.getMean();
        }
        return aggregation.match(new Function<Aggregation.Sum, AggregationData>(){

            @Override
            public AggregationData apply(Aggregation.Sum arg) {
                return measure.match(Functions.returnConstant(AggregationData.SumDataDouble.create(sum)), Functions.returnConstant(AggregationData.SumDataLong.create(Math.round(sum))), Functions.throwAssertionError());
            }
        }, new Function<Aggregation.Count, AggregationData>(){

            @Override
            public AggregationData apply(Aggregation.Count arg) {
                return AggregationData.CountData.create(count);
            }
        }, new Function<Aggregation.Distribution, AggregationData>(){

            @Override
            public AggregationData apply(Aggregation.Distribution arg) {
                List<Double> bucketBoundaries = arg.getBucketBoundaries().getBoundaries();
                ArrayList<Long> buckets = Lists.newArrayList();
                if (distribution.getBucketCount() <= bucketBoundaries.size()) {
                    int index = 0;
                    for (Long bucket : distribution.getBucketList()) {
                        if (bucket < 0L) {
                            int i = 0;
                            while ((long)i < -bucket.longValue()) {
                                buckets.add(0L);
                                ++i;
                            }
                            index = (int)((long)index + -bucket.longValue());
                            continue;
                        }
                        buckets.add(bucket);
                        ++index;
                    }
                    for (int i = index; i <= bucketBoundaries.size(); ++i) {
                        buckets.add(0L);
                    }
                }
                return AggregationData.DistributionData.create(mean, count, distribution.getSumOfSquaredDeviation(), buckets);
            }
        }, Functions.throwAssertionError(), new Function<Aggregation, AggregationData>(){

            @Override
            public AggregationData apply(Aggregation arg) {
                if (arg instanceof Aggregation.Mean) {
                    return AggregationData.MeanData.create(mean, count);
                }
                throw new AssertionError();
            }
        });
    }

    private static Timestamp convertTimestamp(com.google.protobuf.Timestamp timestamp) {
        return Timestamp.create(timestamp.getSeconds(), timestamp.getNanos());
    }

    private static RpcUtil.Interval getDurationInterval(Duration duration) {
        if (duration.equals(MINUTE)) {
            return RpcUtil.Interval.MINUTE;
        }
        if (duration.equals(HOUR)) {
            return RpcUtil.Interval.HOUR;
        }
        String string = String.valueOf(duration);
        throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string).length()).append("Unsupported duration to convert to interval: ").append(string).toString());
    }

    @VisibleForTesting
    static List<TagValue> getTagValues(String viewTags, List<TagKey> keys) {
        String[] values = viewTags.split(INTERNAL_TAG_VALUE_DELIMITER);
        if (values.length != keys.size()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).atMostEvery(5, TimeUnit.MINUTES)).withInjectedLogSite("io/opencensus/impl/stats/ViewManagerImpl", "getTagValues", 275, "ViewManagerImpl.java")).log("Size of view tags %s not the same as size of keys %s", (Object)viewTags, keys);
            return new ArrayList<TagValue>();
        }
        ArrayList<TagValue> result = new ArrayList<TagValue>(values.length);
        for (String value : values) {
            result.add(TagValue.create(value));
        }
        return result;
    }

    static {
        RpcUtil.initializeRpcViews();
    }
}

