/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.tags;

import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.unsafe.ContextUtils;

final class CurrentTagContextUtils {
    private CurrentTagContextUtils() {
    }

    static TagContext getCurrentTagContext() {
        return ContextUtils.TAG_CONTEXT_KEY.get(Context.current());
    }

    static Scope withTagContext(TagContext tags) {
        return new WithTagContext(tags);
    }

    private static final class WithTagContext
    implements Scope {
        private final Context orig;

        private WithTagContext(TagContext tags) {
            this.orig = Context.current().withValue(ContextUtils.TAG_CONTEXT_KEY, tags).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.orig);
        }
    }
}

