/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.tags;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.monitoring.census.RpcUtil;
import com.google.monitoring.census.TagSet;
import com.google.monitoring.census.TagSetReplacer;
import io.opencensus.common.Scope;
import io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import io.opencensus.impl.tags.CurrentTagContextUtils;
import io.opencensus.impl.tags.TagContextImpl;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class TagContextBuilderImpl
extends TagContextBuilder {
    private final TagSet tags;
    private final TagSetReplacer tsr = new TagSetReplacer();
    private static final Map<String, String> CANONICAL_STATUS_TO_RPC_STATUS = TagContextBuilderImpl.createStatusMap();
    private static final TagValue OK_CANONICAL_STATUS = TagValue.create("OK");

    TagContextBuilderImpl() {
        this.tags = TagSet.getDefault();
    }

    TagContextBuilderImpl(TagSet tags) {
        this.tags = tags;
    }

    private static Map<String, String> createStatusMap() {
        HashMap<String, String> statuses = Maps.newHashMap();
        statuses.put("CANCELLED", "CANCELLED");
        statuses.put("UNKNOWN", "STREAM_BROKEN");
        statuses.put("INVALID_ARGUMENT", "CLIENT_ERROR");
        statuses.put("DEADLINE_EXCEEDED", "DEADLINE_EXCEEDED");
        statuses.put("NOT_FOUND", "CLIENT_ERROR");
        statuses.put("ALREADY_EXISTS", "CLIENT_ERROR");
        statuses.put("PERMISSION_DENIED", "CLIENT_ERROR");
        statuses.put("UNAUTHENTICATED", "CLIENT_ERROR");
        statuses.put("RESOURCE_EXHAUSTED", "SERVER_ERROR");
        statuses.put("FAILED_PRECONDITION", "CLIENT_ERROR");
        statuses.put("ABORTED", "STREAM_BROKEN");
        statuses.put("OUT_OF_RANGE", "CLIENT_ERROR");
        statuses.put("UNIMPLEMENTED", "CLIENT_ERROR");
        statuses.put("INTERNAL", "STREAM_BROKEN");
        statuses.put("UNAVAILABLE", "UNREACHABLE");
        statuses.put("DATA_LOSS", "SERVER_ERROR");
        return Collections.unmodifiableMap(statuses);
    }

    @Override
    public TagContextBuilderImpl put(TagKey key, TagValue value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        this.tsr.set(key.getName(), value.asString());
        if (key.equals(RpcMeasureConstants.RPC_STATUS) && !value.asString().isEmpty() && !value.equals(OK_CANONICAL_STATUS)) {
            String rpcStatus = TagContextBuilderImpl.canonicalStatusToRpcStatus(value);
            this.tsr.set("OpStatus", rpcStatus);
        } else if (key.equals(RpcMeasureConstants.RPC_METHOD)) {
            this.tsr.set("rpc", "grpc_java");
        }
        return this;
    }

    private static String canonicalStatusToRpcStatus(TagValue canonicalStatus) {
        String string;
        String rpcStatus = CANONICAL_STATUS_TO_RPC_STATUS.get(canonicalStatus.asString());
        if (rpcStatus != null) {
            string = rpcStatus;
        } else {
            String string2 = String.valueOf(canonicalStatus.asString());
            string = string2.length() != 0 ? "UNMAPPED_".concat(string2) : new String("UNMAPPED_");
        }
        return string;
    }

    @Override
    public TagContextBuilderImpl remove(TagKey key) {
        throw new UnsupportedOperationException("TagContextBuilderImpl.remove(TagKey)");
    }

    @Override
    public TagContextImpl build() {
        return new TagContextImpl(RpcUtil.buildWith((TagSetReplacer)this.tsr, (TagSet)this.tags));
    }

    @Override
    public Scope buildScoped() {
        return CurrentTagContextUtils.withTagContext(this.build());
    }
}

