/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.tags;

import com.google.common.collect.Multimap;
import com.google.monitoring.census.TagSet;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public final class TagContextImpl
extends TagContext {
    private final TagSet tags;

    public static final TagContextImpl getDefault() {
        return DefaultDelayedInitializer.DEFAULT;
    }

    public TagContextImpl(TagSet tags) {
        this.tags = tags;
    }

    public TagSet getTags() {
        return this.tags;
    }

    @Override
    protected Iterator<Tag> getIterator() {
        return new TagIterator(this.tags.asMultimap());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other instanceof TagContextImpl) {
            return this.getTags().equals((Object)((TagContextImpl)other).getTags());
        }
        return super.equals(other);
    }

    private static final class TagIterator
    implements Iterator<Tag> {
        Iterator<Map.Entry<String, String>> iterator;

        TagIterator(Multimap<String, String> tags) {
            this.iterator = tags.entries().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Tag next() {
            Map.Entry<String, String> next = this.iterator.next();
            TagKey key = TagKey.create(next.getKey());
            TagValue value = TagValue.create(next.getValue());
            return Tag.create(key, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TagIterator.remove()");
        }
    }

    private static final class DefaultDelayedInitializer {
        private static final TagContextImpl DEFAULT = new TagContextImpl(TagSet.getDefault());

        private DefaultDelayedInitializer() {
        }
    }
}

