/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.tags;

import io.opencensus.common.Scope;
import io.opencensus.impl.tags.CurrentTagContextUtils;
import io.opencensus.impl.tags.TagContextBuilderImpl;
import io.opencensus.impl.tags.TagContextImpl;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.Tagger;
import java.util.Iterator;

public final class TaggerImpl
extends Tagger {
    @Override
    public TagContextImpl empty() {
        return TagContextImpl.getDefault();
    }

    @Override
    public TagContextImpl getCurrentTagContext() {
        return TaggerImpl.toTagContextImpl(CurrentTagContextUtils.getCurrentTagContext());
    }

    @Override
    public TagContextBuilder emptyBuilder() {
        return new TagContextBuilderImpl();
    }

    @Override
    public TagContextBuilder currentBuilder() {
        return this.toBuilder(CurrentTagContextUtils.getCurrentTagContext());
    }

    @Override
    public TagContextBuilder toBuilder(TagContext tags) {
        return TaggerImpl.toTagContextBuilderImpl(tags);
    }

    @Override
    public Scope withTagContext(TagContext tags) {
        return CurrentTagContextUtils.withTagContext(TaggerImpl.toTagContextImpl(tags));
    }

    private static TagContextImpl toTagContextImpl(TagContext tags) {
        if (tags instanceof TagContextImpl) {
            return (TagContextImpl)tags;
        }
        Iterator<Tag> i = InternalUtils.getTags(tags);
        if (!i.hasNext()) {
            return TagContextImpl.getDefault();
        }
        TagContextBuilderImpl builder = new TagContextBuilderImpl();
        while (i.hasNext()) {
            Tag tag = i.next();
            if (tag == null) continue;
            builder.put(tag.getKey(), tag.getValue());
        }
        return builder.build();
    }

    private static TagContextBuilderImpl toTagContextBuilderImpl(TagContext tags) {
        if (tags instanceof TagContextImpl) {
            return new TagContextBuilderImpl(((TagContextImpl)tags).getTags());
        }
        TagContextBuilderImpl builder = new TagContextBuilderImpl();
        Iterator<Tag> i = InternalUtils.getTags(tags);
        while (i.hasNext()) {
            Tag tag = i.next();
            if (tag == null) continue;
            builder.put(tag.getKey(), tag.getValue());
        }
        return builder;
    }
}

