/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.tags.propagation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.io.base.VarInt;
import com.google.monitoring.census.RpcUtil;
import com.google.monitoring.census.TagSet;
import com.google.monitoring.census.TagSetReplacer;
import io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import io.opencensus.impl.tags.TagContextImpl;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.propagation.TagContextDeserializationException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Iterator;

final class SerializationUtils {
    @VisibleForTesting
    static final int VERSION_ID = 0;
    @VisibleForTesting
    static final int TAG_FIELD_ID = 0;
    private static final ImmutableSet<String> NON_PROPAGATING_TAGS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("method")).add("caller")).add("rpc")).add(RpcMeasureConstants.GRPC_CLIENT_METHOD.getName())).add(RpcMeasureConstants.GRPC_SERVER_METHOD.getName())).build();

    private SerializationUtils() {
    }

    static byte[] serializeBinary(TagContext tags) {
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.write(0);
        Iterator<Tag> i = InternalUtils.getTags(tags);
        while (i.hasNext()) {
            Tag tag = i.next();
            String key = tag.getKey().getName();
            if (NON_PROPAGATING_TAGS.contains(key)) continue;
            SerializationUtils.encodeTag(tag, byteArrayDataOutput);
        }
        return byteArrayDataOutput.toByteArray();
    }

    static TagContextImpl deserializeBinary(byte[] bytes) throws TagContextDeserializationException {
        try {
            if (bytes.length == 0) {
                throw new TagContextDeserializationException("Input byte[] can not be empty.");
            }
            ByteBuffer buffer = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
            byte versionId = buffer.get();
            if (versionId != 0) {
                throw new TagContextDeserializationException(new StringBuilder(64).append("Wrong Version ID: ").append(versionId).append(". Currently supported version is: ").append(0).toString());
            }
            TagSetReplacer builder = SerializationUtils.parseTags(buffer);
            return new TagContextImpl(RpcUtil.buildWith((TagSetReplacer)builder, (TagSet)TagSet.getDefault()));
        }
        catch (BufferUnderflowException exn) {
            throw new TagContextDeserializationException(exn.toString());
        }
    }

    private static TagSetReplacer parseTags(ByteBuffer buffer) throws TagContextDeserializationException {
        TagSetReplacer builder = new TagSetReplacer();
        int limit = buffer.limit();
        while (buffer.position() < limit) {
            byte type = buffer.get();
            if (type == 0) {
                TagKey key = SerializationUtils.createTagKey(SerializationUtils.decodeString(buffer));
                TagValue val = SerializationUtils.createTagValue(key, SerializationUtils.decodeString(buffer));
                builder.set(key.getName(), val.asString());
                continue;
            }
            return builder;
        }
        return builder;
    }

    private static final TagKey createTagKey(String name) throws TagContextDeserializationException {
        try {
            return TagKey.create(name);
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(name);
            throw new TagContextDeserializationException(string.length() != 0 ? "Invalid tag key: ".concat(string) : new String("Invalid tag key: "), e);
        }
    }

    private static final TagValue createTagValue(TagKey key, String value) throws TagContextDeserializationException {
        try {
            return TagValue.create(value);
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(key);
            throw new TagContextDeserializationException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(value).length()).append("Invalid tag value for key ").append(string).append(": ").append(value).toString(), e);
        }
    }

    private static final void encodeTag(Tag tag, ByteArrayDataOutput byteArrayDataOutput) {
        byteArrayDataOutput.write(0);
        SerializationUtils.encodeString(tag.getKey().getName(), byteArrayDataOutput);
        SerializationUtils.encodeString(tag.getValue().asString(), byteArrayDataOutput);
    }

    private static final void encodeString(String input, ByteArrayDataOutput byteArrayDataOutput) {
        SerializationUtils.putVarInt(input.length(), byteArrayDataOutput);
        byteArrayDataOutput.write(input.getBytes(Charsets.UTF_8));
    }

    private static final void putVarInt(int input, ByteArrayDataOutput byteArrayDataOutput) {
        byte[] output = new byte[VarInt.varIntSize(input)];
        VarInt.putVarInt(input, output, 0);
        byteArrayDataOutput.write(output);
    }

    private static final String decodeString(ByteBuffer buffer) {
        int length = VarInt.getVarInt(buffer);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)buffer.get());
        }
        return builder.toString();
    }
}

