/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.trace;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.tracing.TraceContext;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.Tracestate;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;

public class Google3SpanContext
extends SpanContext {
    private static final TraceOptions SAMPLED_TRACE_OPTIONS = TraceOptions.builder().setIsSampled(true).build();
    private static final TraceOptions NOT_SAMPLED_TRACE_OPTIONS = TraceOptions.builder().setIsSampled(false).build();
    @VisibleForTesting
    static final long DEFAULT_TRACE_ID_EXT = 0L;
    @VisibleForTesting
    static final Tracestate TRACESTATE_DEFAULT = Tracestate.builder().build();
    private final TraceContext traceContext;
    private final long traceIdExt;
    public static final Google3SpanContext INVALID = new Google3SpanContext(TraceContext.nullContext(), 0L);

    @VisibleForTesting
    public static Google3SpanContext create(TraceId traceId, SpanId spanId, int traceMask, double inverseSamplingProbability, SpanId parentSpanId) {
        ByteBuffer traceIdBuffer = ByteBuffer.wrap(traceId.getBytes()).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer spanIdBuffer = ByteBuffer.wrap(spanId.getBytes()).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer parentSpanIdBuffer = ByteBuffer.wrap(parentSpanId.getBytes()).order(ByteOrder.LITTLE_ENDIAN);
        return new Google3SpanContext(new TraceContext(spanIdBuffer.getLong(), parentSpanIdBuffer.getLong(), traceIdBuffer.getLong(), traceMask, null, null, null, inverseSamplingProbability), traceIdBuffer.getLong(8));
    }

    public static Google3SpanContext create(TraceContext traceContext, long traceIdExt) {
        return new Google3SpanContext(traceContext, traceIdExt);
    }

    public static Google3SpanContext create(TraceContext traceContext) {
        return new Google3SpanContext(traceContext, 0L);
    }

    @Override
    public TraceId getTraceId() {
        return TraceId.fromBytes(ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).putLong(this.traceContext.getTraceId()).putLong(this.traceIdExt).array());
    }

    @Override
    public SpanId getSpanId() {
        return SpanId.fromBytes(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.traceContext.getSpanId()).array());
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    SpanId getParentSpanId() {
        return SpanId.fromBytes(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.traceContext.getParentSpanId()).array());
    }

    @Override
    public boolean isValid() {
        return this.traceContext.getTraceId() != 0L && this.traceContext.getSpanId() != 0L;
    }

    public long getTraceIdExt() {
        return this.traceIdExt;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Google3SpanContext)) {
            return false;
        }
        Google3SpanContext that = (Google3SpanContext)obj;
        return this.traceIdExt == that.traceIdExt && Objects.equal(this.traceContext, that.traceContext);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.traceContext, this.traceIdExt);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("traceContext", this.traceContext).add("traceIdExt", this.traceIdExt).toString();
    }

    private Google3SpanContext(TraceContext traceContext, long traceIdExt) {
        super(TraceId.INVALID, SpanId.INVALID, traceContext.isTraced() ? SAMPLED_TRACE_OPTIONS : NOT_SAMPLED_TRACE_OPTIONS, TRACESTATE_DEFAULT);
        this.traceContext = traceContext;
        this.traceIdExt = traceIdExt;
    }
}

