/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.trace;

import com.google.common.stats.RequestFamily;
import com.google.common.stats.StatsRequest;
import com.google.protobuf.MessageLite;
import com.google.tracing.ChildSpanLink;
import com.google.tracing.ParentSpanLink;
import com.google.tracing.TraceContext;
import com.google.tracing.Tracer;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.impl.trace.Google3SpanContext;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Status;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;

public final class SpanImpl
extends Span {
    @Nullable
    private final StatsRequest statsRequest;
    private final TraceContext traceContext;
    private final boolean isRefCounted;
    private volatile boolean hasError = false;
    private static final EnumSet<Span.Options> RECORD_EVENTS_OPTION = EnumSet.of(Span.Options.RECORD_EVENTS);
    private static final EnumSet<Span.Options> NO_RECORD_EVENTS_OPTION = EnumSet.noneOf(Span.Options.class);

    private SpanImpl(SpanContext context, @Nullable EnumSet<Span.Options> options, @Nullable StatsRequest statsRequest, TraceContext traceContext, boolean isRefCounted) {
        super(context, options);
        this.statsRequest = statsRequest;
        this.traceContext = traceContext;
        this.isRefCounted = isRefCounted;
    }

    public static SpanImpl fromTraceContext(Object contextObj) {
        TraceContext context = (TraceContext)contextObj;
        Google3SpanContext spanContext = Google3SpanContext.create(context);
        return new SpanImpl(spanContext, context.isTraced() ? RECORD_EVENTS_OPTION : NO_RECORD_EVENTS_OPTION, null, context, false);
    }

    static SpanImpl fromTraceContextWithStatsRequest(TraceContext traceContext, boolean recordEvents, RequestFamily family, String method) {
        Google3SpanContext spanContext = Google3SpanContext.create(traceContext);
        traceContext.ref();
        if (recordEvents) {
            StatsRequest statsRequest = new StatsRequest();
            statsRequest.start(family, method);
            return new SpanImpl(spanContext, RECORD_EVENTS_OPTION, statsRequest, traceContext, true);
        }
        return new SpanImpl(spanContext, traceContext.isTraced() ? RECORD_EVENTS_OPTION : NO_RECORD_EVENTS_OPTION, null, traceContext, true);
    }

    @Override
    public void addAttributes(Map<String, AttributeValue> attributes) {
        if (!this.isRecordingEvents()) {
            return;
        }
        for (final Map.Entry<String, AttributeValue> attribute : attributes.entrySet()) {
            AttributeValue value = attribute.getValue();
            value.match(new Function<String, Void>(){

                @Override
                public Void apply(String strValue) {
                    SpanImpl.this.recordString((String)attribute.getKey(), strValue);
                    return null;
                }
            }, new Function<Boolean, Void>(){

                @Override
                public Void apply(Boolean boolValue) {
                    SpanImpl.this.recordBoolean((String)attribute.getKey(), boolValue);
                    return null;
                }
            }, new Function<Long, Void>(){

                @Override
                public Void apply(Long longValue) {
                    SpanImpl.this.recordLong((String)attribute.getKey(), longValue);
                    return null;
                }
            }, Functions.returnNull());
        }
    }

    @Override
    public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
        this.addAnnotation(Annotation.fromDescriptionAndAttributes(description, attributes));
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        this.recordWithStringConverter(annotation);
    }

    @Override
    public void addMessageEvent(MessageEvent messageEvent) {
        this.recordWithStringConverter(messageEvent);
    }

    @Override
    public void addLink(Link link) {
        if (!this.isRecordingEvents()) {
            return;
        }
        ByteBuffer traceIdBuffer = ByteBuffer.wrap(link.getTraceId().getBytes()).order(ByteOrder.LITTLE_ENDIAN);
        long traceIdLow = traceIdBuffer.getLong();
        long traceIdHigh = traceIdBuffer.getLong();
        long spanId = ByteBuffer.wrap(link.getSpanId().getBytes()).order(ByteOrder.LITTLE_ENDIAN).getLong();
        switch (link.getType()) {
            case CHILD_LINKED_SPAN: {
                ChildSpanLink childMessage = new ChildSpanLink();
                childMessage.setChildTraceId(traceIdLow);
                childMessage.setChildTraceIdHi(traceIdHigh);
                childMessage.setChildSpanId(spanId);
                this.recordMessage((MessageLite)childMessage);
                break;
            }
            case PARENT_LINKED_SPAN: {
                ParentSpanLink parentMessage = new ParentSpanLink();
                parentMessage.setParentTraceId(traceIdLow);
                parentMessage.setParentTraceIdHi(traceIdHigh);
                parentMessage.setParentSpanId(spanId);
                this.recordMessage((MessageLite)parentMessage);
            }
        }
    }

    @Override
    public void setStatus(Status status) {
        this.recordWithStringConverter(status);
        this.hasError = !status.isOk();
    }

    private boolean isRecordingEvents() {
        return this.getOptions().contains((Object)Span.Options.RECORD_EVENTS);
    }

    private void recordString(String key, String strValue) {
        if (this.statsRequest != null) {
            this.statsRequest.getTextChannel().recordString(key, strValue);
        }
        if (this.traceContext.isTraced()) {
            this.traceContext.getTracer().getTextChannel().recordString(key, strValue);
        }
    }

    private void recordBoolean(String key, boolean boolValue) {
        if (this.statsRequest != null) {
            this.statsRequest.getTextChannel().recordBoolean(key, boolValue);
        }
        if (this.traceContext.isTraced()) {
            this.traceContext.getTracer().getTextChannel().recordBoolean(key, boolValue);
        }
    }

    private void recordLong(String key, long longValue) {
        if (this.statsRequest != null) {
            this.statsRequest.getTextChannel().recordLong(key, longValue);
        }
        if (this.traceContext.isTraced()) {
            this.traceContext.getTracer().getTextChannel().recordLong(key, longValue);
        }
    }

    private void recordMessage(MessageLite msg) {
        if (this.statsRequest != null) {
            this.statsRequest.getTextChannel().recordMessage(msg);
        }
        if (this.traceContext.isTraced()) {
            this.traceContext.getTracer().getTextChannel().recordMessage(msg);
        }
    }

    private <T> void recordWithStringConverter(T o) {
        if (this.statsRequest != null) {
            this.statsRequest.getTextChannel().record(o, Tracer.Converter.ToStringConverter.toStringConverter());
        }
        if (this.traceContext.isTraced()) {
            this.traceContext.getTracer().getTextChannel().record(o, Tracer.Converter.ToStringConverter.toStringConverter());
        }
    }

    @Override
    public void end(EndSpanOptions options) {
        Status status = options.getStatus();
        if (status != null) {
            this.setStatus(status);
        }
        if (this.statsRequest != null && this.statsRequest.isStarted()) {
            this.statsRequest.stop(!this.hasError);
        }
        if (this.isRefCounted) {
            this.traceContext.unRef();
        }
    }

    @Nullable
    StatsRequest getStatsRequest() {
        return this.statsRequest;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }
}

