/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.trace.propagation;

import com.google.common.base.Preconditions;
import com.google.tracing.TraceContext;
import io.opencensus.impl.trace.Google3SpanContext;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.propagation.BinaryFormat;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;

final class BinaryFormatImpl
extends BinaryFormat {
    static final BinaryFormatImpl INSTANCE = new BinaryFormatImpl();
    private static final byte VERSION_ID = 0;
    private static final int VERSION_ID_OFFSET = 0;
    private static final byte ID_SIZE = 1;
    private static final byte TRACE_ID_FIELD_ID = 0;
    private static final int TRACE_ID_FIELD_ID_OFFSET = 1;
    private static final int TRACE_ID_OFFSET = 2;
    private static final byte SPAN_ID_FIELD_ID = 1;
    private static final int SPAN_ID_FIELD_ID_OFFSET = 18;
    private static final int SPAN_ID_OFFSET = 19;
    private static final byte TRACE_OPTION_FIELD_ID = 2;
    private static final byte TRACE_MASK_FIELD_ID = -4;
    private static final int TRACE_MASK_SIZE = 4;
    private static final int TRACE_MASK_FIELD_ID_OFFSET = 27;
    private static final int TRACE_MASK_OFFSET = 28;
    private static final byte INVERSE_SAMPLING_PROBABILITY_FIELD_ID = -3;
    private static final byte INVERSE_SAMPLING_PROBABILITY_SIZE = 4;
    private static final int INVERSE_SAMPLING_PROBABILITY_FIELD_ID_OFFSET = 32;
    private static final int INVERSE_SAMPLING_PROBABILITY_OFFSET = 33;
    private static final byte PARENT_SPAN_ID_FIELD_ID = -2;
    private static final int PARENT_SPAN_ID_FIELD_ID_OFFSET = 37;
    private static final int PARENT_SPAN_ID_OFFSET = 38;
    private static final int FORMAT_LENGTH = 46;

    @Override
    public byte[] toBinaryValue(SpanContext spanContext) {
        Preconditions.checkNotNull(spanContext, "spanContext");
        Preconditions.checkArgument(spanContext instanceof Google3SpanContext, "Google3SpanContext expected.");
        Google3SpanContext googleContext = (Google3SpanContext)spanContext;
        TraceContext traceContext = googleContext.getTraceContext();
        byte[] bytes = new byte[46];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        bytes[0] = 0;
        bytes[1] = 0;
        buffer.putLong(2, traceContext.getTraceId());
        buffer.putLong(10, googleContext.getTraceIdExt());
        bytes[18] = 1;
        buffer.putLong(19, traceContext.getSpanId());
        bytes[27] = -4;
        buffer.putInt(28, traceContext.getMask());
        bytes[32] = -3;
        buffer.putFloat(33, (float)traceContext.getInverseSamplingProbability());
        bytes[37] = -2;
        buffer.putLong(38, traceContext.getParentSpanId());
        return bytes;
    }

    @Override
    public SpanContext fromBinaryValue(byte[] bytes) throws ParseException {
        Preconditions.checkNotNull(bytes, "bytes");
        if (bytes.length == 0 || bytes[0] != 0) {
            throw new ParseException("Unsupported version.", 0);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        long traceId = 0L;
        long traceIdExt = 0L;
        long spanId = 0L;
        int traceMask = 0;
        double inverseSamplingProbability = 0.0;
        long parentSpanId = 0L;
        int pos = 1;
        try {
            if (bytes.length > pos && bytes[pos] == 0) {
                traceId = buffer.getLong(pos + 1);
                traceIdExt = buffer.getLong(pos + 1 + 8);
                pos += 17;
            }
            if (bytes.length > pos && bytes[pos] == 1) {
                spanId = buffer.getLong(pos + 1);
                pos += 9;
            }
            if (bytes.length > pos && bytes[pos] == 2) {
                pos += 2;
            }
            if (bytes.length > pos && bytes[pos] == -4) {
                traceMask = buffer.getInt(pos + 1);
                pos += 5;
            }
            if (bytes.length > pos && bytes[pos] == -3) {
                inverseSamplingProbability = buffer.getFloat(pos + 1);
                pos += 5;
            }
            if (bytes.length > pos && bytes[pos] == -2) {
                parentSpanId = buffer.getLong(pos + 1);
            }
            return Google3SpanContext.create(new TraceContext(spanId, parentSpanId, traceId, traceMask, null, null, null, inverseSamplingProbability), traceIdExt);
        }
        catch (IndexOutOfBoundsException e) {
            String string = String.valueOf(e.toString());
            throw new ParseException(string.length() != 0 ? "Invalid input: ".concat(string) : new String("Invalid input: "), pos);
        }
    }

    private BinaryFormatImpl() {
    }
}

