/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.stats;

import io.opencensus.stats.AggregationData;
import java.util.List;

final class AutoValue_AggregationData_DistributionData
extends AggregationData.DistributionData {
    private final double mean;
    private final long count;
    private final double sumOfSquaredDeviations;
    private final List<Long> bucketCounts;
    private final List<AggregationData.DistributionData.Exemplar> exemplars;

    AutoValue_AggregationData_DistributionData(double mean, long count, double sumOfSquaredDeviations, List<Long> bucketCounts, List<AggregationData.DistributionData.Exemplar> exemplars) {
        this.mean = mean;
        this.count = count;
        this.sumOfSquaredDeviations = sumOfSquaredDeviations;
        if (bucketCounts == null) {
            throw new NullPointerException("Null bucketCounts");
        }
        this.bucketCounts = bucketCounts;
        if (exemplars == null) {
            throw new NullPointerException("Null exemplars");
        }
        this.exemplars = exemplars;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getSumOfSquaredDeviations() {
        return this.sumOfSquaredDeviations;
    }

    @Override
    public List<Long> getBucketCounts() {
        return this.bucketCounts;
    }

    @Override
    public List<AggregationData.DistributionData.Exemplar> getExemplars() {
        return this.exemplars;
    }

    public String toString() {
        double d = this.mean;
        long l = this.count;
        double d2 = this.sumOfSquaredDeviations;
        String string = String.valueOf(this.bucketCounts);
        String string2 = String.valueOf(this.exemplars);
        return new StringBuilder(151 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DistributionData{mean=").append(d).append(", count=").append(l).append(", sumOfSquaredDeviations=").append(d2).append(", bucketCounts=").append(string).append(", exemplars=").append(string2).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationData.DistributionData) {
            AggregationData.DistributionData that = (AggregationData.DistributionData)o;
            return Double.doubleToLongBits(this.mean) == Double.doubleToLongBits(that.getMean()) && this.count == that.getCount() && Double.doubleToLongBits(this.sumOfSquaredDeviations) == Double.doubleToLongBits(that.getSumOfSquaredDeviations()) && this.bucketCounts.equals(that.getBucketCounts()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.mean) >>> 32 ^ Double.doubleToLongBits(this.mean));
        h$ *= 1000003;
        h$ ^= (int)(this.count >>> 32 ^ this.count);
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sumOfSquaredDeviations) >>> 32 ^ Double.doubleToLongBits(this.sumOfSquaredDeviations));
        h$ *= 1000003;
        h$ ^= this.bucketCounts.hashCode();
        h$ *= 1000003;
        return h$ ^= this.exemplars.hashCode();
    }
}

