/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.stats;

import io.opencensus.common.Timestamp;
import io.opencensus.stats.AggregationData;
import java.util.Map;

final class AutoValue_AggregationData_DistributionData_Exemplar
extends AggregationData.DistributionData.Exemplar {
    private final double value;
    private final Timestamp timestamp;
    private final Map<String, String> attachments;

    AutoValue_AggregationData_DistributionData_Exemplar(double value, Timestamp timestamp, Map<String, String> attachments) {
        this.value = value;
        if (timestamp == null) {
            throw new NullPointerException("Null timestamp");
        }
        this.timestamp = timestamp;
        if (attachments == null) {
            throw new NullPointerException("Null attachments");
        }
        this.attachments = attachments;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public String toString() {
        double d = this.value;
        String string = String.valueOf(this.timestamp);
        String string2 = String.valueOf(this.attachments);
        return new StringBuilder(66 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Exemplar{value=").append(d).append(", timestamp=").append(string).append(", attachments=").append(string2).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationData.DistributionData.Exemplar) {
            AggregationData.DistributionData.Exemplar that = (AggregationData.DistributionData.Exemplar)o;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.getValue()) && this.timestamp.equals(that.getTimestamp()) && this.attachments.equals(that.getAttachments());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value));
        h$ *= 1000003;
        h$ ^= this.timestamp.hashCode();
        h$ *= 1000003;
        return h$ ^= this.attachments.hashCode();
    }
}

